/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.indent;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFIndentScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public abstract class CFIndentScannerCommon
extends CFScopeScanner {
    protected int fTabWidth;
    private String fLineDelimiter;
    protected int fWrapThreshold;
    protected int fLineIndent;
    protected int fStrictIndent = -1;
    private int fPreTokenIndent;
    private int fIfFirstOnLineIndentLevelAdjustment;
    private boolean fInsideParams;
    private boolean fInsideParamsOpen;
    private boolean fInsideParamsClose;
    private boolean fParamsParenMerged;
    private boolean fEmptyParemList;
    private int fForceLineBreakByParam = -1;
    private int nofParams;
    private int untilFirstTokenInParam;
    private boolean alreadyOnAValidNL;
    private ArrayList<CFToken> paramList;
    protected ICFIndentScannerImpl fICFIndentScannerImpl;

    protected CFIndentScannerCommon(CFModel model, ICFIndentScannerImpl indentScannerImpl) {
        super(model, indentScannerImpl);
        this.fLineIndent = model.getFirstLineIndent();
        this.fStrictIndent = -1;
        this.fInsideParams = false;
        this.fInsideParamsOpen = false;
        this.fInsideParamsClose = false;
        this.fForceLineBreakByParam = -1;
        this.fICFIndentScannerImpl = indentScannerImpl;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
        this.fTabWidth = this.getTabWidth(sourceViewerConfiguration);
        this.fLineDelimiter = sourceViewerConfiguration.getLineDelimiter();
        this.fWrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
    }

    @Override
    public void startToken(CFToken token) {
        super.startToken(token);
        this.fPreTokenIndent = this.getNextLineIndent();
        this.fIfFirstOnLineIndentLevelAdjustment = 0;
    }

    @Override
    public void decrCurrLineIndentLevel(boolean isFirstOnLine) {
        super.decrCurrLineIndentLevel(isFirstOnLine);
        if (!isFirstOnLine) {
            --this.fIfFirstOnLineIndentLevelAdjustment;
        }
    }

    public int getCurrLineIndent() {
        if (this.fStrictIndent != -1) {
            return this.fStrictIndent;
        }
        return Math.max(this.fLineIndent + this.fCurrLineIndentLevel * this.fTabWidth, 0);
    }

    private int getNextLineIndent() {
        return Math.max(this.fLineIndent + this.fNextLineIndentLevel * this.fTabWidth, 0);
    }

    public void setNextLineIndentLevel(int nextLineIndent) {
        this.fNextLineIndentLevel = nextLineIndent;
    }

    private int getLineBreakIndent() {
        return this.fPreTokenIndent + this.fIfFirstOnLineIndentLevelAdjustment * this.fTabWidth;
    }

    public void setStrictIndent(int strictIndent) {
        this.fStrictIndent = strictIndent;
    }

    public void setLineIndent(int lineIndent) {
        this.fLineIndent = lineIndent;
    }

    public int getLineIndent() {
        return this.fLineIndent;
    }

    @Override
    protected void updateOnEndOfLine(int lineNo) {
        int currLineIndent = this.getCurrLineIndent();
        int nextLineIndent = this.getNextLineIndent();
        CFLineInfo lineInfo = this.fModel.getLineInfo(lineNo);
        if (lineInfo != null) {
            lineInfo.setIndent(currLineIndent);
        }
        this.fLineIndent = nextLineIndent;
        CFLineInfo nextLineInfo = this.fModel.getLineInfo(lineNo + 1);
        if (nextLineInfo != null) {
            nextLineInfo.setIndent(nextLineIndent);
        }
        this.fStrictIndent = -1;
        super.updateOnEndOfLine(lineNo);
    }

    @Override
    public void hookOnParenOpen4ParameterPrefs(CFToken token) {
        if (!this.fInsideParams && this.fICFIndentScannerImpl.allowParamPrefs() && this.fModel.getNofOpenParens() == 1) {
            this.fInsideParams = true;
            this.fInsideParamsOpen = true;
            this.fEmptyParemList = true;
            token = this.fICFIndentScannerImpl.getTokenForLineBreakBeforeParenOpen(token);
            if (this.fFormatPreferences.isMorePerLineIfLessThan()) {
                this.nofParams = 0;
                this.paramList = new ArrayList(0);
            }
            if (this.fFormatPreferences.isParamsPrefNewLineOpenParenNextLine()) {
                if (!token.isFirstNWSTokenOnLine()) {
                    this.createActionsForLineBreakBeforeToken(token, -1, "wrap param (");
                }
                this.fForceLineBreakByParam = 2;
                this.untilFirstTokenInParam = 2;
                return;
            }
            if (this.fFormatPreferences.isParamsPrefNewLineOpenParenSameLine()) {
                if (token.isFirstNWSTokenOnLine()) {
                    int lineNo = token.getLineNo();
                    if (lineNo == 1) {
                        return;
                    }
                    if (this.tryLineMerge(token, lineNo, true, "param new line open paren same line")) {
                        this.fParamsParenMerged = true;
                    }
                }
                this.fForceLineBreakByParam = 2;
                this.untilFirstTokenInParam = 2;
                return;
            }
        }
    }

    @Override
    protected void handleMorePerLineIfLessThan() {
        if (!this.fFormatPreferences.isMorePerLineIfLessThan() || this.paramList == null) {
            return;
        }
        int morePerLineIfLessThanThreshold = this.fFormatPreferences.getMorePerLineIfLessThanThreshold();
        for (CFToken token : this.paramList) {
            int lineIndent;
            CFLineInfo lineInfo;
            CFChunk chunk;
            if (token == null || (chunk = token.getEnclosingChunk()) == null || (lineInfo = chunk.getEnclosingLineInfo()) == null) continue;
            Object lineIndentObj = token.getMeta("lineIndent");
            int n = lineIndent = lineIndentObj == null ? this.getCurrLineIndent() : ((Integer)lineIndentObj).intValue();
            if (this.nofParams < morePerLineIfLessThanThreshold) {
                if (this.tryMorePerLine(token, chunk, lineInfo) || this.tryLineWrap(token)) continue;
                this.indentFirstNWSToken(token, lineInfo, lineIndent);
            }
            if (this.nofParams < morePerLineIfLessThanThreshold) continue;
            String tokenValue = token.getValue();
            boolean isFirstNWSTokenOnLine = token.isFirstNWSTokenOnLine();
            if (",".equals(tokenValue) || ";".equals(tokenValue)) {
                this.alreadyOnAValidNL = isFirstNWSTokenOnLine;
            }
            Object isFirstWordOfParamObj = token.getMeta("isFirstWordOfParam");
            boolean isFirstWordOfParam = false;
            if (isFirstWordOfParamObj != null) {
                isFirstWordOfParam = (Boolean)isFirstWordOfParamObj;
            }
            if (isFirstWordOfParam && !isFirstNWSTokenOnLine) {
                if (this.alreadyOnAValidNL) continue;
                this.createActionsForLineBreakBeforeToken(token, this.getLineBreakIndent(), "param more per line if less than");
                continue;
            }
            if (isFirstNWSTokenOnLine) {
                this.indentFirstNWSToken(token, lineInfo, lineIndent);
                continue;
            }
            if (!this.tryLineWrap(token)) continue;
        }
        this.paramList.clear();
    }

    @Override
    protected void hookOnParenClose4ParameterPrefs(CFToken token) {
        if (this.fInsideParams && this.fModel.getNofOpenParens() == 0) {
            this.fInsideParams = false;
            this.fInsideParamsClose = true;
            boolean isFirstNWSTokenOnLine = token.isFirstNWSTokenOnLine();
            if (this.fFormatPreferences.isMorePerLineIfLessThan()) {
                int morePerLineIfLessThanThreshold = this.fFormatPreferences.getMorePerLineIfLessThanThreshold();
                if (isFirstNWSTokenOnLine && this.nofParams < morePerLineIfLessThanThreshold) {
                    int lineNo = token.getLineNo();
                    if (lineNo == 1) {
                        return;
                    }
                    if (this.tryLineMerge(token, lineNo, false, "param more per line if less than")) {
                        this.fParamsParenMerged = true;
                    }
                }
                if (!isFirstNWSTokenOnLine && this.nofParams >= morePerLineIfLessThanThreshold) {
                    this.createActionsForLineBreakBeforeToken(token, -1, "wrap param )");
                }
                this.fForceLineBreakByParam = -1;
                return;
            }
            if (this.fFormatPreferences.isParamsPrefNewLineOpenParenNextLine()) {
                if (!isFirstNWSTokenOnLine) {
                    this.createActionsForLineBreakBeforeToken(token, -1, "wrap param )");
                }
                this.fForceLineBreakByParam = -1;
                return;
            }
            if (this.fFormatPreferences.isParamsPrefNewLineOpenParenSameLine()) {
                if (!isFirstNWSTokenOnLine && !this.fEmptyParemList) {
                    this.createActionsForLineBreakBeforeToken(token, -1, "wrap param )");
                }
                if (isFirstNWSTokenOnLine && this.fEmptyParemList) {
                    int lineNo = token.getLineNo();
                    if (lineNo == 1) {
                        return;
                    }
                    if (this.tryLineMerge(token, lineNo, false, "param new line open paren same line empty params list")) {
                        this.fParamsParenMerged = true;
                    }
                }
                this.fForceLineBreakByParam = -1;
                return;
            }
        }
    }

    @Override
    public void hookOnSeparator4ParameterPrefs(CFToken token) {
        CFScope peekScope = this.getPeekScopeIgnoreAssignmentOperators();
        if (peekScope == null) {
            return;
        }
        if (this.fInsideParams && this.fModel.getNofOpenParens() == 1 && "(".equals(peekScope.getScopeName()) && (this.fFormatPreferences.isParamsPrefNewLineOpenParenNextLine() || this.fFormatPreferences.isParamsPrefNewLineOpenParenSameLine())) {
            if (!token.isFirstNWSTokenOnLine()) {
                this.fForceLineBreakByParam = 2;
            }
            this.untilFirstTokenInParam = 2;
        }
    }

    public void indent(CFToken token) {
        String trimmedChunksContent;
        int lineNo = token.getLineNo();
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        int lineIndent = this.getCurrLineIndent();
        token.putMeta("lineIndent", lineIndent);
        StringBuilder sb = new StringBuilder();
        sb.append("CFIndentScanner.indent() line:").append(token.getLineNo()).append(" token:[").append(token.getValue()).append("]");
        CFSyso.println("INDENT", sb);
        if (chunk.endsWithNL() && (trimmedChunksContent = lineInfo.getChunksContent().trim()).isEmpty()) {
            return;
        }
        if (lineInfo.insertLineBreakBeforeToken()) {
            if (token.getTokenType() == 30) {
                lineInfo.setForceSLCommentWrap();
                lineInfo.resetInsertLineBreakBeforeToken();
            } else if (token.getTokenType() != 3 && token.getTokenType() != 40) {
                lineInfo.resetInsertLineBreakBeforeToken();
                this.createActionsForLineBreakBeforeToken(token, -1, "post ml comment wrap");
            }
        }
        boolean dontMergeParamPerLine = false;
        int morePerLineIfLessThanThreshold = this.fFormatPreferences.getMorePerLineIfLessThanThreshold();
        if (this.fFormatPreferences.isParamsPrefNewLine()) {
            if (token.getTokenType() != 3) {
                if (this.fForceLineBreakByParam > 0) {
                    --this.fForceLineBreakByParam;
                }
                if (this.untilFirstTokenInParam > 0) {
                    --this.untilFirstTokenInParam;
                }
            }
            if (token.getTokenType() != 3 && token.getTokenType() != 30 && token.getTokenType() != 40) {
                if (this.untilFirstTokenInParam == 0) {
                    ++this.nofParams;
                    this.untilFirstTokenInParam = -1;
                    token.putMeta("isFirstWordOfParam", true);
                }
                if (this.fForceLineBreakByParam == 0) {
                    this.fEmptyParemList = false;
                    this.fForceLineBreakByParam = -1;
                    if (!this.fFormatPreferences.isMorePerLineIfLessThan() || this.nofParams >= morePerLineIfLessThanThreshold) {
                        if (!token.isFirstNWSTokenOnLine()) {
                            this.createActionsForLineBreakBeforeToken(token, -1, "wrap param ,");
                        } else {
                            dontMergeParamPerLine = true;
                        }
                    }
                }
            }
            if (this.fFormatPreferences.isParamsPrefNewLineOpenParenSameLine() && this.fParamsParenMerged) {
                this.fParamsParenMerged = false;
                this.fInsideParamsOpen = false;
                return;
            }
        }
        if ((this.fFormatPreferences.isParamsPrefSameLine() || this.fFormatPreferences.isMorePerLineIfLessThan()) && (this.fInsideParams && !this.fInsideParamsOpen || this.fInsideParamsClose)) {
            if (this.fFormatPreferences.isMorePerLineIfLessThan() && this.nofParams < morePerLineIfLessThanThreshold && this.fInsideParams && !this.fInsideParamsOpen) {
                this.paramList.add(token);
                return;
            }
            if (this.fFormatPreferences.isParamsPrefSameLine() && this.tryMorePerLine(token, chunk, lineInfo)) {
                return;
            }
        }
        this.fInsideParamsOpen = false;
        this.fInsideParamsClose = false;
        if (this.tryElsePrefs(token)) {
            return;
        }
        if (this.tryLineWrap(token)) {
            return;
        }
        if (this.tryLineMerge(token, lineNo, lineInfo, dontMergeParamPerLine)) {
            return;
        }
        this.indentFirstNWSToken(token, lineInfo, lineIndent);
    }

    private boolean tryMorePerLine(CFToken token, CFChunk chunk, CFLineInfo lineInfo) {
        int lineNo = lineInfo.getLineNo();
        CFLineInfo prevLineInfo = this.fModel.getPrevNonWhitespaceLine(lineNo);
        if (prevLineInfo != null) {
            int tokenType = token.getTokenType();
            switch (tokenType) {
                case 3: {
                    this.removeWSTokenWhenMorePerLine(token, chunk, lineInfo);
                    break;
                }
                case 30: {
                    if (this.fFormatPreferences.isLineWrapSLCommentsEnabled()) break;
                    lineInfo.setCanBeMergedWith(false);
                    break;
                }
                default: {
                    if (!this.tryLineMerge(prevLineInfo, token, true, "wrap param merge")) break;
                    return true;
                }
            }
        }
        return false;
    }

    private void removeWSTokenWhenMorePerLine(CFToken token, CFChunk chunk, CFLineInfo lineInfo) {
        if (!(chunk.isFirstOnLine() && token.getStartOffsetInChunk() == 0 || lineInfo.getNLOffsetInLine() >= token.getStartOffsetInLine() && lineInfo.getNLOffsetInLine() <= token.getEndOffsetInLine())) {
            String tokenValue = token.getValue();
            int nofCharsToDelete = tokenValue.length() - 1;
            if (this.fFormatPreferences.isParamsPrefSameLine()) {
                if (nofCharsToDelete != 0) {
                    chunk.addAction(new CFAction(token.getStartOffsetInChunk(), nofCharsToDelete, "", "param same line compact whitespace"));
                }
                lineInfo.updateOnParamsCompactWS(token.getValue().length() - 1);
            }
        }
    }

    private void indentFirstNWSToken(CFToken token, CFLineInfo lineInfo, int lineIndent) {
        int preprocType;
        if (!token.isFirstNWSTokenOnLine()) {
            return;
        }
        if (token.getTokenType() == 30) {
            return;
        }
        if (!(this.fFormatPreferences.isPreprocPrefLeaveAsIs() || this.fFormatPreferences.isPreprocPrefResetIndent() || (preprocType = this.fStrategy.getPreprocType(token.getValue())) != 1 && preprocType != 3)) {
            return;
        }
        int lineStartWSLength = lineInfo.getLineStartWSLength();
        if (token.getTokenType() == 40 && !this.fFormatPreferences.isIndentMLCommentsEnabled()) {
            lineIndent = lineStartWSLength;
        }
        CFUtils.getInstance().indentLine(lineInfo, lineIndent, this.fModel.indentFirstLine(), "indent");
    }

    private boolean tryLineMerge(CFToken token, int lineNo, CFLineInfo lineInfo, boolean dontMergeParamPerLine) {
        if (dontMergeParamPerLine) {
            return false;
        }
        if (!this.fFormatPreferences.isLineWrapEnabled()) {
            return false;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return false;
        }
        if (this.fModel.getNofOpenParens() == 0) {
            return false;
        }
        CFLineInfo prevLineInfo = this.fModel.getLineInfo(lineNo - 1);
        return prevLineInfo != null && prevLineInfo.hasLineBreak() && (this.fModel.getNofOpenParens() != 1 || !lineInfo.startsWithChar('(')) && this.tryLineMerge(prevLineInfo, token, true, "wrap merge line");
    }

    private boolean tryLineWrap(CFToken token) {
        if (!this.fFormatPreferences.isLineWrapEnabled()) {
            return false;
        }
        if (token.isFirstNWSTokenOnLine()) {
            return false;
        }
        int tokenType = token.getTokenType();
        boolean wrapToken = tokenType == 30 && this.fFormatPreferences.isLineWrapSLCommentsEnabled() ? this.trySLCommentAbove(token) : (tokenType == 40 && this.fFormatPreferences.isLineWrapMLCommentsEnabled() ? this.tryMLCommentWrap(token) : this.tryLineBreak(token));
        return wrapToken;
    }

    private boolean tryElsePrefs(CFToken token) {
        return this.fICFIndentScannerImpl.tryElsePrefs(token);
    }

    public boolean tryElsePrefsDefaultImpl(CFToken token) {
        int keywordType;
        if (this.fFormatPreferences.isElsePrefNewLine() && !token.isFirstNWSTokenOnLine() && token.getTokenType() == 2 && (keywordType = this.fStrategy.getKeywordType(token.getValue())) == 5 && "else".equals(token.getValue())) {
            return this.tryElseOnNewLine(token);
        }
        if (this.fFormatPreferences.isElsePrefSameLine() && token.isFirstNWSTokenOnLine() && token.getTokenType() == 2 && (keywordType = this.fStrategy.getKeywordType(token.getValue())) == 5 && "else".equals(token.getValue())) {
            return this.tryElseOnSameLine(token);
        }
        return false;
    }

    public boolean tryElseOnNewLine(CFToken token) {
        if (token == null) {
            return false;
        }
        if (!this.allowLineBreak(token)) {
            return false;
        }
        if (token.isFirstNWSTokenOnLine()) {
            return false;
        }
        CFSyso.println("INDENT", "CFIndentScanner.tryElseOnNewLine(): " + token.getLineNo());
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        this.createActionsForLineBreakBeforeToken(token, Math.max(this.fLineIndent + (this.fNextLineIndentLevel - 1) * this.fTabWidth, 0), "else new line");
        return true;
    }

    protected boolean allowLineBreak(CFToken token) {
        return this.fICFIndentScannerImpl.allowLineBreak(token);
    }

    private boolean forceLineBreak(CFToken token) {
        return this.fICFIndentScannerImpl.forceLineBreak(token);
    }

    private boolean tryLineBreak(CFToken token) {
        int tokenLineIndent;
        if (token == null) {
            return false;
        }
        if (!this.allowLineBreak(token)) {
            return false;
        }
        if (token.isFirstNWSTokenOnLine()) {
            return false;
        }
        if (token.getTokenType() == 3) {
            return false;
        }
        int lineNo = token.getLineNo();
        CFLineInfo lineInfo = this.fModel.getLineInfo(lineNo);
        if (lineInfo == null) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        if (chunk.getType() == 3) {
            return false;
        }
        if (chunk.getType() == 4) {
            return false;
        }
        CFSyso.println("INDENT", "CFUIndentScanner.tryLineBreak():" + token.getValue());
        int tokenEndOffsetInLineAfterWS = token.getEndOffsetInLineAfterWS();
        if (!this.allowLineBreak(token)) {
            return false;
        }
        Object lineIndentObj = token.getMeta("lineIndent");
        int n = tokenLineIndent = lineIndentObj == null ? this.getCurrLineIndent() : ((Integer)lineIndentObj).intValue();
        if (this.forceLineBreak(token) || this.exceedsLineWrap(tokenEndOffsetInLineAfterWS, lineInfo, tokenLineIndent) && this.isLineBreakOffsetSmaller(token, lineInfo)) {
            this.createActionsForLineBreakBeforeToken(token, this.getLineBreakIndent(), "wrap line");
            return true;
        }
        return false;
    }

    protected void createActionsForLineBreakBeforeToken(CFToken token, int lineBreakIndent, String causedBy) {
        boolean done;
        CFChunk chunk;
        if (!this.allowLineBreak(token)) {
            return;
        }
        int lineNo = token.getLineNo();
        CFLineInfo lineInfo = this.fModel.getLineInfo(lineNo);
        if (lineInfo == null) {
            return;
        }
        if (lineBreakIndent == -1) {
            lineBreakIndent = this.getLineBreakIndent();
        }
        if ((chunk = token.getEnclosingChunk()) == null) {
            return;
        }
        if (this.isAssignmentOperator(token)) {
            this.fICFIndentScannerImpl.updateOnLineBreakBeforeOperator(token);
            lineBreakIndent = this.getLineBreakIndent();
        }
        if (!(done = CFUtils.getInstance().tryAddLineBreakBeforeNonCodePartition(chunk, this.fLineDelimiter, lineBreakIndent, causedBy))) {
            if (lineBreakIndent != 0) {
                chunk.addAction(new CFAction(2, token.getStartOffsetInChunk(), 0, CFUtils.getInstance().getWhitespace(lineBreakIndent), causedBy));
            }
            chunk.addAction(new CFAction(1, token.getStartOffsetInChunk(), 0, this.fLineDelimiter, causedBy));
        }
        lineInfo.updateOnLineBreak(token.getStartOffsetInLineAfterWS(), lineBreakIndent);
    }

    public boolean tryElseOnSameLine(CFToken token) {
        CFChunk beforePrevChunk;
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        CFSyso.println("INDENT", "CFIndentScanner.tryElseOnSameLine(): " + token.getLineNo());
        int lineNo = token.getLineNo();
        if (lineNo == 1) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        CFLineInfo prevLineInfo = this.fModel.getPrevNonWhitespaceLine(lineNo);
        if (prevLineInfo == null) {
            return false;
        }
        if (!this.allowElseOnSameLine(token)) {
            return false;
        }
        CFChunk prevLineLastChunk = prevLineInfo.getLastChunk();
        if (prevLineLastChunk == null) {
            return false;
        }
        if (prevLineLastChunk.getType() == 4) {
            return false;
        }
        if (prevLineLastChunk.getValue().trim().isEmpty() && ((beforePrevChunk = prevLineInfo.getChunkBefore(prevLineLastChunk)) == null || beforePrevChunk.getType() == 4)) {
            return false;
        }
        return this.tryLineMerge(prevLineInfo, token, true, "else same line");
    }

    private boolean allowElseOnSameLine(CFToken token) {
        return this.fICFIndentScannerImpl.allowElseOnSameLine(token);
    }

    private boolean tryLineMerge(CFToken token, int lineNoToMergeWith, boolean precedeWithSpace, String causedBy) {
        CFLineInfo appendToLineInfo = this.fModel.getPrevNonWhitespaceLine(lineNoToMergeWith);
        if (appendToLineInfo == null) {
            return false;
        }
        return this.tryLineMerge(appendToLineInfo, token, precedeWithSpace, causedBy);
    }

    private boolean tryLineMerge(CFLineInfo appendToLineInfo, CFToken token, boolean precedeWithSpace, String causedBy) {
        if (appendToLineInfo == null) {
            return false;
        }
        if (!appendToLineInfo.isFormatterOn()) {
            return false;
        }
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        if (!lineInfo.isFormatterOn()) {
            return false;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return false;
        }
        if (token.getTokenType() == 3) {
            return false;
        }
        int lineNo = token.getLineNo();
        if (lineNo == 1) {
            return false;
        }
        if (chunk.getType() == 3 || chunk.getType() == 4) {
            return false;
        }
        if (lineInfo.startsWithLiteralFragment()) {
            return false;
        }
        CFLineInfo prevLineInfo = this.fModel.getLineInfo(lineNo - 1);
        if (prevLineInfo == null) {
            return false;
        }
        CFChunk appendToLastChunk = prevLineInfo.getLastChunk();
        if (appendToLastChunk != null && appendToLastChunk.getType() == 3) {
            return false;
        }
        if (appendToLineInfo.getLastChunk().getType() == 4) {
            return false;
        }
        if (appendToLineInfo.containsPreproc()) {
            return false;
        }
        if (token.getTokenType() == 2 && this.fStrategy.getPreprocType(token.getValue()) != 0) {
            return false;
        }
        CFSyso.println("INDENT", "CFUIndentScanner.tryLineMerge():" + token.getValue());
        int tokenEndOffsetInLineAfterWS = token.getEndOffsetInLineAfterWS();
        int lineMergeOffsetAdjustmentForNextLine = appendToLineInfo.getNLOffsetInLineAfterWS() + appendToLineInfo.getLineMergeOffsetAdjustment() - appendToLineInfo.getLineBreakOffsetAdjustment();
        int prevLineCurrWrapIndent = appendToLineInfo.getCurrMergeIndent();
        int nofTailWSChars = appendToLineInfo.getNofTailWSChars();
        int whitespaceAdjustment = 1 - nofTailWSChars;
        if ((!this.fFormatPreferences.isLineWrapEnabled() || tokenEndOffsetInLineAfterWS + lineMergeOffsetAdjustmentForNextLine + prevLineCurrWrapIndent + whitespaceAdjustment <= this.fWrapThreshold) && appendToLineInfo.canBeMergedWith()) {
            boolean doMerge = true;
            CFChunk slCommentChunk = lineInfo.getLastChunk();
            if (this.fFormatPreferences.isLineWrapEnabled() && slCommentChunk != null && slCommentChunk.getType() == 3) {
                String slCommentValue = slCommentChunk.getValue();
                String slCommentValueNoTrailWS = slCommentValue.substring(0, slCommentValue.trim().length());
                int slCommentEndOffsetInInLineAfterWS = slCommentChunk.getStartOffsetInLineAfterWS() + slCommentValueNoTrailWS.length();
                if (slCommentEndOffsetInInLineAfterWS + lineMergeOffsetAdjustmentForNextLine + prevLineCurrWrapIndent + whitespaceAdjustment > this.fWrapThreshold) {
                    doMerge = false;
                    if (slCommentEndOffsetInInLineAfterWS + this.getCurrLineIndent() + whitespaceAdjustment > this.fWrapThreshold) {
                        lineInfo.setForceSLCommentWrap();
                        lineInfo.setCanBeMergedWith(true);
                    }
                }
            }
            if (doMerge) {
                this.createActionsForLineMerge(token, appendToLineInfo, precedeWithSpace, causedBy);
                lineInfo.updateOnLineMerge(lineMergeOffsetAdjustmentForNextLine + whitespaceAdjustment, prevLineCurrWrapIndent);
                return true;
            }
        }
        appendToLineInfo.setCanBeMergedWith(false);
        if (prevLineInfo.getChunksContent().trim().isEmpty()) {
            this.createActionsForLineMerge(token, appendToLineInfo, precedeWithSpace, causedBy);
        }
        return false;
    }

    private void createActionsForLineMerge(CFToken token, CFLineInfo prevNWSLine, boolean precedeWithSpace, String causedBy) {
        if (token == null) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        this.removePrevWSLines(token, causedBy);
        if (!prevNWSLine.canBeMergedWith()) {
            return;
        }
        this.removeCurrLineIndent(lineInfo, precedeWithSpace, causedBy);
    }

    private void removePrevWSLines(CFToken token, String causedBy) {
        if (token == null) {
            return;
        }
        int prevLineNo = token.getLineNo() - 1;
        CFLineInfo prevLineInfo = null;
        while (prevLineNo > 0) {
            prevLineInfo = this.fModel.getLineInfo(prevLineNo);
            if (prevLineInfo != null) {
                boolean prevLineIsEmpty = prevLineInfo.getChunksContent().trim().isEmpty();
                CFChunk prevLastChunk = prevLineInfo.getLastChunk();
                if (prevLastChunk != null && prevLastChunk.endsWithNL() && prevLineInfo.canBeMergedWith() && prevLastChunk.getType() != 3) {
                    prevLastChunk.addAction(new CFAction(prevLastChunk.getNLOffset(), prevLastChunk.getNLLength(), "", causedBy));
                    if (!prevLineIsEmpty) {
                        prevLineInfo.createActionsToDeleteTailWS();
                    } else {
                        prevLastChunk.addAction(new CFAction(0, prevLastChunk.getNLOffset(), "", causedBy));
                    }
                }
                if (!prevLineIsEmpty) break;
            }
            --prevLineNo;
        }
    }

    private void removeCurrLineIndent(CFLineInfo lineInfo, boolean precedeWithSpace, String causedBy) {
        if (lineInfo != null) {
            CFChunk indentableChunk = lineInfo.getIndentableChunk();
            int nofWSCharsToDelete = lineInfo.getLineStartWSLength();
            if (nofWSCharsToDelete != 1) {
                indentableChunk.addAction(new CFAction(0, nofWSCharsToDelete, precedeWithSpace ? " " : "", causedBy));
            }
        }
    }

    private boolean trySLCommentAbove(CFToken token) {
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        CFSyso.println("INDENT", "CFUIndentScanner.trySLCommentAbove():" + token.getValue());
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        String commentValue = token.getValue();
        String commentValueNoTrailWS = commentValue.substring(0, commentValue.trim().length());
        int slCommentEndOffsetInInLineAfterWS = token.getStartOffsetInLineAfterWS() + commentValueNoTrailWS.length();
        if (lineInfo.isForceSLCommentWrap() || this.exceedsLineWrap(slCommentEndOffsetInInLineAfterWS, lineInfo)) {
            int currLineIndent = this.getCurrLineIndent();
            CFChunk slCommentChunk = token.getEnclosingChunk();
            if (slCommentChunk == null) {
                return false;
            }
            CFChunk indentableChunk = lineInfo.getIndentableChunk();
            if (indentableChunk == null) {
                return false;
            }
            CFChunk prevCodeChunk = lineInfo.getChunkBefore(token.getEnclosingChunk());
            if (prevCodeChunk == null) {
                return false;
            }
            if (commentValueNoTrailWS.length() < 2) {
                return false;
            }
            String slCommentPrefix = commentValueNoTrailWS.substring(0, 2);
            List<String> slCommentWrapStrings = CFUtils.getInstance().splitComment(commentValueNoTrailWS, true, currLineIndent, currLineIndent, this.fWrapThreshold);
            CFPartition partition = indentableChunk.getEnclosingPartition();
            if (partition != null) {
                partition.createSLCommentAboveSubPartitions(slCommentWrapStrings, slCommentPrefix, currLineIndent, indentableChunk);
            }
            slCommentChunk.addAction(new CFAction(0, slCommentChunk.getLength() - slCommentChunk.getNLLength(), "", "sl comment wrap above"));
            slCommentChunk.setType(1);
            CFLineInfo slCommentLineInfo = slCommentChunk.getEnclosingLineInfo();
            if (slCommentLineInfo != null) {
                slCommentLineInfo.updateOnSLCommentWrap(slCommentChunk);
            }
            return true;
        }
        return false;
    }

    private boolean tryMLCommentWrap(CFToken token) {
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        CFSyso.println("INDENT", "CFUIndentScanner.tryMLCommentWrap():" + token.getValue());
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        String commentValue = token.getValue();
        String commentValueNoTrailWS = commentValue.substring(0, commentValue.trim().length());
        int commentEndOffsetInInLineAfterWS = token.getStartOffsetInLineAfterWS() + commentValueNoTrailWS.length();
        if (this.exceedsLineWrap(commentEndOffsetInInLineAfterWS, lineInfo)) {
            this.createActionsForLineBreakBeforeToken(token, -1, "pre ml comment wrap");
            CFChunk chunkAfter = lineInfo.getChunkAfter(chunk);
            if (chunkAfter != null) {
                lineInfo.setInsertLineBreakBeforeToken();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isOnTheSameLineWithCurrentScope(CFToken token) {
        CFScope peekScope = this.getPeekScope();
        if (peekScope == null || token == null) {
            return false;
        }
        if (peekScope.getLineNo() != token.getLineNo()) {
            return false;
        }
        if (this.fFormatPreferences.isLineWrapEnabled() && !token.isFirstNWSTokenOnLine()) {
            if (!this.allowLineBreak(token)) {
                return true;
            }
            int tokenEndOffsetInLineAfterWS = token.getEndOffsetInLineAfterWS();
            CFChunk chunk = token.getEnclosingChunk();
            CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
            if (this.forceLineBreak(token) || this.exceedsLineWrap(tokenEndOffsetInLineAfterWS, lineInfo) && this.isLineBreakOffsetSmaller(token, lineInfo)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean exceedsLineWrap(int endOffsetInLineAfterWS, CFLineInfo lineInfo) {
        return this.getAdjustedOffsetInLineAfterWS(endOffsetInLineAfterWS, lineInfo, this.getCurrLineIndent()) > this.fWrapThreshold;
    }

    public boolean exceedsLineWrap(int endOffsetInLineAfterWS, CFLineInfo lineInfo, int tokenLineIndent) {
        return this.getAdjustedOffsetInLineAfterWS(endOffsetInLineAfterWS, lineInfo, tokenLineIndent) > this.fWrapThreshold;
    }

    private boolean isLineBreakOffsetSmaller(CFToken token, CFLineInfo lineInfo) {
        if (token == null) {
            return false;
        }
        int adjustedTokenStartOffsetInLineAfterWS = this.getAdjustedOffsetInLineAfterWS(token.getStartOffsetInLineAfterWS(), lineInfo, this.getCurrLineIndent());
        int lineBreakIndent = this.getLineBreakIndent();
        return lineBreakIndent < adjustedTokenStartOffsetInLineAfterWS;
    }

    private int getAdjustedOffsetInLineAfterWS(int endOffsetInLineAfterWS, CFLineInfo lineInfo, int indent) {
        return endOffsetInLineAfterWS + lineInfo.getLineMergeOffsetAdjustment() - lineInfo.getLineBreakOffsetAdjustment() + lineInfo.getCurrWrapIndent(indent);
    }

    public int getTabWidth(DVTSourceViewerConfiguration sourceViewerConfiguration) {
        return sourceViewerConfiguration.getTabWidth();
    }

    public boolean tryAddWhitespaceBefore(CFToken token) {
        if (token == null) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        String tokenValue = token.getValue();
        Set<String> addWSBeforePref = this.fStrategy.getAddWSBeforePref();
        if (addWSBeforePref == null) {
            return false;
        }
        if (addWSBeforePref.contains(tokenValue) && this.fStrategy.allowWhitespaceBeforeToken(token)) {
            int tokenStartOffsetInChunk = token.getStartOffsetInChunk();
            String chunkValue = chunk.getValue();
            if (chunkValue == null) {
                return false;
            }
            char prevChar = '\u0000';
            if (tokenStartOffsetInChunk - 1 >= 0) {
                prevChar = chunkValue.charAt(tokenStartOffsetInChunk - 1);
            }
            int prevNWSChar = 0;
            if (tokenStartOffsetInChunk - 1 >= 0) {
                prevNWSChar = this.getPrevNWSCharInChunk(chunk, tokenStartOffsetInChunk - 1);
            }
            if (!Character.isWhitespace(prevChar) && prevNWSChar != 36) {
                chunk.addAction(new CFAction(tokenStartOffsetInChunk, 0, " ", "add whitespace before"));
            }
            return true;
        }
        return false;
    }

    private char getPrevNWSCharInChunk(CFChunk chunk, int offset) {
        if (chunk == null) {
            return '\u0000';
        }
        String chunkValue = chunk.getValue();
        if (chunkValue == null) {
            return '\u0000';
        }
        int i = offset;
        while (i >= 0) {
            char charAt = chunkValue.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                return charAt;
            }
            --i;
        }
        return '\u0000';
    }

    public boolean tryAddWhitespaceAfter(CFToken token) {
        if (token == null) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        String tokenValue = token.getValue();
        Set<String> addWSAfterPref = this.fStrategy.getAddWSAfterPref();
        if (addWSAfterPref == null) {
            return false;
        }
        if (addWSAfterPref.contains(tokenValue) && this.fStrategy.allowWhitespaceAfterToken(token)) {
            int tokenEndOffsetInChunk = token.getEndOffsetInChunk();
            String chunkValue = chunk.getValue();
            if (chunkValue == null) {
                return false;
            }
            char nextChar = '\u0000';
            if (tokenEndOffsetInChunk < chunkValue.length()) {
                nextChar = chunkValue.charAt(tokenEndOffsetInChunk);
            }
            if (!Character.isWhitespace(nextChar)) {
                chunk.addAction(new CFAction(tokenEndOffsetInChunk, 0, " ", "add whitespace after"));
            }
            return true;
        }
        return false;
    }
}

