/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.vertical;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVParenTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public class CFVParenScanner
extends CFScopeScanner {
    private Set<String> fOpenChars;
    private Set<String> fCloseChars;
    private ICFVParenTokenScannerImpl fScopeScannerImpl;
    private CFToken fPrevNWSToken;

    public CFVParenScanner(CFModel model, ICFVParenTokenScannerImpl scopeScannerImpl) {
        super(model, scopeScannerImpl);
        this.fScopeScannerImpl = scopeScannerImpl;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        if (this.fOpenChars == null) {
            this.fOpenChars = new HashSet<String>();
        }
        if (this.fCloseChars == null) {
            this.fCloseChars = new HashSet<String>();
        }
        if (this.fFormatPreferences.isVerticalAlignParenEnabled()) {
            this.fOpenChars.add("(");
            this.fCloseChars.add(")");
        }
        if (this.fFormatPreferences.isVerticalAlignCurlyEnabled()) {
            this.fOpenChars.add("{");
            this.fCloseChars.add("}");
        }
    }

    private boolean isOpenVParenChar(CFToken token) {
        return this.fScopeScannerImpl.isOpenVParenChar(token, this.fOpenChars);
    }

    private boolean isCloseVParenChar(CFToken token) {
        if (this.fCloseChars == null || token == null) {
            return false;
        }
        return this.fCloseChars.contains(token.getValue());
    }

    public void align(CFToken token) {
        if (token != null && token.isOnSensibleLine()) {
            return;
        }
        if (token != null && token.getTokenType() != 3) {
            CFLineInfo lineInfo;
            if (token.isFirstNWSTokenOnLine()) {
                this.alignFirstNWSOnLine(token);
            } else {
                this.removeWSAfterParen(token);
            }
            this.fPrevNWSToken = token;
            CFChunk chunk = token.getEnclosingChunk();
            if (chunk != null && (lineInfo = chunk.getEnclosingLineInfo()) != null && this.isOpenVParenChar(token)) {
                token.putMeta("delDelta", lineInfo.getVParenDelDelta());
                boolean shouldInsertWSAfterToken = this.fStrategy.isAddWhitespaceAfterToken(token);
                if (shouldInsertWSAfterToken) {
                    token.putMeta("extraWS", true);
                }
            }
        }
    }

    private void removeWSAfterParen(CFToken token) {
        if (token == null || this.fPrevNWSToken == null) {
            return;
        }
        if (token.getTokenType() == 3) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.isVerticalAlignedByRegex()) {
            return;
        }
        CFChunk prevNWSTokenChunk = this.fPrevNWSToken.getEnclosingChunk();
        if (prevNWSTokenChunk != chunk) {
            return;
        }
        if (!this.hasDelDelta(this.fPrevNWSToken)) {
            return;
        }
        CFScope peekScope = this.getPeekScope();
        if (peekScope == null) {
            return;
        }
        CFToken peekToken = peekScope.getToken();
        if (peekToken == null) {
            return;
        }
        if (peekToken != this.fPrevNWSToken) {
            return;
        }
        int delta = token.getStartOffsetInChunk() - peekToken.getStartOffsetInChunk() - (this.fStrategy.isAddWhitespaceAfterToken(peekToken) ? 2 : 1);
        if (delta > 0) {
            chunk.addAction(new CFAction(peekToken.getStartOffsetInChunk() + 1, delta, "", "paren vertical align"));
            lineInfo.addVParenDelDelta(-delta);
        }
    }

    private void alignFirstNWSOnLine(CFToken token) {
        if (token == null) {
            return;
        }
        if (token.isOnSensibleLine()) {
            return;
        }
        if (token.getTokenType() == 3) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.isVerticalAlignedByRegex()) {
            return;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return;
        }
        if (chunk.getType() != 1 && chunk.getType() != 2 && chunk.getType() != 4) {
            return;
        }
        if (chunk.getType() == 2 && chunk.isLiteralFragment()) {
            return;
        }
        CFScope peekScope = this.getPeekScopeIgnoreAssignmentOperators();
        if (peekScope == null) {
            return;
        }
        CFToken peekToken = peekScope.getToken();
        if (peekToken == null) {
            return;
        }
        if (!this.hasDelDelta(peekToken)) {
            return;
        }
        CFChunk peekChunk = peekToken.getEnclosingChunk();
        if (peekChunk == null) {
            return;
        }
        CFLineInfo peekLineInfo = peekChunk.getEnclosingLineInfo();
        if (peekLineInfo == null) {
            return;
        }
        Integer delDelta = (Integer)peekToken.getMeta("delDelta");
        int toOffsetInLine = peekToken.getStartOffsetInLine() + peekLineInfo.getVParenDelta() + delDelta;
        int nofWSCharsToInsert = toOffsetInLine - token.getStartOffsetInLine() + (this.isCloseVParenChar(token) ? 0 : 1);
        Object meta = peekToken.getMeta("extraWS");
        if (meta != null && meta.equals(true) && !this.isCloseVParenChar(token)) {
            ++nofWSCharsToInsert;
        }
        if (nofWSCharsToInsert > 0) {
            if (this.fFormatPreferences.isLineWrapEnabled()) {
                DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
                int wrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
                int nofTailWSChars = 0;
                if (this.fFormatPreferences.isTrimEndOfLineWSEnabled()) {
                    nofTailWSChars = lineInfo.getNofTailWSChars();
                }
                if (lineInfo.getNLOffsetInLine() + nofWSCharsToInsert - nofTailWSChars > wrapThreshold) {
                    return;
                }
            }
            boolean done = false;
            CFPartition partition = chunk.getEnclosingPartition();
            if (partition != null && partition.isFirstChunk(chunk) && chunk.getType() != 1) {
                done = CFUtils.getInstance().tryAddWhitespaceBeforeNonCodePartition(chunk, nofWSCharsToInsert, "paren vertical align");
            }
            if (!done) {
                chunk.addAction(new CFAction(token.getStartOffsetInChunk(), 0, CFUtils.getInstance().getWhitespace(nofWSCharsToInsert), "paren vertical align"));
            }
        }
        if (nofWSCharsToInsert < 0) {
            CFChunk prevChunk;
            CFChunk deleteWSChunk = chunk;
            if (chunk.getType() != 1 && (prevChunk = lineInfo.getChunkBefore(chunk)) != null && prevChunk.getType() == 1) {
                deleteWSChunk = prevChunk;
            }
            deleteWSChunk.addAction(new CFAction(0, -nofWSCharsToInsert, "", "paren vertical align"));
        }
        lineInfo.setVParenDelta(nofWSCharsToInsert);
    }

    private boolean hasDelDelta(CFToken token) {
        return token.getMeta("delDelta") != null;
    }
}

