/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.vertical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public class CFVScanner
extends CFScopeScanner {
    private ICFVTokenScannerImpl fICFVTokenScannerImpl;
    private int fVScopeId = 0;
    private int fVScopeLevel = 0;
    private Map<CFVScope, List<CFVToken>> fVScopes = new HashMap<CFVScope, List<CFVToken>>();
    private CFVScope fTopVScope = new CFVScope(null, "TOP", CFScope.BLOCK_SCOPE, CFScope.NO_INDENT, this.fVScopeId, this.fVScopeLevel, 0);
    private List<CFVToken> fVTokensInThisChunk;

    public CFVScanner(CFModel model, ICFVTokenScannerImpl vScannerImpl) {
        super(model, vScannerImpl);
        this.fICFVTokenScannerImpl = vScannerImpl;
    }

    public int getVScopeId() {
        return this.fVScopeId;
    }

    public void setVScopeId(int vScopeId) {
        this.fVScopeId = vScopeId;
    }

    public int getVScopeLevel() {
        return this.fVScopeLevel;
    }

    public void setVScopeLevel(int vScopeLevel) {
        this.fVScopeLevel = vScopeLevel;
    }

    public void verticalAlignStartChunk(CFChunk chunk) {
        super.startChunk(chunk);
        this.fVTokensInThisChunk = new ArrayList<CFVToken>();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.containsComplexPreproc()) {
            return;
        }
        if (lineInfo.isVerticalAlignedByRegex()) {
            return;
        }
        String chunkValue = chunk.getValue();
        if (chunkValue == null) {
            return;
        }
        CFVScope currentVScope = this.getCurrentVScope();
        List<String> vAlignTokensPref = this.fStrategy.getVAlignTokensPref();
        if (vAlignTokensPref == null || vAlignTokensPref.isEmpty()) {
            return;
        }
        int charIndex = 0;
        while (charIndex < chunkValue.length()) {
            for (String vTokenString : vAlignTokensPref) {
                if (!this.fStrategy.isValidVAlignWithoutBoundary(vTokenString) && charIndex != 0 && !this.fStrategy.isValidVAlignBoundaryChar(vTokenString, chunkValue.charAt(charIndex - 1), true) || charIndex > 0 && !this.fStrategy.isValidVAlignContext(chunkValue.charAt(charIndex - 1), vTokenString) || !chunkValue.startsWith(vTokenString, charIndex) || ":".equals(vTokenString) && CFUtils.getInstance().colonDelimitsLabel(chunkValue, this.fStrategy)) continue;
                int postCharIndex = charIndex + vTokenString.length();
                if (!this.fStrategy.isValidVAlignWithoutBoundary(vTokenString) && postCharIndex <= chunkValue.length() - 1 && !this.fStrategy.isValidVAlignBoundaryChar(vTokenString, chunkValue.charAt(postCharIndex), false)) continue;
                CFSyso.println("VALIGN", "new V token" + vTokenString + " line: " + lineInfo.getLineNo() + " offset: " + charIndex);
                CFVToken vToken = new CFVToken(vTokenString, chunk, charIndex, lineInfo.getNofVTokens());
                vToken.setVScope(currentVScope);
                this.fVTokensInThisChunk.add(vToken);
                lineInfo.addVToken(vToken);
                charIndex += vTokenString.length() - 1;
                break;
            }
            ++charIndex;
        }
    }

    public void verticalAlignEndChunk(CFChunk chunk) {
        super.endChunk(chunk);
        for (CFVToken vToken : this.fVTokensInThisChunk) {
            if (vToken == null) continue;
            this.addVToken(vToken);
        }
    }

    public void verticalAlignStartToken(CFToken token) {
        if (token.isOnSensibleLine()) {
            return;
        }
        CFVScope currentVScope = this.getCurrentVScope();
        if (currentVScope == null) {
            return;
        }
        if (token.getTokenType() == 30) {
            if (!this.fFormatPreferences.isVerticalAlignSLCommentsEnabled()) {
                return;
            }
            if (token.isFirstNWSTokenOnLine()) {
                return;
            }
            if (this.isPrevKeywordCodeBlockDelimiter()) {
                return;
            }
            CFChunk chunk = token.getEnclosingChunk();
            if (chunk == null) {
                return;
            }
            CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
            if (lineInfo == null) {
                return;
            }
            if (lineInfo.isVerticalAlignedByRegex()) {
                return;
            }
            CFVToken vToken = new CFVToken("//", chunk, token.getStartOffsetInChunk(), 1000);
            vToken.setVScope(currentVScope);
            CFSyso.println("VALIGN", "// line: " + lineInfo.getLineNo() + " offset: " + token.getStartOffsetInChunk());
            lineInfo.addVToken(vToken);
            this.addVToken(vToken);
            return;
        }
        for (CFVToken vToken : this.fVTokensInThisChunk) {
            CFScope prePeekScope;
            if (vToken == null) continue;
            if (token.getStartOffsetInLine() <= vToken.getStartOffsetInLine()) {
                vToken.setVScope(currentVScope);
            }
            if (!("]".equals(vToken.getValue()) && token.getStartOffsetInLine() == vToken.getStartOffsetInLine() || ")".equals(vToken.getValue()) && token.getStartOffsetInLine() == vToken.getStartOffsetInLine()) && (!"}".equals(vToken.getValue()) || token.getStartOffsetInLine() != vToken.getStartOffsetInLine()) || (prePeekScope = this.getPrePeekScopeIgnoreAssignmentOperators()) == null) continue;
            vToken.setVScope((CFVScope)prePeekScope);
        }
    }

    private boolean isPrevKeywordCodeBlockDelimiter() {
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
        if (sourceViewerConfiguration == null) {
            return false;
        }
        DVTBaseCodeFormattingStrategy codeFormattingStrategy = sourceViewerConfiguration.getCodeFormattingStrategy();
        if (codeFormattingStrategy == null) {
            return false;
        }
        String prevKeywordToken = this.fICFVTokenScannerImpl.getPrevKeywordToken();
        int nofOpenParensUntilScope = this.getNofOpenParensUntilScope(new HashSet<String>(), "(");
        if (codeFormattingStrategy.isOpenCodeBlockKeyword(prevKeywordToken) && nofOpenParensUntilScope == 0) {
            return true;
        }
        return codeFormattingStrategy.isCloseCodeBlockKeyword(prevKeywordToken);
    }

    public void verticalAlignEndToken(CFToken token) {
    }

    @Override
    protected CFScope createScope(CFToken token, String scopeName, boolean isShortScope, int indentKind) {
        return this.fICFVTokenScannerImpl.createVScope(token, scopeName, isShortScope, indentKind);
    }

    public CFVScope getCurrentVScope() {
        CFScope peekScope = this.getPeekScopeIgnoreAssignmentOperators();
        if (peekScope == null) {
            return this.fTopVScope;
        }
        return (CFVScope)peekScope;
    }

    private void addVToken(CFVToken vToken) {
        if (vToken == null) {
            return;
        }
        CFVScope vScope = vToken.getVScope();
        if (vScope == null) {
            return;
        }
        List<CFVToken> lofVTokensInScope = this.fVScopes.get(vScope);
        if (lofVTokensInScope == null) {
            lofVTokensInScope = new ArrayList<CFVToken>();
            this.fVScopes.put(vScope, lofVTokensInScope);
        }
        lofVTokensInScope.add(vToken);
    }

    public void verticalAlign() {
        ArrayList<CFVScope> sortedVScopes = new ArrayList<CFVScope>(this.fVScopes.keySet());
        Collections.sort(sortedVScopes, new Comparator<CFVScope>(){

            @Override
            public int compare(CFVScope o1, CFVScope o2) {
                if (o1.getVScopeId() > o2.getVScopeId()) {
                    return 1;
                }
                if (o1.getVScopeId() < o2.getVScopeId()) {
                    return -1;
                }
                if (o1.getVScopeLevel() > o2.getVScopeLevel()) {
                    return 1;
                }
                if (o1.getVScopeLevel() < o2.getVScopeLevel()) {
                    return -1;
                }
                return 0;
            }
        });
        for (CFVScope vScope : sortedVScopes) {
            List<CFVToken> lofVTokensInScope = this.fVScopes.get(vScope);
            ArrayList<CFVToken> notIgnoredVTokens = new ArrayList<CFVToken>();
            for (CFVToken vToken : lofVTokensInScope) {
                if (vToken == null || !vToken.getEnclosingLineInfo().isFormatterOn() || vToken.isIgnored()) continue;
                notIgnoredVTokens.add(vToken);
            }
            lofVTokensInScope = notIgnoredVTokens;
            int currentVDepth = 0;
            while (!lofVTokensInScope.isEmpty()) {
                ArrayList<CFVToken> vDepthTokens = new ArrayList<CFVToken>();
                int nextVDepth = -1000;
                int maxOffsetInLine = 0;
                boolean revisitCurrentDepth = false;
                String currentVTokenValue = null;
                for (CFVToken vToken : lofVTokensInScope) {
                    if (vToken == null) continue;
                    int tokenVDepth = vToken.getVDepth();
                    CFLineInfo lineInfo = vToken.getEnclosingLineInfo();
                    List<CFVToken> prevVTokens = lineInfo.getVTokensBefore(vToken.getVDepth());
                    for (CFVToken prevVToken : prevVTokens) {
                        if (prevVToken.getVScope().getVScopeId() <= vToken.getVScope().getVScopeId()) continue;
                        prevVToken.setIgnored();
                        if (tokenVDepth == 1000) continue;
                        --tokenVDepth;
                    }
                    if (currentVDepth == tokenVDepth) {
                        CFVToken vTokenBefore;
                        int vTokenBeforeLineNo;
                        int vTokenLineNo;
                        if (currentVTokenValue != null && !currentVTokenValue.equals(vToken.getValue())) {
                            revisitCurrentDepth = true;
                            continue;
                        }
                        currentVTokenValue = vToken.getValue();
                        boolean consecutiveLines = true;
                        if (this.fFormatPreferences.isVerticalAlignConsecutiveLines() && !vDepthTokens.isEmpty() && (vTokenLineNo = vToken.getEnclosingLineInfo().getLineNo()) > (vTokenBeforeLineNo = (vTokenBefore = (CFVToken)vDepthTokens.get(vDepthTokens.size() - 1)).getEnclosingLineInfo().getLineNo()) + 1) {
                            boolean onlyGlueLinesInBetween = true;
                            int i = vTokenBeforeLineNo + 1;
                            while (i < vTokenLineNo) {
                                CFLineInfo iLineInfo = this.fModel.getLineInfo(i);
                                String iLineContent = iLineInfo.getChunksContent();
                                if (iLineContent != null) {
                                    if (iLineContent.trim().isEmpty()) {
                                        onlyGlueLinesInBetween = false;
                                        break;
                                    }
                                    if (iLineInfo.hasCode()) {
                                        CFChunk pLLastChunk;
                                        CFLineInfo prevLineInfo;
                                        boolean isBackslashGlue = false;
                                        if (i > 2 && (prevLineInfo = this.fModel.getLineInfo(i - 1)) != null && (pLLastChunk = prevLineInfo.getLastChunk()) != null && (1 == pLLastChunk.getType() || 2 == pLLastChunk.getType()) && pLLastChunk.getValue().trim().endsWith("\\")) {
                                            isBackslashGlue = true;
                                        }
                                        if (!isBackslashGlue) {
                                            onlyGlueLinesInBetween = false;
                                            break;
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (!onlyGlueLinesInBetween) {
                                consecutiveLines = false;
                            }
                        }
                        if (consecutiveLines) {
                            vDepthTokens.add(vToken);
                            if (vToken.getStartOffsetInLine() <= maxOffsetInLine) continue;
                            maxOffsetInLine = vToken.getStartOffsetInLine();
                            continue;
                        }
                        revisitCurrentDepth = true;
                        break;
                    }
                    if (nextVDepth == -1000) {
                        nextVDepth = tokenVDepth;
                        continue;
                    }
                    if (tokenVDepth >= nextVDepth) continue;
                    nextVDepth = tokenVDepth;
                }
                if (!vDepthTokens.isEmpty()) {
                    if (this.fFormatPreferences.isLineWrapEnabled()) {
                        for (CFVToken vToken : vDepthTokens) {
                            lofVTokensInScope.remove(vToken);
                        }
                        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
                        int wrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
                        Collections.sort(vDepthTokens, new Comparator<CFVToken>(){

                            @Override
                            public int compare(CFVToken o1, CFVToken o2) {
                                if (o1.getStartOffsetInLine() > o2.getStartOffsetInLine()) {
                                    return -1;
                                }
                                if (o1.getStartOffsetInLine() < o2.getStartOffsetInLine()) {
                                    return 1;
                                }
                                return 0;
                            }
                        });
                        boolean done = false;
                        int maxIndex = 0;
                        while (!done && maxIndex < vDepthTokens.size() - 1) {
                            done = true;
                            maxOffsetInLine = ((CFVToken)vDepthTokens.get(maxIndex)).getStartOffsetInLine();
                            int i = maxIndex + 1;
                            while (i < vDepthTokens.size()) {
                                CFVToken vToken = (CFVToken)vDepthTokens.get(i);
                                if (!vToken.fitsWrap(maxOffsetInLine, wrapThreshold)) {
                                    done = false;
                                    break;
                                }
                                ++i;
                            }
                            ++maxIndex;
                        }
                        if (done) {
                            CFSyso.printlnIn("VALIGN", "Vertical Align " + vScope + " vDepth: " + currentVDepth + " max: " + maxOffsetInLine);
                            int i = maxIndex;
                            while (i < vDepthTokens.size()) {
                                CFVToken vToken = (CFVToken)vDepthTokens.get(i);
                                if (vToken != null) {
                                    CFSyso.println("VALIGN", "" + vToken);
                                    vToken.verticalAlign(maxOffsetInLine);
                                }
                                ++i;
                            }
                            CFSyso.printlnOut("VALIGN", "Vertical Align " + vScope + " vDepth: " + currentVDepth + " max: " + maxOffsetInLine);
                        }
                    } else {
                        CFSyso.printlnIn("VALIGN", "Vertical Align " + vScope + " vDepth: " + currentVDepth + " max: " + maxOffsetInLine);
                        for (CFVToken vToken : vDepthTokens) {
                            if (vToken == null) continue;
                            CFSyso.println("VALIGN", "" + vToken);
                            vToken.verticalAlign(maxOffsetInLine);
                            lofVTokensInScope.remove(vToken);
                        }
                        CFSyso.printlnOut("VALIGN", "Vertical Align " + vScope + " vDepth: " + currentVDepth + " max: " + maxOffsetInLine);
                    }
                }
                int n = currentVDepth = revisitCurrentDepth ? currentVDepth : nextVDepth;
            }
        }
    }

    public void compactWSForVerticalAlignPatterns() {
    }
}

