/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.vertical;

import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public class CFVToken {
    private String fValue;
    private CFChunk fEnclosingChunk;
    private int fStartOffsetInChunk;
    private int fVDepth;
    private CFVScope fVAlignScope;
    private int fVDelta;
    private boolean fIgnored;

    public CFVToken(String value, CFChunk enclosingChunk, int startOffsetInChunk, int vDepth) {
        this.fValue = value;
        this.fEnclosingChunk = enclosingChunk;
        this.fStartOffsetInChunk = startOffsetInChunk;
        this.fVDepth = vDepth;
    }

    public String getValue() {
        return this.fValue;
    }

    public int getStartOffsetInLine() {
        return this.fEnclosingChunk.getStartOffsetInLine() + this.fStartOffsetInChunk + this.fVDelta;
    }

    public int getVDepth() {
        return this.fVDepth;
    }

    public CFVScope getVScope() {
        return this.fVAlignScope;
    }

    public void setVScope(CFVScope vScope) {
        this.fVAlignScope = vScope;
    }

    public void updateVDeltaInLine(int delta) {
        this.fVDelta += delta;
    }

    public CFLineInfo getEnclosingLineInfo() {
        if (this.fEnclosingChunk != null) {
            return this.fEnclosingChunk.getEnclosingLineInfo();
        }
        return null;
    }

    public void setIgnored() {
        this.fIgnored = true;
    }

    public boolean isIgnored() {
        return this.fIgnored;
    }

    public String toString() {
        return "vToken:" + this.fValue + " line: " + this.fEnclosingChunk.getLineNo() + " offsetInLine: " + this.getStartOffsetInLine() + " vDepth: " + this.fVDepth;
    }

    public void verticalAlign(int toOffsetInLine) {
        if (this.fEnclosingChunk == null) {
            return;
        }
        CFLineInfo lineInfo = this.fEnclosingChunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (3 != this.fEnclosingChunk.getType() && lineInfo.containsComplexPreproc()) {
            return;
        }
        int nofWSCharsToInsert = toOffsetInLine - this.getStartOffsetInLine();
        if (nofWSCharsToInsert != 0) {
            boolean done = false;
            if (this.fStartOffsetInChunk == 0) {
                done = CFUtils.getInstance().tryAddWhitespaceBeforeNonCodePartition(this.fEnclosingChunk, nofWSCharsToInsert, "vertical align");
            }
            if (!done) {
                this.fEnclosingChunk.addAction(new CFAction(this.fStartOffsetInChunk, 0, CFUtils.getInstance().getWhitespace(nofWSCharsToInsert), "vertical align"));
            }
            lineInfo.updateVDeltaInLine(this.fVDepth, nofWSCharsToInsert);
        }
    }

    public boolean fitsWrap(int toOffsetInLine, int wrapThreshold) {
        int nofWSCharsToInsert = toOffsetInLine - this.getStartOffsetInLine();
        CFLineInfo lineInfo = this.fEnclosingChunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        return lineInfo.getNLOffsetInLine() + nofWSCharsToInsert <= wrapThreshold;
    }
}

