/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.vregex;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExPattern;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.NamedMatcher;

public abstract class CFVRegExBaseDefinition {
    private String fName;
    private String fDescription;
    private boolean fEnabled;
    protected List<String> fOrderedGroupNames;
    protected List<String> fAdditionalGroupNames;
    protected List<CFVRegExPattern> fVRegExPatterns;
    public static final String FRAGMENT_ID = "\\w+";
    public static final String FRAGMENT_COMMA_SEPARATED_LIST_OF_ID = "\\w+(?:[ ]*[,][ ]*\\w+)*";
    public static final String FRAGMENT_VHDL_SL_COMMENT = "--.*";
    public static final String START_GROUP_NAME = "start_group";
    public String FRAGMENT_HID;
    public String FRAGMENT_ID_DIMENSIONS;
    public String FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS;
    public String FRAGMENT_DIMENSION;
    public String FRAGMENT_DIMENSIONS;
    public String FRAGMENT_SIGNED;
    public String FRAGMENT_TF_QUALIFIER;
    public String FRAGMENT_TF_DIR;
    public String FRAGMENT_VLOG_SL_COMMENT;
    public String FRAGMENT_VLOG_ML_COMMENT;

    protected CFVRegExBaseDefinition(String name, String description, boolean splitDimensions) {
        this.fName = name;
        this.fDescription = description;
        this.initFragments();
        this.definePattern(splitDimensions);
    }

    protected void definePattern(boolean splitDimensions) {
        if (splitDimensions) {
            this.definePatternSplitDimensions();
        } else {
            this.definePatternGroupDimensions();
        }
    }

    public abstract void resetState();

    protected abstract void definePatternSplitDimensions();

    protected abstract void definePatternGroupDimensions();

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    protected void initFragments() {
        this.FRAGMENT_HID = "[a-zA-Z_0-9.:]+";
        this.FRAGMENT_DIMENSION = "\\[[^\\]]*\\]";
        this.FRAGMENT_DIMENSIONS = String.valueOf(this.FRAGMENT_DIMENSION) + "(?:[ ]*" + this.FRAGMENT_DIMENSION + ")*";
        this.FRAGMENT_ID_DIMENSIONS = "\\w+(?:[ ]*" + this.FRAGMENT_DIMENSIONS + ")?";
        this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS = String.valueOf(this.FRAGMENT_ID_DIMENSIONS) + "(?:[ ]*[,][ ]*" + this.FRAGMENT_ID_DIMENSIONS + ")*";
        this.FRAGMENT_SIGNED = "signed|unsigned";
        this.FRAGMENT_TF_QUALIFIER = "(?:(?:extern|static|virtual|local|protected)[ ]+)?";
        this.FRAGMENT_TF_DIR = "input|output|inout|ref|const[ ]+ref";
        this.FRAGMENT_VLOG_SL_COMMENT = "//.*";
        this.FRAGMENT_VLOG_ML_COMMENT = "/\\*.*?\\*/";
    }

    public boolean isValidRegExVScope(CFVRegExScanner vRegExScanner) {
        return false;
    }

    public boolean isValidMatch(NamedMatcher nMatcher) {
        return true;
    }

    public boolean isAlignOnlyConsecutiveLines() {
        return false;
    }

    public List<String> getOrderedGroupNames() {
        return this.fOrderedGroupNames;
    }

    public List<String> getAdditionalGroupNames() {
        return this.fAdditionalGroupNames;
    }

    public List<CFVRegExPattern> getVRegExPatterns() {
        return this.fVRegExPatterns;
    }

    public void endToken(CFToken token, CFVRegExScanner vRegExScanner) {
    }

    public CFVScope getVScope(CFVScope vScope, CFVRegExScanner vRegExScanner) {
        return vScope;
    }

    protected void definePatternSetForVlogSignalsAndParamsSplitDimensions() {
        this.fOrderedGroupNames = new ArrayList<String>();
        this.fOrderedGroupNames.add("id1");
        this.fOrderedGroupNames.add("id2");
        this.fOrderedGroupNames.add("id3");
        this.fOrderedGroupNames.add("signed");
        this.fOrderedGroupNames.add("packed_dimension");
        this.fOrderedGroupNames.add("names");
        this.fOrderedGroupNames.add("unpacked_dimension");
        this.fOrderedGroupNames.add("eq");
        this.fOrderedGroupNames.add("comment");
        this.fVRegExPatterns = new ArrayList<CFVRegExPattern>();
        LinkedHashMap<String, String> patternFragments = new LinkedHashMap<String, String>();
        patternFragments.put("id1", "(?<id1>\\w+)");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?");
        patternFragments.put("signed", "(?:[ ]+(?<signed>" + this.FRAGMENT_SIGNED + "))");
        patternFragments.put("packed_dimension", "(?:[ ]*(?<packed_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>\\w+)");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("unpacked_dimension", "(?:[ ]*(?<unpacked_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS7", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("id1", "(?<id1>\\w+)");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?");
        patternFragments.put("signed", "(?:[ ]+(?<signed>" + this.FRAGMENT_SIGNED + "))");
        patternFragments.put("packed_dimension", "(?:[ ]*(?<packed_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + ")");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("id1", "(?<id1>\\w+)");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?");
        patternFragments.put("signed", "(?:[ ]+(?<signed>" + this.FRAGMENT_SIGNED + "))");
        patternFragments.put("names", "(?:[ ]+(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + "))");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("id1", "(?<id1>\\w+)(?:::\\w+)*");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?(?:::\\w+)*");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?(?:::\\w+)*");
        patternFragments.put("packed_dimension", "(?:[ ]*(?<packed_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>\\w+)");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("unpacked_dimension", "(?:[ ]*(?<unpacked_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS7", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("id1", "(?<id1>\\w+)(?:::\\w+)*");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?(?:::\\w+)*");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?(?:::\\w+)*");
        patternFragments.put("packed_dimension", "(?:[ ]*(?<packed_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + ")");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("id1", "(?<id1>\\w+)(?:::\\w+)*");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?(?:::\\w+)*");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?(?:::\\w+)*");
        patternFragments.put("names", "(?:[ ]+(?<names>\\w+))");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("unpacked_dimension", "(?:[ ]*(?<unpacked_dimension>" + this.FRAGMENT_DIMENSIONS + "))");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("id1", "(?<id1>\\w+)(?:::\\w+)*");
        patternFragments.put("id2", "(?:[ ]+(?<id2>\\w+))?(?:::\\w+)*");
        patternFragments.put("id3", "(?:[ ]+(?<id3>\\w+))?(?:::\\w+)*");
        patternFragments.put("names", "(?:[ ]+(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + "))");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
    }

    protected void definePatternSetForVlogSignalsAndParamsGroupDimensions() {
        this.fOrderedGroupNames = new ArrayList<String>();
        this.fOrderedGroupNames.add("ids");
        this.fOrderedGroupNames.add("names");
        this.fOrderedGroupNames.add("eq");
        this.fOrderedGroupNames.add("comment");
        this.fVRegExPatterns = new ArrayList<CFVRegExPattern>();
        LinkedHashMap<String, String> patternFragments = new LinkedHashMap<String, String>();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:[ ]+(?:\\w+))?(?:[ ]+(?:\\w+))?(?:[ ]+(?:" + this.FRAGMENT_SIGNED + "))" + "(?:[ ]*(?:" + this.FRAGMENT_DIMENSIONS + "))" + ")");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>" + this.FRAGMENT_ID_DIMENSIONS + ")");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:[ ]+(?:\\w+))?(?:[ ]+(?:\\w+))?(?:[ ]+(?:" + this.FRAGMENT_SIGNED + "))" + "(?:[ ]*(?:" + this.FRAGMENT_DIMENSIONS + "))" + ")");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + ")");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:[ ]+(?:\\w+))?(?:[ ]+(?:\\w+))?(?:[ ]+(?:" + this.FRAGMENT_SIGNED + "))" + ")");
        patternFragments.put("names", "(?:[ ]+(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + "))");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:::\\w+)*(?:[ ]+(?:\\w+)(?:::\\w+)*)?(?:[ ]+(?:\\w+)(?:::\\w+)*)?(?:[ ]*(?:" + this.FRAGMENT_DIMENSIONS + "))" + ")");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>" + this.FRAGMENT_ID_DIMENSIONS + ")");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:::\\w+)*(?:[ ]+(?:\\w+)(?:::\\w+)*)?(?:[ ]+(?:\\w+)(?:::\\w+)*)?(?:[ ]*(?:" + this.FRAGMENT_DIMENSIONS + "))" + ")");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("names", "(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + ")");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:::\\w+)*(?:[ ]+(?:\\w+)(?:::\\w+)*)?(?:[ ]+(?:\\w+)(?:::\\w+)*)?)");
        patternFragments.put("names", "(?:[ ]+(?<names>" + this.FRAGMENT_ID_DIMENSIONS + "))");
        patternFragments.put("OWS5", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
        patternFragments = new LinkedHashMap();
        patternFragments.put("ids", "(?<ids>(?<id1>\\w+)(?:::\\w+)*(?:[ ]+(?:\\w+)(?:::\\w+)*)?(?:[ ]+(?:\\w+)(?:::\\w+)*)?)");
        patternFragments.put("names", "(?:[ ]+(?<names>" + this.FRAGMENT_COMMA_SEPARATED_LIST_OF_ID_DIMENSIONS + "))");
        patternFragments.put("OWS6", "[ ]*");
        patternFragments.put("eq", "(?<eq>=(?:(?!//).)*)?");
        patternFragments.put("SEMI", "(?:[;][ ]*)");
        patternFragments.put("comment", "(?<comment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
    }
}

