/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.vregex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExGroup;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExPattern;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.NamedMatcher;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.NamedPattern;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;

public class CFVRegExScanner
extends CFVScanner {
    private Map<CFVScope, Map<CFVRegExBaseDefinition, List<CFVRegExToken>>> fVRegExScopes = new HashMap<CFVScope, Map<CFVRegExBaseDefinition, List<CFVRegExToken>>>();

    public CFVRegExScanner(CFModel model, ICFVTokenScannerImpl vScannerImpl) {
        super(model, vScannerImpl);
    }

    @Override
    public void verticalAlignStartChunk(CFChunk chunk) {
    }

    @Override
    public void verticalAlignStartToken(CFToken token) {
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.fFormatPreferences.isCompactWSEnabled() || !this.fFormatPreferences.isVRegExCompactWSEnabled()) {
            return;
        }
        if (token == null) {
            return;
        }
        if (token.getTokenType() != 3) {
            return;
        }
        String tokenValue = token.getValue();
        if (tokenValue == null) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        if (chunk.isFirstOnLine() && token.getStartOffsetInChunk() == 0) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        int nlOffsetInLine = lineInfo.getNLOffsetInLine();
        if (nlOffsetInLine >= token.getStartOffsetInLine() && nlOffsetInLine <= token.getEndOffsetInLine()) {
            return;
        }
        String lineContent = lineInfo.getChunksContent();
        if (lineContent == null) {
            return;
        }
        List<CFVRegExBaseDefinition> vRegExDefs = this.fStrategy.getEnabledVRegExPref();
        if (vRegExDefs == null) {
            return;
        }
        for (CFVRegExBaseDefinition vRegExDef : vRegExDefs) {
            List<CFVRegExPattern> vRegExPatterns;
            if (vRegExDef == null || !vRegExDef.isValidRegExVScope(this) || (vRegExPatterns = vRegExDef.getVRegExPatterns()) == null) continue;
            boolean isValidMatch = false;
            for (CFVRegExPattern vRegExPattern : vRegExPatterns) {
                NamedMatcher matcher;
                NamedPattern pattern;
                if (vRegExPattern == null || (pattern = vRegExPattern.getPattern()) == null || !(matcher = pattern.matcher(lineContent)).matches() || !vRegExDef.isValidMatch(matcher)) continue;
                isValidMatch = true;
                break;
            }
            if (!isValidMatch) continue;
            int nofCharsToDelete = tokenValue.length() - 1;
            if (nofCharsToDelete != 0) {
                chunk.addAction(new CFAction(token.getStartOffsetInChunk(), nofCharsToDelete, "", "compact whitespace"));
            }
            return;
        }
    }

    @Override
    public void verticalAlignEndToken(CFToken token) {
        List<CFVRegExBaseDefinition> vRegExDefs = this.fStrategy.getEnabledVRegExPref();
        if (vRegExDefs == null) {
            return;
        }
        for (CFVRegExBaseDefinition vRegExDef : vRegExDefs) {
            vRegExDef.endToken(token, this);
        }
    }

    private boolean isSignalConstantVariableDeclarationsOn(List<CFVRegExBaseDefinition> regExDefs) {
        for (CFVRegExBaseDefinition def : regExDefs) {
            if (!"VhdlVariableSignalConstantDeclarations".equals(def.getName())) continue;
            return true;
        }
        return false;
    }

    private List<CFVRegExBaseDefinition> filterRegExDefs(List<CFVRegExBaseDefinition> regExDefs) {
        ArrayList<CFVRegExBaseDefinition> filteredRegExDefs = new ArrayList<CFVRegExBaseDefinition>();
        for (CFVRegExBaseDefinition def : regExDefs) {
            if ("VhdlSignalDeclarations".equals(def.getName()) || "VhdlConstantDeclarations".equals(def.getName()) || "VhdlVariableDeclarations".equals(def.getName())) continue;
            filteredRegExDefs.add(def);
        }
        return filteredRegExDefs;
    }

    @Override
    public void verticalAlignEndChunk(CFChunk chunk) {
        List<CFVRegExBaseDefinition> vRegExDefs = this.fStrategy.getEnabledVRegExPref();
        if (vRegExDefs == null) {
            return;
        }
        if (chunk == null) {
            return;
        }
        int chunkType = chunk.getType();
        if (chunk.isFirstOnLine() && (chunkType == 4 || chunkType == 3)) {
            return;
        }
        if (!chunk.endsWithNL()) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        String lineContent = lineInfo.getChunksContent();
        CFVScope currentVScope = this.getCurrentVScope();
        CFSyso.println("VALIGN", "\n\n---\nlineContent:" + lineContent);
        boolean lineDone = false;
        if (this.isSignalConstantVariableDeclarationsOn(vRegExDefs)) {
            vRegExDefs = this.filterRegExDefs(vRegExDefs);
        }
        for (CFVRegExBaseDefinition vRegExDef : vRegExDefs) {
            List<CFVRegExPattern> vRegExPatterns;
            if (!vRegExDef.isValidRegExVScope(this) || (vRegExPatterns = vRegExDef.getVRegExPatterns()) == null) continue;
            for (CFVRegExPattern vRegExPattern : vRegExPatterns) {
                NamedPattern pattern;
                if (vRegExPattern == null || (pattern = vRegExPattern.getPattern()) == null) continue;
                CFSyso.println("VALIGN", "pattern:" + pattern);
                NamedMatcher matcher = pattern.matcher(lineContent);
                if (!matcher.matches() || !vRegExDef.isValidMatch(matcher)) continue;
                CFSyso.println("VALIGN", "matched:" + pattern);
                currentVScope = vRegExDef.getVScope(currentVScope, this);
                CFVRegExToken vRegExToken = this.createVRegExToken(lineInfo, currentVScope, vRegExDef, vRegExPattern, matcher);
                if (vRegExToken == null) continue;
                this.addVRegExToken(vRegExDef, vRegExToken);
                lineDone = true;
                break;
            }
            if (lineDone) break;
        }
    }

    private CFVRegExToken createVRegExToken(CFLineInfo lineInfo, CFVScope vScope, CFVRegExBaseDefinition vRegExDefinition, CFVRegExPattern vRegExPattern, NamedMatcher matcher) {
        String groupValue;
        ArrayList<CFVRegExGroup> groups = new ArrayList<CFVRegExGroup>();
        for (String groupName : vRegExDefinition.getOrderedGroupNames()) {
            if (!vRegExPattern.hasGroupName(groupName) || (groupValue = matcher.group(groupName)) == null) continue;
            CFSyso.println("VALIGN", String.valueOf(groupName) + ":'" + groupValue + "'");
            groups.add(new CFVRegExGroup(groupName, groupValue, matcher.start(groupName), matcher.end(groupName)));
        }
        if (vRegExDefinition.getAdditionalGroupNames() == null) {
            return new CFVRegExToken(lineInfo, vScope, groups);
        }
        for (String groupName : vRegExDefinition.getAdditionalGroupNames()) {
            if (!vRegExPattern.hasGroupName(groupName) || (groupValue = matcher.group(groupName)) == null) continue;
            groups.add(new CFVRegExGroup(groupName, groupValue, matcher.start(groupName), matcher.end(groupName)));
        }
        return new CFVRegExToken(lineInfo, vScope, groups);
    }

    @Override
    public void verticalAlign() {
        int wrapThreshold = -1;
        if (this.fFormatPreferences.isLineWrapEnabled()) {
            DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
            wrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
        }
        for (Map<CFVRegExBaseDefinition, List<CFVRegExToken>> defMap : this.fVRegExScopes.values()) {
            for (Map.Entry<CFVRegExBaseDefinition, List<CFVRegExToken>> entry : defMap.entrySet()) {
                List<String> orderedGroupNames;
                CFVRegExBaseDefinition vRegExDef = entry.getKey();
                if (vRegExDef == null || (orderedGroupNames = vRegExDef.getOrderedGroupNames()) == null) continue;
                boolean alignOnlyConsecutiveLines = this.fFormatPreferences.isVerticalAlignConsecutiveLines() || vRegExDef.isAlignOnlyConsecutiveLines();
                for (String orderedGroup : orderedGroupNames) {
                    ArrayList lofVTokensInScope = new ArrayList(entry.getValue());
                    ArrayList<CFVRegExToken> notIgnoredVTokens = new ArrayList<CFVRegExToken>();
                    for (CFVRegExToken vToken : lofVTokensInScope) {
                        if (vToken == null || !vToken.getEnclosingLineInfo().isFormatterOn()) continue;
                        notIgnoredVTokens.add(vToken);
                    }
                    lofVTokensInScope = notIgnoredVTokens;
                    while (!lofVTokensInScope.isEmpty()) {
                        boolean wrapExceeded = false;
                        int maxOffset = 0;
                        CFVRegExToken maxVRegExToken = null;
                        ArrayList<CFVRegExToken> lofVTokensToAlign = new ArrayList<CFVRegExToken>();
                        int prevLineNo = -2;
                        for (CFVRegExToken vRegExToken : lofVTokensInScope) {
                            int adjustedGroupOffsetInLine;
                            if (vRegExToken == null) continue;
                            if (alignOnlyConsecutiveLines) {
                                int currLineNo = vRegExToken.getLineNo();
                                if (prevLineNo != -2 && prevLineNo + 1 != currLineNo) {
                                    boolean nonConsecutiveLines = false;
                                    int i = currLineNo - 1;
                                    while (i > prevLineNo) {
                                        String iLineContent;
                                        CFLineInfo iLineInfo = this.fModel.getLineInfo(i);
                                        if (iLineInfo != null && (iLineContent = iLineInfo.getChunksContent()) != null) {
                                            if (iLineContent.trim().isEmpty()) {
                                                nonConsecutiveLines = true;
                                                break;
                                            }
                                            if (iLineInfo.hasCode()) {
                                                CFChunk pLLastChunk;
                                                CFLineInfo prevLineInfo;
                                                boolean isBackslashGlue = false;
                                                if (i > 2 && (prevLineInfo = this.fModel.getLineInfo(i - 1)) != null && (pLLastChunk = prevLineInfo.getLastChunk()) != null && (1 == pLLastChunk.getType() || 2 == pLLastChunk.getType()) && pLLastChunk.getValue().trim().endsWith("\\")) {
                                                    isBackslashGlue = true;
                                                }
                                                if (!isBackslashGlue) {
                                                    nonConsecutiveLines = true;
                                                    break;
                                                }
                                            }
                                        }
                                        --i;
                                    }
                                    if (nonConsecutiveLines) break;
                                }
                                prevLineNo = currLineNo;
                                lofVTokensToAlign.add(vRegExToken);
                            } else {
                                lofVTokensToAlign.add(vRegExToken);
                            }
                            CFVRegExGroup group = vRegExToken.getGroup(orderedGroup);
                            if (group != null) {
                                String matchedValue = group.getValue();
                                if (matchedValue == null || matchedValue.isEmpty()) {
                                    adjustedGroupOffsetInLine = 0;
                                } else {
                                    adjustedGroupOffsetInLine = vRegExToken.getAdjustedStartOffsetInLine(group);
                                    vRegExToken.setPrevAlignedGroup(group);
                                }
                            } else {
                                CFVRegExGroup startParamsGroup;
                                CFVRegExGroup prevAlignedGroup = vRegExToken.getPrevAlignedGroup();
                                adjustedGroupOffsetInLine = prevAlignedGroup != null ? vRegExToken.getAdjustedEndOffsetInLine(prevAlignedGroup) + 1 : ((startParamsGroup = vRegExToken.getGroup("start_group")) != null ? vRegExToken.getAdjustedEndOffsetInLine(startParamsGroup) : 0);
                            }
                            if (maxOffset >= adjustedGroupOffsetInLine) continue;
                            maxOffset = adjustedGroupOffsetInLine;
                            maxVRegExToken = vRegExToken;
                        }
                        if (this.fFormatPreferences.isLineWrapEnabled()) {
                            for (CFVRegExToken regExVToken : lofVTokensToAlign) {
                                CFVRegExGroup group;
                                if (regExVToken == null || (group = regExVToken.getGroup(orderedGroup)) == null || regExVToken.fitsThreshold(group, maxOffset, wrapThreshold)) continue;
                                wrapExceeded = true;
                                break;
                            }
                        }
                        if (!wrapExceeded) {
                            boolean alignAllVTokens = lofVTokensInScope.size() == lofVTokensToAlign.size();
                            for (CFVRegExToken regExVToken : lofVTokensToAlign) {
                                String matchedValue;
                                CFVRegExGroup group;
                                if (!alignAllVTokens) {
                                    lofVTokensInScope.remove(regExVToken);
                                }
                                if (regExVToken == null || (group = regExVToken.getGroup(orderedGroup)) == null || (matchedValue = group.getValue()) == null || matchedValue.isEmpty()) continue;
                                regExVToken.alignGroup(group, maxOffset);
                            }
                            if (!alignAllVTokens) continue;
                            lofVTokensInScope.clear();
                            continue;
                        }
                        lofVTokensInScope.remove(maxVRegExToken);
                    }
                }
            }
        }
    }

    private void addVRegExToken(CFVRegExBaseDefinition regExVDefinition, CFVRegExToken vToken) {
        List<CFVRegExToken> lofVTokensInScope;
        if (vToken == null) {
            return;
        }
        CFVScope vScope = vToken.getVScope();
        if (vScope == null) {
            return;
        }
        Map<CFVRegExBaseDefinition, List<CFVRegExToken>> defMap = this.fVRegExScopes.get(vScope);
        if (defMap == null) {
            defMap = new HashMap<CFVRegExBaseDefinition, List<CFVRegExToken>>();
            this.fVRegExScopes.put(vScope, defMap);
        }
        if ((lofVTokensInScope = defMap.get(regExVDefinition)) == null) {
            lofVTokensInScope = new ArrayList<CFVRegExToken>();
            defMap.put(regExVDefinition, lofVTokensInScope);
        }
        lofVTokensInScope.add(vToken);
    }

    @Override
    public void compactWSForVerticalAlignPatterns() {
    }
}

