/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.scanner.vregex;

import java.util.List;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExGroup;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public class CFVRegExToken {
    private CFLineInfo fLineInfo;
    private int fInitialLineLength;
    private List<CFVRegExGroup> fGroups;
    private CFVScope fVScope;
    private CFVRegExGroup fPrevAlignedGroup;
    private int fAdjustment;

    public CFVRegExToken(CFLineInfo lineInfo, CFVScope vScope, List<CFVRegExGroup> groups) {
        this.fLineInfo = lineInfo;
        this.fVScope = vScope;
        this.fGroups = groups;
        this.fInitialLineLength = this.fLineInfo.getChunksContent().length();
    }

    public CFVScope getVScope() {
        return this.fVScope;
    }

    public CFVRegExGroup getGroup(String groupName) {
        if (groupName == null || this.fGroups == null) {
            return null;
        }
        for (CFVRegExGroup group : this.fGroups) {
            if (group == null || !groupName.equals(group.getName())) continue;
            return group;
        }
        return null;
    }

    public CFVRegExGroup getPrevAlignedGroup() {
        return this.fPrevAlignedGroup;
    }

    public void setPrevAlignedGroup(CFVRegExGroup prevAlignedGroup) {
        this.fPrevAlignedGroup = prevAlignedGroup;
    }

    public int getAdjustedStartOffsetInLine(CFVRegExGroup group) {
        if (group == null) {
            return -1;
        }
        return this.fAdjustment + group.getStartOffsetInLine();
    }

    public int getAdjustedEndOffsetInLine(CFVRegExGroup group) {
        if (group == null) {
            return -1;
        }
        return this.fAdjustment + group.getEndOffsetInLine();
    }

    public boolean fitsThreshold(CFVRegExGroup group, int toAdjustedOffsetInLine, int wrapThreshold) {
        if (group == null) {
            return true;
        }
        int adjustedStartOffsetInLine = this.getAdjustedStartOffsetInLine(group);
        if (adjustedStartOffsetInLine == toAdjustedOffsetInLine) {
            return true;
        }
        int nofWSCharsToInsert = toAdjustedOffsetInLine - adjustedStartOffsetInLine;
        return wrapThreshold == -1 || this.fInitialLineLength + this.fAdjustment + nofWSCharsToInsert <= wrapThreshold + 1;
    }

    public void alignGroup(CFVRegExGroup group, int toAdjustedOffsetInLine) {
        this.fLineInfo.setIsVerticalAlignedByRegex();
        if (group == null) {
            return;
        }
        int adjustedStartOffsetInLine = this.getAdjustedStartOffsetInLine(group);
        if (adjustedStartOffsetInLine == toAdjustedOffsetInLine) {
            return;
        }
        int nofWSCharsToInsert = toAdjustedOffsetInLine - adjustedStartOffsetInLine;
        int startOffsetInLine = group.getStartOffsetInLine();
        CFChunk chunk = this.fLineInfo.getChunkAtOffset(startOffsetInLine);
        if (chunk == null) {
            return;
        }
        int offsetInChunk = startOffsetInLine - chunk.getStartOffsetInLine();
        boolean done = false;
        if (offsetInChunk == 0) {
            done = CFUtils.getInstance().tryAddWhitespaceBeforeNonCodePartition(chunk, nofWSCharsToInsert, "regex vertical align");
        }
        if (!done) {
            chunk.addAction(new CFAction(offsetInChunk, 0, CFUtils.getInstance().getWhitespace(nofWSCharsToInsert), "regex vertical align"));
        }
        this.fAdjustment += nofWSCharsToInsert;
    }

    public int getLineNo() {
        if (this.fLineInfo != null) {
            return this.fLineInfo.getLineNo();
        }
        return -1;
    }

    public CFLineInfo getEnclosingLineInfo() {
        return this.fLineInfo;
    }
}

