/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.strategies;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingKeywordsSet;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFChunkTokenizer;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTBaseCodeFormattingStrategy
extends DVTBaseFormattingStrategy {
    private static final Pattern NON_ASCII_CHARS_PATTERN = Pattern.compile("[^\\p{ASCII}]");

    protected DVTBaseCodeFormattingStrategy(DVTSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super(configuration, formatPreferences, 1);
    }

    @Override
    public void formatterStarts(String indentation) {
        super.formatterStarts(indentation);
        this.refreshFormattingPreferences();
    }

    protected void refreshFormattingPreferences() {
        this.fFormatPreferences.refreshAddWSBefore();
        this.fFormatPreferences.refreshAddWSAfter();
        this.fFormatPreferences.refreshIgnoreLinesPref();
        this.fFormatPreferences.refreshNoIndentKeywordsPref();
        this.fFormatPreferences.refreshVAlignTokensPref();
    }

    @Override
    public boolean ignoreLine(String firstChunkOnLineValue) {
        String trimmedValue = firstChunkOnLineValue.trim();
        Set<String> ignoreLinesStartingWithPref = this.fFormatPreferences.getIgnoreLinesStartingWithPref();
        if (ignoreLinesStartingWithPref == null) {
            return false;
        }
        for (String prefix : ignoreLinesStartingWithPref) {
            if (prefix == null || !trimmedValue.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getVAlignTokensPref() {
        return this.fFormatPreferences.getVerticalAlignTokensPref();
    }

    @Override
    public boolean isValidVAlignWithoutBoundary(String vTokenString) {
        if (vTokenString == null || vTokenString.length() != 1) {
            return false;
        }
        return DVTBaseFormattingKeywordsSet.INSTANCE.WITHOUT_BOUNDARY_ALIGN_CHARS.contains(Character.valueOf(vTokenString.charAt(0)));
    }

    @Override
    public boolean isValidVAlignBoundaryChar(String vTokenString, char ch, boolean before) {
        if (Character.isWhitespace(ch)) {
            return true;
        }
        if (Character.isJavaIdentifierPart(ch)) {
            return true;
        }
        Set<Character> boundaryVAlignChars = this.getBoundaryVAlignChars();
        if (boundaryVAlignChars == null) {
            return false;
        }
        return boundaryVAlignChars.contains(Character.valueOf(ch));
    }

    protected Set<Character> getBoundaryVAlignChars() {
        return DVTBaseFormattingKeywordsSet.INSTANCE.BOUNDARY_ALIGN_CHARS;
    }

    @Override
    public Set<String> getAddWSBeforePref() {
        return this.fFormatPreferences.getAddWSBeforePref();
    }

    @Override
    public Set<String> getAddWSAfterPref() {
        return this.fFormatPreferences.getAddWSAfterPref();
    }

    @Override
    public boolean isValidVAlignContext(char prevChar, String vTokenString) {
        return '$' != prevChar || !vTokenString.startsWith("{");
    }

    @Override
    public String filterInitialPartitionContent(String text) {
        return DVTStringUtil.replaceAll(NON_ASCII_CHARS_PATTERN, text, "");
    }

    @Override
    protected List<CFToken> createTokens(CFModel model, CFChunk chunk) {
        CFChunkTokenizer chunkTokenizer = new CFChunkTokenizer(this, chunk);
        String chunkValue = chunk.getValue();
        if (model.ignoreCase()) {
            chunkValue = chunkValue.toLowerCase();
        }
        return chunkTokenizer.getTokens(chunkValue);
    }

    @Override
    public boolean isSingleChar(char c, char prevChar, char nextChar) {
        return c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == ';' || c == ',';
    }

    @Override
    public boolean isAddWhitespaceAfterToken(CFToken token) {
        if (token == null) {
            return false;
        }
        String tokenValue = token.getValue();
        Set<String> addWSAfterPref = this.fFormatPreferences.getAddWSAfterPref();
        if (addWSAfterPref == null) {
            return false;
        }
        return addWSAfterPref.contains(tokenValue) && this.allowWhitespaceAfterToken(token);
    }

    protected abstract boolean isClosingToken(String var1);
}

