/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.strategies;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public abstract class DVTBaseCommentFormattingStrategy
extends DVTBaseFormattingStrategy {
    public DVTBaseCommentFormattingStrategy(DVTSourceViewerConfiguration configuration, CFPreferences formatPreferences, int chunkType) {
        super(configuration, formatPreferences, chunkType);
    }

    protected boolean incrMLCommentIndent() {
        return false;
    }

    protected boolean tryCommentWrap(CFModel model, CFToken token, String causedBy) {
        int wrapThreshold;
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        boolean isSLComment = chunk.getType() == 3;
        int commentLineIndent = this.getCommentIndent(model, token.getLineNo());
        if (isSLComment && this.fFormatPreferences.isPreserveSLCommentAtColumnZeroEnabled() && token.getEnclosingChunk().getStartOffsetInLine() == 0) {
            commentLineIndent = 0;
        }
        if (!isSLComment && !this.fFormatPreferences.isIndentMLCommentsEnabled()) {
            commentLineIndent = lineInfo.getLineStartWSLength();
        }
        int wrappedCommentIndent = commentLineIndent;
        if (!isSLComment && this.fFormatPreferences.isIndentMLCommentsEnabled() && this.incrMLCommentIndent()) {
            wrappedCommentIndent = commentLineIndent + 1;
            CFPartition partition = chunk.getEnclosingPartition();
            if (partition != null && !partition.isFirstChunk(chunk)) {
                ++commentLineIndent;
            }
        }
        int tokenStartOffsetInLineAfterWS = token.getStartOffsetInLineAfterWS();
        String commentValue = token.getValue();
        String commentValueNoTrailWS = commentValue.substring(0, commentValue.trim().length());
        String commentPrefix = isSLComment ? commentValueNoTrailWS.substring(0, 2) : "";
        int commentEndOffsetInInLineAfterWS = tokenStartOffsetInLineAfterWS + commentValueNoTrailWS.length();
        if (commentEndOffsetInInLineAfterWS + commentLineIndent > (wrapThreshold = this.fFormatPreferences.getLineWrapThreshold(this.fSourceViewerConfiguration.isPreview()))) {
            CFChunk indentableChunk = lineInfo.getIndentableChunk();
            if (indentableChunk == null) {
                return false;
            }
            List<String> commentWrapStrings = CFUtils.getInstance().splitComment(commentValueNoTrailWS, isSLComment, commentLineIndent, wrappedCommentIndent, wrapThreshold);
            int commentWrapStringOffsetInChunk = token.getStartOffsetInChunk();
            int i = 0;
            while (i < commentWrapStrings.size()) {
                String commentWrapString = commentWrapStrings.get(i);
                if (i == 0) {
                    int lineStartWSLength = lineInfo.getLineStartWSLength();
                    if (commentLineIndent != lineStartWSLength) {
                        indentableChunk.addAction(new CFAction(0, lineStartWSLength, CFUtils.getInstance().getWhitespace(commentLineIndent), causedBy));
                    }
                } else {
                    if (isSLComment) {
                        chunk.addAction(new CFAction(3, commentWrapStringOffsetInChunk, 0, commentPrefix, causedBy));
                    } else {
                        int nofWSCharsToDelete = commentWrapString.indexOf(commentWrapString.trim());
                        if (nofWSCharsToDelete != 0) {
                            chunk.addAction(new CFAction(3, commentWrapStringOffsetInChunk, nofWSCharsToDelete, "", causedBy));
                        }
                    }
                    if (wrappedCommentIndent != 0) {
                        chunk.addAction(new CFAction(2, commentWrapStringOffsetInChunk, 0, CFUtils.getInstance().getWhitespace(wrappedCommentIndent), causedBy));
                    }
                    chunk.addAction(new CFAction(1, commentWrapStringOffsetInChunk, 0, this.fSourceViewerConfiguration.getLineDelimiter(), causedBy));
                }
                commentWrapStringOffsetInChunk += commentWrapString.length();
                ++i;
            }
            return true;
        }
        return false;
    }

    protected int getCommentIndent(CFModel model, int commentLineNo) {
        CFLineInfo closestLineWithCode = model.getNextLineWithCode(commentLineNo);
        if (closestLineWithCode == null) {
            return 0;
        }
        int lineStartWSLength = closestLineWithCode.getLineStartWSLength();
        if (closestLineWithCode.getLineNo() == commentLineNo) {
            return lineStartWSLength;
        }
        CFChunk chunk = closestLineWithCode.getFirstChunk();
        if (chunk == null) {
            return lineStartWSLength;
        }
        DVTSourceViewerConfiguration svc = this.getSourceViewerConfiguration();
        if (svc == null) {
            return lineStartWSLength;
        }
        DVTBaseCodeFormattingStrategy codeFormattingStrategy = svc.getCodeFormattingStrategy();
        if (codeFormattingStrategy == null) {
            return lineStartWSLength;
        }
        CFToken firstToken = null;
        List<CFToken> tokens = codeFormattingStrategy.createTokens(model, chunk);
        if (tokens == null) {
            return lineStartWSLength;
        }
        for (CFToken token : tokens) {
            String tokenValue;
            if (token == null || (tokenValue = token.getValue()) == null || tokenValue.trim().isEmpty()) continue;
            firstToken = token;
            break;
        }
        if (firstToken == null) {
            return lineStartWSLength;
        }
        int chunkType = chunk.getType();
        if (codeFormattingStrategy.isClosingToken(firstToken.getValue()) && chunkType != 4 && chunkType != 3) {
            return lineStartWSLength + svc.getTabWidth();
        }
        return lineStartWSLength;
    }

    @Override
    public Set<String> getAddWSBeforePref() {
        return null;
    }

    @Override
    public Set<String> getAddWSAfterPref() {
        return null;
    }
}

