/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.strategies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.ICFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public abstract class DVTBaseFormattingStrategy
extends ContextBasedFormattingStrategy
implements IDVTFormattingStrategy {
    protected final int fChunkType;
    protected DVTSourceViewerConfiguration fSourceViewerConfiguration;
    protected CFPreferences fFormatPreferences;
    private int nofConsecutiveEmptyLines;
    public static final int NONE_KEYWORD = 0;
    public static final int OPEN_KEYWORD = 1;
    public static final int CLOSE_KEYWORD = 2;
    protected Set<String> CLOSE_KEYWORDS;
    public static final int SIMPLE_KEYWORD = 3;
    protected Set<String> SIMPLE_KEYWORDS;
    public static final int BEGIN_KEYWORD = 4;
    protected String BEGIN_KEYWORD_VALUE;
    public static final int SPECIAL_KEYWORD = 5;
    protected Set<String> SPECIAL_KEYWORDS;
    public static final int OPERATOR = 6;
    protected Set<String> ASSIGNMENT_OPERATORS;
    protected Set<String> RELATIONAL_OPERATORS;
    protected Set<String> EQUALITY_OPERATORS;
    public static final int NONE_PREPROC_KEYWORD = 0;
    public static final int OPEN_PREPROC_KEYWORD = 1;
    protected Set<String> OPEN_PREPROCS;
    public static final int CLOSE_PREPROC_KEYWORD = 2;
    protected Set<String> CLOSE_PREPROCS;
    public static final int MIDDLE_PREPROC_KEYWORD = 3;
    protected Set<String> MIDDLE_PREPROCS;
    public static final int SIMPLE_PREPROC_KEYWORD = 4;
    protected Set<String> SIMPLE_PREPROCS;
    public static final int COMPLEX_PREPROC_KEYWORD = 5;
    protected Set<String> COMPLEX_PREPROCS;
    protected int fTabWidth;
    protected List<CFVRegExBaseDefinition> fEnabledVRegExPref;

    protected DVTBaseFormattingStrategy(DVTSourceViewerConfiguration configuration, CFPreferences formatPreferences, int chunkType) {
        this.fSourceViewerConfiguration = configuration;
        this.fFormatPreferences = formatPreferences;
        this.fChunkType = chunkType;
        this.CLOSE_KEYWORDS = new HashSet<String>();
        this.SPECIAL_KEYWORDS = new HashSet<String>();
        this.SIMPLE_KEYWORDS = new HashSet<String>();
        this.ASSIGNMENT_OPERATORS = new HashSet<String>();
        this.RELATIONAL_OPERATORS = new HashSet<String>();
        this.EQUALITY_OPERATORS = new HashSet<String>();
        this.OPEN_PREPROCS = new HashSet<String>();
        this.MIDDLE_PREPROCS = new HashSet<String>();
        this.CLOSE_PREPROCS = new HashSet<String>();
        this.SIMPLE_PREPROCS = new HashSet<String>();
        this.COMPLEX_PREPROCS = new HashSet<String>();
        this.fEnabledVRegExPref = new ArrayList<CFVRegExBaseDefinition>();
        this.nofConsecutiveEmptyLines = 0;
    }

    public DVTSourceViewerConfiguration getSourceViewerConfiguration() {
        return this.fSourceViewerConfiguration;
    }

    @Override
    public CFPreferences getFormatPreferences() {
        return this.fFormatPreferences;
    }

    public void formatterStarts(String indentation) {
        super.formatterStarts(indentation);
        this.fTabWidth = this.fFormatPreferences.getTabWidth();
        this.fSourceViewerConfiguration.refreshTabWidth(this.fTabWidth);
        this.fSourceViewerConfiguration.refreshInsertSpaces(this.fFormatPreferences.isUseSpacesForTabsEnabled());
        this.refreshVRegExPref();
    }

    public void formatterStops() {
        super.formatterStops();
    }

    @Override
    public void dispose() {
        this.fSourceViewerConfiguration = null;
        this.fFormatPreferences = null;
    }

    public String filterInitialPartitionContent(String text) {
        return text;
    }

    public boolean ignoreLine(String firstChunkOnLineValue) {
        return false;
    }

    public List<String> getVAlignTokensPref() {
        return null;
    }

    public boolean isValidVAlignWithoutBoundary(String vTokenString) {
        return false;
    }

    public boolean isValidVAlignBoundaryChar(String vTokenString, char ch, boolean before) {
        return false;
    }

    public boolean isValidVAlignContext(char prevChar, String vTokenString) {
        return false;
    }

    private void refreshVRegExPref() {
        this.fEnabledVRegExPref.clear();
        List<CFVRegExBaseDefinition> allDefs = this.fFormatPreferences.getVRegExPref();
        for (CFVRegExBaseDefinition def : allDefs) {
            if (def == null || !def.isEnabled()) continue;
            this.fEnabledVRegExPref.add(def);
        }
    }

    public List<CFVRegExBaseDefinition> getEnabledVRegExPref() {
        return this.fEnabledVRegExPref;
    }

    public int getChunkType() {
        return this.fChunkType;
    }

    public int getKeywordType(String word) {
        if (this.isBeginKeyword(word)) {
            return 4;
        }
        if (this.isOpenKeyword(word)) {
            return 1;
        }
        if (this.isCloseKeyword(word)) {
            return 2;
        }
        if (this.isSimpleKeyword(word)) {
            return 3;
        }
        if (this.isSpecialKeyword(word)) {
            return 5;
        }
        if (this.isAssignmentOperatorKeyword(word)) {
            return 6;
        }
        return 0;
    }

    public Set<String> getOpenCodeBlockKeywords() {
        return null;
    }

    public Set<String> getOpenKeywords() {
        return null;
    }

    protected boolean isOpenKeyword(String word) {
        return this.isKeywordOf(word, this.getOpenKeywords());
    }

    public Set<String> getCloseCodeBlockKeywords() {
        return null;
    }

    public Set<String> getCloseKeywords() {
        return null;
    }

    public Set<String> getEqualityOperatorKeywords() {
        return null;
    }

    public boolean isEqualityOperatorKeyword(String word) {
        return this.isKeywordOf(word, this.getEqualityOperatorKeywords());
    }

    public Set<String> getRelationalOperatorKeywords() {
        return null;
    }

    public boolean isRelationalOperatorKeyword(String word) {
        return this.isKeywordOf(word, this.getRelationalOperatorKeywords());
    }

    public Set<String> getAssignmentOperatorKeywords() {
        return null;
    }

    public boolean isAssignmentOperatorKeyword(String word) {
        return this.isKeywordOf(word, this.getAssignmentOperatorKeywords());
    }

    public boolean isCloseKeyword(String word) {
        return this.isKeywordOf(word, this.getCloseKeywords());
    }

    public Set<String> getSimpleKeywords() {
        return null;
    }

    public boolean isSimpleKeyword(String word) {
        return this.isKeywordOf(word, this.getSimpleKeywords());
    }

    public String getBeginKeyword() {
        return null;
    }

    public boolean isBeginKeyword(String word) {
        String beginKeyword = this.getBeginKeyword();
        if (beginKeyword == null || word == null) {
            return false;
        }
        return beginKeyword.equals(word);
    }

    public Set<String> getSpecialKeywords() {
        return null;
    }

    protected boolean isSpecialKeyword(String word) {
        return this.isKeywordOf(word, this.getSpecialKeywords());
    }

    public int getPreprocType(String word) {
        if (this.isOpenPreproc(word)) {
            return 1;
        }
        if (this.isMiddlePreproc(word)) {
            return 3;
        }
        if (this.isClosePreproc(word)) {
            return 2;
        }
        if (this.isSimplePreproc(word)) {
            return 4;
        }
        if (this.isComplexPreproc(word)) {
            return 5;
        }
        return 0;
    }

    public Set<String> getOpenPreprocs() {
        return null;
    }

    protected boolean isOpenPreproc(String word) {
        return this.isKeywordOf(word, this.getOpenPreprocs());
    }

    public Set<String> getMiddlePreprocs() {
        return null;
    }

    protected boolean isMiddlePreproc(String word) {
        return this.isKeywordOf(word, this.getMiddlePreprocs());
    }

    public Set<String> getClosePreprocs() {
        return null;
    }

    protected boolean isClosePreproc(String word) {
        return this.isKeywordOf(word, this.getClosePreprocs());
    }

    public Set<String> getSimplePreprocs() {
        return null;
    }

    protected boolean isSimplePreproc(String word) {
        return this.isKeywordOf(word, this.getSimplePreprocs());
    }

    public Set<String> getComplexPreprocs() {
        return null;
    }

    public Set<String> getAllPreprocs() {
        return null;
    }

    protected boolean isComplexPreproc(String word) {
        return this.isKeywordOf(word, this.getComplexPreprocs());
    }

    public boolean isOpenCodeBlockKeyword(String word) {
        return this.isKeywordOf(word, this.getOpenCodeBlockKeywords());
    }

    public boolean isCloseCodeBlockKeyword(String word) {
        return this.isKeywordOf(word, this.getCloseCodeBlockKeywords());
    }

    public boolean isImplicitSemiMacro(String word) {
        return false;
    }

    public boolean isImplicitSemiParamMacro(String word) {
        return false;
    }

    public boolean isNoIndentKeywordPref(String word) {
        Set<String> noIndentKeywordsPref = this.fFormatPreferences.getNoIndentKeywordsPref();
        if (noIndentKeywordsPref == null) {
            return false;
        }
        return noIndentKeywordsPref.contains(word);
    }

    private boolean isKeywordOf(String word, Set<String> words) {
        if (word == null || words == null) {
            return false;
        }
        return words.contains(word);
    }

    public Map<String[], String[]> getSkipIndentKeywordPairs() {
        return null;
    }

    public boolean isSkipIndent(String prevWord, String word) {
        if (prevWord == null || word == null) {
            return false;
        }
        Map<String[], String[]> skipIndentKeywordPairs = this.getSkipIndentKeywordPairs();
        if (skipIndentKeywordPairs == null) {
            return false;
        }
        for (Map.Entry<String[], String[]> skipIndentKeywordPair : skipIndentKeywordPairs.entrySet()) {
            String[] keys;
            String[] stringArray = keys = skipIndentKeywordPair.getKey();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (keys != null && key.equals(prevWord)) {
                    String[] values;
                    String[] stringArray2 = values = skipIndentKeywordPair.getValue();
                    int n3 = values.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String value = stringArray2[n4];
                        if (value != null && value.equals(word)) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isWordChar(char c, char prevChar, char nextChar, StringBuilder currWord) {
        return Character.isJavaIdentifierPart(c);
    }

    public boolean isSingleChar(char c, char prevChar, char nextChar) {
        return false;
    }

    @Override
    public void scanTokensInOrder(ICFTokenScanner tokenScanner, CFChunk chunk) {
        if (chunk == null) {
            return;
        }
        tokenScanner.startChunk(chunk);
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        List<CFToken> tokens = this.createTokens(tokenScanner.getModel(), chunk);
        if (tokens == null) {
            return;
        }
        for (CFToken token : tokens) {
            if (token == null) continue;
            tokenScanner.startToken(token);
            int currTokenIndex = tokens.indexOf(token);
            if (currTokenIndex + 1 < tokens.size()) {
                tokenScanner.setNextKeywordTokenInChunk(this.getNextKeywordTokenInChunk(tokens, currTokenIndex));
                tokenScanner.setFirstNWSTokenInChunkAfterCurrToken(this.getNWSTokenInChunkAfterCurrTokenAtIndex(tokens, currTokenIndex, 1));
                tokenScanner.setSecondNWSTokenInChunkAfterCurrToken(this.getNWSTokenInChunkAfterCurrTokenAtIndex(tokens, currTokenIndex, 2));
                tokenScanner.setThirdNWSTokenInChunkAfterCurrToken(this.getNWSTokenInChunkAfterCurrTokenAtIndex(tokens, currTokenIndex, 3));
            } else {
                tokenScanner.resetNWSTokens();
            }
            tokenScanner.analyzeToken(token);
            tokenScanner.endToken(token);
        }
        tokenScanner.endChunk(chunk);
    }

    public CFToken getNextKeywordTokenInChunk(List<CFToken> tokens, int index) {
        int i = index + 1;
        while (i < tokens.size()) {
            CFToken token = tokens.get(i);
            if (token != null && this.getKeywordType(token.getValue()) != 0) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public CFToken getNWSTokenInChunkAfterCurrTokenAtIndex(List<CFToken> tokens, int currTokenIndex, int nextNWSTokenIndex) {
        int currIndex = 0;
        int i = currTokenIndex + 1;
        while (i < tokens.size()) {
            CFToken token = tokens.get(i);
            if (token != null && token.getTokenType() != 3 && ++currIndex == nextNWSTokenIndex) {
                return token;
            }
            ++i;
        }
        return null;
    }

    protected abstract List<CFToken> createTokens(CFModel var1, CFChunk var2);

    @Override
    public int replaceTabsWithSpaces(CFChunk chunk, int offset) {
        if (chunk == null) {
            return 0;
        }
        String content = chunk.getValue();
        int length = content.length();
        int i = 0;
        while (i < length) {
            char ch = content.charAt(i);
            if (ch == '\t') {
                int tabUpdate = this.fTabWidth - offset % this.fTabWidth;
                String replacement = TextUtils.getIndentTab(true, tabUpdate);
                chunk.addAction(new CFAction(i, 1, replacement, "replace tabs with spaces"));
                offset += tabUpdate;
            } else {
                offset = ch == '\r' || ch == '\n' ? 0 : ++offset;
            }
            ++i;
        }
        return offset;
    }

    @Override
    public void trimEmptyLines(CFChunk chunk) {
        int nofWSCharsToDelete;
        String trimmedChunksContent;
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (chunk.endsWithNL() && (trimmedChunksContent = lineInfo.getChunksContent().trim()).isEmpty() && (nofWSCharsToDelete = chunk.getNLOffset()) != 0) {
            chunk.addAction(new CFAction(0, nofWSCharsToDelete, "", "trim empty line"));
        }
    }

    @Override
    public void trimEndOfLineWhitespace(CFToken token) {
        int nofWSCharsToDelete;
        if (token == null) {
            return;
        }
        if (token.getTokenType() != 3) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        if (chunk.isFirstOnLine() && token.getStartOffsetInChunk() == 0) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.getNLOffsetInLine() >= token.getStartOffsetInLine() && lineInfo.getNLOffsetInLine() <= token.getEndOffsetInLine() && (nofWSCharsToDelete = token.getValue().length() - chunk.getNLLength()) != 0) {
            chunk.addAction(new CFAction(token.getStartOffsetInChunk(), nofWSCharsToDelete, "", "trim end of line whitespace"));
        }
    }

    @Override
    public void compactWhitespace(CFToken token) {
        if (token == null) {
            return;
        }
        if (token.getTokenType() != 3) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        if (chunk.isFirstOnLine() && token.getStartOffsetInChunk() == 0) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.getNLOffsetInLine() >= token.getStartOffsetInLine() && lineInfo.getNLOffsetInLine() <= token.getEndOffsetInLine()) {
            return;
        }
        String tokenValue = token.getValue();
        int nofCharsToDelete = tokenValue.length() - 1;
        if (nofCharsToDelete != 0) {
            chunk.addAction(new CFAction(token.getStartOffsetInChunk(), nofCharsToDelete, "", "compact whitespace"));
        }
    }

    @Override
    public void compactConsecutiveEmptyLines(CFChunk chunk, CFModel model, boolean compactLastEmptyLines) {
        if (chunk == null) {
            return;
        }
        if (chunk.getType() == 4) {
            return;
        }
        if (compactLastEmptyLines) {
            CFLineInfo lastLineInfo = model.getLastLineInfo();
            if (lastLineInfo == null) {
                return;
            }
            int lastLineNo = lastLineInfo.getLineNo();
            CFLineInfo lastNWLineInfo = model.getLastNonWhitespaceLine();
            if (lastNWLineInfo == null) {
                return;
            }
            int lastNWLineNo = lastNWLineInfo.getLineNo();
            int nofEmptyLines = lastLineNo - lastNWLineNo;
            CFChunk lastChunk = lastLineInfo.getLastChunk();
            if (lastChunk == null) {
                return;
            }
            if (lastChunk.endsWithNL()) {
                ++nofEmptyLines;
            }
            int maxNofConsecutiveEmptyLines = this.fFormatPreferences.getMaximumNofConsecutiveEmptyLines();
            int nofExceedingLines = nofEmptyLines - maxNofConsecutiveEmptyLines;
            int i = 0;
            while (i < nofExceedingLines) {
                CFChunk crtChunkToDelete;
                CFLineInfo crtLineToDelete = model.getLineInfo(lastNWLineNo + i);
                if (crtLineToDelete != null && (crtChunkToDelete = crtLineToDelete.getLastChunk()) != null) {
                    crtChunkToDelete.addAction(new CFAction(crtChunkToDelete.getLength() - 1, 1, "", "compact consecutive empty lines"));
                    this.removeLeadingWSFromNextLine(crtLineToDelete.getLineNo() + 1, model);
                }
                ++i;
            }
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        String trimmedChunksContent = lineInfo.getChunksContent().trim();
        if (trimmedChunksContent.isEmpty()) {
            ++this.nofConsecutiveEmptyLines;
            int maxNofConsecutiveEmptyLines = this.fFormatPreferences.getMaximumNofConsecutiveEmptyLines();
            if (this.nofConsecutiveEmptyLines > maxNofConsecutiveEmptyLines) {
                --this.nofConsecutiveEmptyLines;
                chunk.addAction(new CFAction(0, chunk.getLength(), "", "compact consecutive empty lines"));
            }
        } else {
            this.resetNofConsecutiveEmptyLines();
        }
    }

    private void removeLeadingWSFromNextLine(int nextLineNo, CFModel model) {
        CFLineInfo nextLineInfo = model.getLineInfo(nextLineNo);
        if (nextLineInfo == null) {
            return;
        }
        CFChunk nextLineChunk = nextLineInfo.getLastChunk();
        if (nextLineChunk == null) {
            return;
        }
        int lineStartWSLength = nextLineInfo.getLineStartWSLength();
        if (lineStartWSLength == 0) {
            return;
        }
        nextLineChunk.addAction(new CFAction(0, lineStartWSLength, "", "compact consecutive empty lines"));
    }

    public void resetNofConsecutiveEmptyLines() {
        this.nofConsecutiveEmptyLines = 0;
    }

    public boolean allowWhitespaceBeforeToken(CFToken token) {
        return false;
    }

    public boolean allowWhitespaceAfterToken(CFToken token) {
        return false;
    }

    public boolean isAddWhitespaceAfterToken(CFToken token) {
        return false;
    }

    @Override
    public void addWhitespaceBefore(CFToken token) {
    }

    @Override
    public void addWhitespaceAfter(CFToken token) {
    }

    @Override
    public void fixWhitespaceAfterCodeMarkerInExpansion(CFToken token) {
    }

    @Override
    public void indentStandaloneComments(CFModel model, CFChunk chunk) {
    }

    @Override
    public void indentUsingTabs(CFModel model, CFToken token) {
        if (token == null) {
            return;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        CFChunk indentableChunk = lineInfo.getIndentableChunk();
        if (indentableChunk == null) {
            return;
        }
        int nofWSChars = lineInfo.getLineStartWSLength();
        if (nofWSChars != 0) {
            indentableChunk.addAction(new CFAction(0, nofWSChars, this.getSpaceOrTabsString(nofWSChars), "indent using tabs"));
        }
    }

    @Override
    public void capitalize(CFModel model, CFToken token) {
    }

    public String getSpaceOrTabsString(int length) {
        CFPreferences formatPreferences = this.getFormatPreferences();
        StringBuilder str = new StringBuilder();
        char WS = ' ';
        char TAB = '\t';
        if (CFUtils.getInstance().shouldUseTabs(this.fSourceViewerConfiguration, formatPreferences)) {
            int tabs = length / this.fTabWidth;
            int spaces = length % this.fTabWidth;
            int i = 0;
            while (i < tabs) {
                str.append(TAB);
                ++i;
            }
            i = 0;
            while (i < spaces) {
                str.append(WS);
                ++i;
            }
        } else {
            int i = 0;
            while (i < length) {
                str.append(WS);
                ++i;
            }
        }
        return str.toString();
    }

    public boolean isCodeMarkerInExpansion(String chunkValue) {
        return false;
    }

    public abstract Set<String> getAddWSBeforePref();

    public abstract Set<String> getAddWSAfterPref();
}

