/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.strategies;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.utils.DVTStringBuilder;

public abstract class DVTBaseLiteralFormattingStrategy
extends DVTBaseFormattingStrategy {
    public DVTBaseLiteralFormattingStrategy(DVTSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super(configuration, formatPreferences, 2);
    }

    @Override
    public int replaceTabsWithSpaces(CFChunk chunk, int offset) {
        return offset + chunk.getLength();
    }

    @Override
    protected List<CFToken> createTokens(CFModel model, CFChunk chunk) {
        ArrayList<CFToken> result = new ArrayList<CFToken>();
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return result;
        }
        DVTStringBuilder trailingWS = new DVTStringBuilder();
        String chunkValue = chunk.getValue();
        int trailingWSOffset = chunkValue.length() - 1;
        while (trailingWSOffset >= 0) {
            char c = chunkValue.charAt(trailingWSOffset);
            if (!Character.isWhitespace(c)) break;
            trailingWS.prepend(c);
            --trailingWSOffset;
        }
        CFToken literalToken = new CFToken(chunk, 10, chunk.getValue().substring(0, chunkValue.length() - trailingWS.length()), 0, chunk.isFirstOnLine() || lineInfo.areAllPrevChunksWS(chunk));
        result.add(literalToken);
        if (trailingWS.length() != 0) {
            CFToken wsToken = new CFToken(chunk, 3, trailingWS.toString(), trailingWSOffset + 1, false);
            result.add(wsToken);
        }
        return result;
    }

    @Override
    public Set<String> getAddWSBeforePref() {
        return null;
    }

    @Override
    public Set<String> getAddWSAfterPref() {
        return null;
    }
}

