/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.strategies;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCommentFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;

public abstract class DVTBaseSLCommentFormattingStrategy
extends DVTBaseCommentFormattingStrategy {
    public DVTBaseSLCommentFormattingStrategy(DVTSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super(configuration, formatPreferences, 3);
    }

    @Override
    protected List<CFToken> createTokens(CFModel model, CFChunk chunk) {
        ArrayList<CFToken> result = new ArrayList<CFToken>();
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null || lineInfo.isIgnoreLine()) {
            return result;
        }
        String chunkValue = chunk.getValue();
        StringBuilder startingWS = new StringBuilder();
        int startingWSOffset = 0;
        while (startingWSOffset < chunkValue.length()) {
            char c = chunkValue.charAt(startingWSOffset);
            if (!Character.isWhitespace(c)) break;
            startingWS.append(c);
            ++startingWSOffset;
        }
        DVTStringBuilder trailingWS = new DVTStringBuilder();
        int trailingWSOffset = chunkValue.length() - 1;
        while (trailingWSOffset > startingWS.length()) {
            char c = chunkValue.charAt(trailingWSOffset);
            if (!Character.isWhitespace(c)) break;
            trailingWS.prepend(c);
            --trailingWSOffset;
        }
        if (startingWS.length() != 0) {
            CFToken wsToken = new CFToken(chunk, 3, startingWS.toString(), 0, false);
            result.add(wsToken);
        }
        if (chunkValue.length() != startingWS.length()) {
            CFToken commentToken = new CFToken(chunk, 30, chunk.getValue().substring(startingWS.length(), chunkValue.length() - trailingWS.length()), startingWS.length(), chunk.isFirstOnLine() || lineInfo.areAllPrevChunksWS(chunk));
            result.add(commentToken);
        }
        if (trailingWS.length() != 0) {
            CFToken wsToken = new CFToken(chunk, 3, trailingWS.toString(), trailingWSOffset + 1, false);
            result.add(wsToken);
        }
        return result;
    }

    @Override
    public void indentStandaloneComments(CFModel model, CFChunk chunk) {
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.containsPreproc()) {
            return;
        }
        List<CFToken> tokens = this.createTokens(model, chunk);
        int i = 0;
        while (i < tokens.size()) {
            CFToken token = tokens.get(i);
            if (token.getTokenType() == 30) {
                this.indentSLComment(model, token);
            }
            ++i;
        }
    }

    public void indentSLComment(CFModel model, CFToken token) {
        CFLineInfo closestLineWithCode;
        int lineStartWSLength;
        if (token == null) {
            return;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        int lineIndent = lineStartWSLength = lineInfo.getLineStartWSLength();
        int onIndex = chunk.getValue().indexOf("@formatter:on", 0);
        lineIndent = onIndex != -1 ? ((closestLineWithCode = model.getNextLineWithCode(token.getLineNo())) == null ? 0 : closestLineWithCode.getLineStartWSLength()) : this.getCommentIndent(model, token.getLineNo());
        if (this.fFormatPreferences.isPreserveSLCommentAtColumnZeroEnabled() && token.getStartOffsetInLine() == 0) {
            lineIndent = 0;
        }
        if (this.fFormatPreferences.isLineWrapEnabled() && this.fFormatPreferences.isLineWrapSLCommentsEnabled() && this.tryCommentWrap(model, token, "standalone sl comment wrap")) {
            return;
        }
        CFUtils.getInstance().indentLine(lineInfo, lineIndent, model.indentFirstLine(), "indent sl comment");
    }
}

