/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.util;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFChunkTokenizerBaseState;
import ro.amiq.dvt.ui.editor.formatter.util.CFChunkTokenizerCharsState;
import ro.amiq.dvt.ui.editor.formatter.util.CFChunkTokenizerSingleCharState;
import ro.amiq.dvt.ui.editor.formatter.util.CFChunkTokenizerWhitespaceState;
import ro.amiq.dvt.ui.editor.formatter.util.CFChunkTokenizerWordState;

public class CFChunkTokenizer {
    private DVTBaseFormattingStrategy fDVTFormattingStrategy;
    private CFChunk fEnclosingChunk;
    private CFChunkTokenizerBaseState fCurrentState;
    private List<CFToken> fTokens;
    private boolean fIsFirstNWSTokenOnLine;
    private char fPrevChar;
    private char fNextChar;

    public CFChunkTokenizer(DVTBaseFormattingStrategy aFormattingStrategy, CFChunk enclosingChunk) {
        this.fDVTFormattingStrategy = aFormattingStrategy;
        this.fEnclosingChunk = enclosingChunk;
        this.fTokens = new ArrayList<CFToken>();
        this.fCurrentState = new CFChunkTokenizerWhitespaceState(this, 0);
        this.fIsFirstNWSTokenOnLine = enclosingChunk.isFirstOnLine();
    }

    public CFChunk getEnclosingChunk() {
        return this.fEnclosingChunk;
    }

    public List<CFToken> getTokens(String aString) {
        CFLineInfo lineInfo;
        if (this.fEnclosingChunk != null && (lineInfo = this.fEnclosingChunk.getEnclosingLineInfo()) != null && lineInfo.isIgnoreLine()) {
            return null;
        }
        char[] chars = aString.toCharArray();
        this.fPrevChar = '\u0000';
        this.fNextChar = '\u0000';
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            this.fNextChar = i + 1 < chars.length ? chars[i + 1] : (char)'\u0000';
            this.processChar(c, i);
            this.fPrevChar = c;
            ++i;
        }
        this.addCurrentToken();
        return this.fTokens;
    }

    public void addCurrentToken() {
        CFToken token = this.createToken(this.fCurrentState.getTokenType(), this.fCurrentState.getTokenValue(), this.fCurrentState.getStartOffset());
        if (token != null && !token.getValue().isEmpty()) {
            this.fTokens.add(token);
        }
    }

    public void setNextState(int nextState, int startOffset) {
        this.addCurrentToken();
        switch (nextState) {
            case 3: {
                this.setWordState(startOffset);
                break;
            }
            case 2: {
                this.setCharGroupState(startOffset);
                break;
            }
            case 1: {
                this.setWhiteSpacesState(startOffset);
                break;
            }
            case 4: {
                this.setSingleCharState(startOffset);
            }
        }
    }

    public void setWordState(int startIndex) {
        this.fCurrentState = new CFChunkTokenizerWordState(this, startIndex);
    }

    public void setCharGroupState(int startIndex) {
        this.fCurrentState = new CFChunkTokenizerCharsState(this, startIndex);
    }

    public void setSingleCharState(int startIndex) {
        this.fCurrentState = new CFChunkTokenizerSingleCharState(this, startIndex);
    }

    public void setWhiteSpacesState(int startIndex) {
        this.fCurrentState = new CFChunkTokenizerWhitespaceState(this, startIndex);
    }

    public void processChar(char c, int charIndex) {
        this.fCurrentState.processChar(c, charIndex);
    }

    public void appendChar(char c) {
        this.fCurrentState.appendChar(c);
    }

    public boolean isSingleChar(char c) {
        return this.fDVTFormattingStrategy.isSingleChar(c, this.fPrevChar, this.fNextChar);
    }

    public boolean isWordChar(char c) {
        return this.fDVTFormattingStrategy.isWordChar(c, this.fPrevChar, this.fNextChar, this.fCurrentState.getTokenType() == 2 ? this.fCurrentState.getCurrentTokenValue() : null);
    }

    public CFToken createToken(int tokenType, String tokenValue, int tokenStartOffset) {
        boolean tokenIsFirstNWS = false;
        if (this.fIsFirstNWSTokenOnLine && tokenType != 3) {
            tokenIsFirstNWS = true;
            this.fIsFirstNWSTokenOnLine = false;
        }
        return new CFToken(this.fEnclosingChunk, tokenType, tokenValue, tokenStartOffset, tokenIsFirstNWS);
    }
}

