/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.util;

public class CFNLSplitter {
    private CharSequence fInput;
    private String fNLGroup;
    private int fNLEndOffset;
    private int fNLStartOffset;

    public CFNLSplitter(CharSequence input) {
        this.fInput = input;
        this.fNLEndOffset = 0;
        this.fNLStartOffset = 0;
    }

    public boolean find() {
        if (this.fInput == null) {
            return false;
        }
        int length = this.fInput.length();
        int i = this.fNLEndOffset;
        while (i < length) {
            char ch = this.fInput.charAt(i);
            if (ch == '\r') {
                this.fNLStartOffset = i;
                this.fNLEndOffset = i + 1;
                if (i < length - 1 && this.fInput.charAt(i + 1) == '\n') {
                    this.fNLGroup = "\r\n";
                    ++this.fNLEndOffset;
                    ++i;
                } else {
                    this.fNLGroup = "\r";
                }
                return true;
            }
            if (ch == '\n') {
                this.fNLStartOffset = i;
                this.fNLEndOffset = i + 1;
                this.fNLGroup = "\n";
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getNLEndOffset() {
        return this.fNLEndOffset;
    }

    public int getNLStartOffset() {
        return this.fNLStartOffset;
    }

    public String getNLGroup() {
        return this.fNLGroup;
    }
}

