/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtilsCommon;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTFileUtils;

public class CFUtils
extends CFUtilsCommon {
    private static final Object LOCK = new Object();
    private static CFUtils INSTANCE;

    private CFUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFUtils getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new CFUtils();
            }
        }
        return INSTANCE;
    }

    public boolean shouldUseTabs(DVTSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        if (PrefConst.isDetectIndentationEnabled()) {
            return !configuration.getInsertSpaces();
        }
        return formatPreferences != null && !formatPreferences.isUseSpacesForTabsEnabled();
    }

    public IDocument getDetectIndentationDocument(String filePath) {
        IProject project = DVTFileUtils.getInstance().getSelectedProject();
        if (project == null) {
            return null;
        }
        IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, filePath);
        if (file == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getOpenDocument(file);
        return document;
    }

    public boolean shouldFormatOnPaste(String text) {
        if (text == null || text.length() <= 1) {
            return false;
        }
        String autoformatOnPastePref = DVTPlugin.getDefault().getPreferenceStore().getString("format.format_on_paste");
        if (autoformatOnPastePref == null || autoformatOnPastePref.isEmpty()) {
            return false;
        }
        return !"Disabled".equals(autoformatOnPastePref);
    }
}

