/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.formatter.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;

public abstract class CFUtilsCommon {
    private static final Pattern WS_PATTERN = Pattern.compile("\\s+");

    public List<String> splitComment(String slComment, boolean isSLComment, int slStartOffset, int slIndent, int wrapThreshold) {
        ArrayList<String> result = new ArrayList<String>();
        String wcCommentValue = slComment;
        boolean gotNWSChar = false;
        int mostRecentWSOffset = -1;
        int nofStartingWSCharsAfterSplit = -1;
        int charIndex = isSLComment ? 2 : 0;
        while (charIndex < wcCommentValue.length()) {
            char currChar = wcCommentValue.charAt(charIndex);
            if (gotNWSChar && currChar == ' ' && (charIndex == 0 || wcCommentValue.charAt(charIndex - 1) != ' ')) {
                mostRecentWSOffset = charIndex;
            }
            if (currChar != ' ') {
                gotNWSChar = true;
            }
            if (!gotNWSChar && nofStartingWSCharsAfterSplit != -1 && currChar == ' ') {
                ++nofStartingWSCharsAfterSplit;
            }
            if (slStartOffset + charIndex + 1 - (isSLComment ? 0 : Math.max(nofStartingWSCharsAfterSplit, 0)) > wrapThreshold) {
                if (mostRecentWSOffset != -1) {
                    String slCommentWrapString = wcCommentValue.substring(0, mostRecentWSOffset);
                    result.add(slCommentWrapString);
                    wcCommentValue = wcCommentValue.substring(mostRecentWSOffset);
                    slStartOffset = slIndent + (isSLComment ? 2 : 0);
                    charIndex = 0;
                    gotNWSChar = false;
                    nofStartingWSCharsAfterSplit = 0;
                    mostRecentWSOffset = -1;
                    continue;
                }
                ++charIndex;
                continue;
            }
            ++charIndex;
        }
        if (wcCommentValue.length() > 0) {
            result.add(wcCommentValue);
        }
        return result;
    }

    public void indentLine(CFLineInfo lineInfo, int lineIndent, boolean indentFirstLine, String causedBy) {
        if (lineInfo == null) {
            return;
        }
        if (lineInfo.getLineNo() == 1 && !indentFirstLine) {
            return;
        }
        CFChunk indentableChunk = lineInfo.getIndentableChunk();
        if (indentableChunk == null) {
            return;
        }
        int lineStartWSLength = lineInfo.getLineStartWSLength();
        if (lineIndent != lineStartWSLength) {
            boolean done = false;
            CFPartition partition = indentableChunk.getEnclosingPartition();
            if (partition != null && partition.isFirstChunk(indentableChunk) && indentableChunk.getType() != 1 && indentableChunk.getStartOffsetInLine() == 0) {
                done = this.tryAddWhitespaceBeforeNonCodePartition(indentableChunk, lineIndent, causedBy);
            }
            if (!done) {
                indentableChunk.addAction(new CFAction(0, lineStartWSLength, this.getWhitespace(lineIndent), causedBy));
            }
        }
    }

    public String getWhitespace(int length) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < length) {
            str.append(' ');
            ++i;
        }
        return str.toString();
    }

    public boolean tryAddWhitespaceBeforeNonCodePartition(CFChunk chunk, int nofWSChars, String causedBy) {
        if (chunk == null) {
            return false;
        }
        if (chunk.getType() == 1) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        CFChunk prevChunk = lineInfo.getChunkBefore(chunk);
        if (prevChunk != null && prevChunk.getType() == 1) {
            prevChunk.addAction(new CFAction(prevChunk.getLength(), 0, this.getWhitespace(nofWSChars), causedBy));
            return true;
        }
        CFPartition partition = chunk.getEnclosingPartition();
        if (partition == null) {
            return false;
        }
        CFChunk codeChunk = partition.createCodeChunkBeforeSubPartitions();
        if (codeChunk != null) {
            codeChunk.addAction(new CFAction(0, 0, this.getWhitespace(nofWSChars), causedBy));
        }
        return true;
    }

    public boolean tryAddLineBreakBeforeNonCodePartition(CFChunk chunk, String lineDelimiter, int lineBreakIndent, String causedBy) {
        CFChunk codeChunk;
        if (chunk == null) {
            return false;
        }
        if (chunk.getType() == 1) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        CFChunk prevChunk = lineInfo.getChunkBefore(chunk);
        if (prevChunk != null && prevChunk.getType() == 1) {
            prevChunk.addAction(new CFAction(prevChunk.getLength(), 0, String.valueOf(lineDelimiter) + this.getWhitespace(lineBreakIndent), causedBy));
            return true;
        }
        CFPartition partition = chunk.getEnclosingPartition();
        if (partition != null && (codeChunk = partition.createCodeChunkBeforeSubPartitions()) != null) {
            codeChunk.addAction(new CFAction(0, 0, String.valueOf(lineDelimiter) + this.getWhitespace(lineBreakIndent), causedBy));
        }
        return true;
    }

    public boolean colonDelimitsLabel(String chunkValue, DVTBaseFormattingStrategy strategy) {
        return this.isColonPrecededByKeyword(chunkValue, strategy) || this.isColonFollowedByKeyword(chunkValue, strategy);
    }

    private boolean isColonPrecededByKeyword(String chunkValue, DVTBaseFormattingStrategy strategy) {
        String wordBeforeColon = this.getWordBeforeColon(chunkValue);
        if (wordBeforeColon == null) {
            return false;
        }
        if ("default".equals(wordBeforeColon)) {
            return false;
        }
        return this.isKeyword(wordBeforeColon, strategy);
    }

    private boolean isColonFollowedByKeyword(String chunkValue, DVTBaseFormattingStrategy strategy) {
        String wordAfterColon = this.getWordAfterColon(chunkValue);
        if (wordAfterColon == null) {
            return false;
        }
        return this.isKeyword(wordAfterColon, strategy);
    }

    private String getWordAfterColon(String chunkValue) {
        int colonIndex = chunkValue.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        if (chunkValue.length() <= colonIndex) {
            return null;
        }
        String afterColon = chunkValue.substring(colonIndex + 1);
        String[] afterColonWords = WS_PATTERN.split(afterColon = afterColon.trim());
        if (afterColonWords.length == 0) {
            return null;
        }
        return afterColonWords[0];
    }

    private String getWordBeforeColon(String chunkValue) {
        int colonIndex = chunkValue.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        String beforeColon = chunkValue.substring(0, colonIndex);
        String[] beforeColonWords = WS_PATTERN.split(beforeColon = beforeColon.trim());
        if (beforeColonWords.length == 0) {
            return null;
        }
        return beforeColonWords[beforeColonWords.length - 1];
    }

    private boolean isKeyword(String word, DVTBaseFormattingStrategy strategy) {
        int keywordType = strategy.getKeywordType(word);
        return keywordType == 1 || keywordType == 2 || keywordType == 5;
    }
}

