/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.fsbreadcrumb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCResourceWrapper;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;

public class FSBCLazyDropdownContentProvider
extends BCDropDownContentProvider
implements ILazyContentProvider {
    private FSBreadcrumbViewer breadcrumbViewer;
    private TableViewer dropdownViewer;
    private Object[] elements;
    private String prefix;

    public FSBCLazyDropdownContentProvider(TableViewer dropdownViewer, FSBreadcrumbViewer breadcrumbViewer) {
        this.dropdownViewer = dropdownViewer;
        this.breadcrumbViewer = breadcrumbViewer;
    }

    public void dispose() {
        try {
            if (this.breadcrumbViewer != null) {
                this.breadcrumbViewer.disposeDropDownModel();
            }
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.elements = (Object[])newInput;
    }

    public void updateElement(int index) {
        try {
            if (index >= this.elements.length) {
                return;
            }
            if (((FSBCResourceWrapper)this.elements[index]).isFiltered()) {
                Table table = this.dropdownViewer.getTable();
                if (table == null) {
                    return;
                }
                TableItem item = table.getItem(index);
                if (item == null) {
                    return;
                }
                item.setForeground(DVTUiUtils.COLOR_GRAY);
            }
            this.dropdownViewer.replace(this.elements[index], index);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Object[] filterInput(List<?> dropdownElements, boolean showAll, String text) {
        try {
            if (dropdownElements == null) {
                return new Object[1];
            }
            if (text == null) {
                text = this.prefix;
            }
            StringMatcher localMatcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher(text, true, false);
            Object[] filtered = dropdownElements.stream().filter(e -> {
                if (!(e instanceof FSBCResourceWrapper)) {
                    return true;
                }
                FSBCResourceWrapper wrapper = (FSBCResourceWrapper)e;
                return ViewsUtilsCommon.matchCamelCaseOrRegex(localMatcher, wrapper.getName());
            }).limit(showAll ? Integer.MAX_VALUE : 100).toArray();
            if (!showAll && filtered.length >= 100) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(filtered));
                list.add(0, FSBreadcrumbUtils.createDummyItem("Showing 100. Search or click for more"));
                filtered = list.toArray();
            }
            this.elements = filtered;
            return this.elements;
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
            return new Object[1];
        }
    }

    public Object[] testGetElements() {
        return (Object[])this.dropdownViewer.getInput();
    }
}

