/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.fsbreadcrumb;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class FSBCResourceWrapper
implements IRfBreadcrumbElement,
Comparable<FSBCResourceWrapper> {
    private File file;
    private IProject project;
    private IResource resource;
    private FSBCResourceWrapper parent;
    private boolean hasPermissions;
    private boolean hasChildren;
    private boolean isDirectory;

    public FSBCResourceWrapper(File element, IProject project) {
        this.file = element;
        this.project = project;
        if (this.file == null) {
            return;
        }
        this.hasPermissions = Files.isReadable(this.file.toPath());
        this.isDirectory = element.isDirectory();
        this.hasChildren = this.hasPermissions && this.isDirectory && this.computeHasChildren();
    }

    @Override
    public String getName() {
        if (this.file == null) {
            return null;
        }
        String result = this.file.getName();
        if (this.file.getParent() != null) {
            return result;
        }
        result = this.file.getAbsolutePath();
        if (result == null) {
            return "";
        }
        if (!"/".equals(result)) {
            return result.replace("\\", "");
        }
        return "";
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return null;
    }

    public void setParent(FSBCResourceWrapper parent) {
        this.parent = parent;
    }

    public FSBCResourceWrapper getParent() {
        return this.parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean computeHasChildren() {
        if (this.file == null) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> stream = Files.walk(this.file.toPath(), 1, FileVisitOption.FOLLOW_LINKS);){
                boolean bl;
                if (stream == null) {
                    return false;
                }
                Iterator iterator = stream.iterator();
                int count = 0;
                while (true) {
                    if (count > 2 || iterator == null || !iterator.hasNext()) {
                        if (count <= 1) break;
                        bl = true;
                        return bl;
                    }
                    ++count;
                    iterator.next();
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FSBCResourceWrapper)) {
            return false;
        }
        return this.file != null && this.file.equals(((FSBCResourceWrapper)obj).file);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        if (this.file == null) {
            return "";
        }
        return this.file.toString();
    }

    public String getFullPath() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }

    public IPath getPath() {
        if (this.file == null) {
            return null;
        }
        return DVTFileUtils.getInstance().pathOf(this.file);
    }

    public boolean isFiltered() {
        if (this.file == null || this.isDummy()) {
            return false;
        }
        if (!this.hasPermissions) {
            return true;
        }
        if (!this.isDirectory) {
            return false;
        }
        return !this.hasChildren();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public List<Object> getChildrenFiles(int count) {
        if (!(this.file != null && this.isDirectory && this.hasChildren && this.hasPermissions)) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> stream = Files.walk(this.file.toPath(), 1, FileVisitOption.FOLLOW_LINKS);){
                TreeSet result = new TreeSet();
                stream.limit(count).filter(p -> (p.getFileName() != null && ".dvt".equals(p.getFileName().toString()) || !p.toFile().isHidden()) && !p.equals(this.file.toPath())).forEach(p -> {
                    boolean bl = result.add(new FSBCResourceWrapper(p.toFile(), this.project));
                });
                return new ArrayList<Object>(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public int compareTo(FSBCResourceWrapper o) {
        if (this.file == null) {
            return 1;
        }
        if (o.file == null) {
            return -1;
        }
        if (this.file.isDirectory() && o.isDirectory()) {
            return this.file.getName().compareTo(o.file.getName());
        }
        if (this.isDirectory) {
            return -1;
        }
        if (o.isDirectory) {
            return 1;
        }
        return this.file.getName().compareTo(o.file.getName());
    }

    public URI getURI() {
        if (this.file == null) {
            return null;
        }
        return this.file.toURI();
    }

    public void openEditor() {
        if (this.file == null || !this.hasPermissions || this.isDirectory) {
            return;
        }
        try {
            IFile file;
            if (this.project != null && (file = this.project.getWorkspace().getRoot().getFileForLocation(this.getPath())) != null) {
                file.refreshLocal(0, null);
                DVTFileUtils.getInstance().openEditor(file, (IRegion)new Region(0, 0));
                return;
            }
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor[] editors = registry.getEditors(this.file.getName());
            if (editors == null || editors.length == 0) {
                Desktop.getDesktop().open(this.file);
                return;
            }
            DVTFileUtils.getInstance().openEditor(this.file, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getFilterText() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        if (this.isDummy()) {
            return name;
        }
        if (!this.hasPermissions) {
            return String.valueOf(name) + " (no permissions)";
        }
        if (!this.isDirectory) {
            return name;
        }
        if (!this.hasChildren()) {
            return String.valueOf(name) + " (empty)";
        }
        return name;
    }

    public boolean isDummy() {
        return false;
    }

    public IResource getResource() {
        if (this.resource != null) {
            return this.resource;
        }
        if (this.project == null || this.file == null) {
            return null;
        }
        if (!this.isDirectory) {
            this.resource = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(this.project, this.file.getAbsolutePath());
            return this.resource;
        }
        IPath path = this.getPath();
        if (path == null) {
            return null;
        }
        IPath projectLocation = this.project.getRawLocation();
        if (projectLocation == null) {
            return null;
        }
        path = path.removeFirstSegments(projectLocation.segmentCount() - 1);
        this.resource = this.project.getWorkspace().getRoot().findMember(path);
        return this.resource;
    }
}

