/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.fsbreadcrumb;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownTableViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.SlimBreadcrumbItemDropdown;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCLazyDropdownContentProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCResourceWrapper;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;

public class FSBreadcrumbItemDropDown
extends SlimBreadcrumbItemDropdown {
    private List<?> fDropdownElements;

    public FSBreadcrumbItemDropDown(AbstractBreadcrumbItem parent, Composite composite) {
        super(parent, composite);
    }

    public void showAllChildren() {
        if (this.fDropDownViewer == null || this.fParent == null) {
            return;
        }
        this.fDropdownElements = this.fParent.getDropDownElements();
        final FSBCLazyDropdownContentProvider provider = (FSBCLazyDropdownContentProvider)this.fDropDownViewer.getContentProvider();
        if (provider == null) {
            return;
        }
        if (this.fDropdownElements != null && this.fDropdownElements.size() != 100) {
            Object[] tableInputElements = provider.filterInput(this.fDropdownElements, true, null);
            this.refreshTable(tableInputElements);
            return;
        }
        final Object data = this.fParent.getData();
        if (this.fDropdownJob != null) {
            this.fDropdownJob.cancel();
        }
        this.fDropdownJob = new Job("Computing dropdown elements for " + this.fParent.getText()){

            protected IStatus run(IProgressMonitor monitor) {
                ((FSBreadcrumbViewer)((FSBreadcrumbItemDropDown)FSBreadcrumbItemDropDown.this).fParent.getViewer()).computeAllDDChildren = true;
                FSBreadcrumbItemDropDown.this.fParent.getViewer().computeDropdownElements(data);
                FSBreadcrumbItemDropDown.this.fDropdownElements = FSBreadcrumbItemDropDown.this.fParent.getDropDownElements();
                Object[] tableInputElements = provider.filterInput(FSBreadcrumbItemDropDown.this.fDropdownElements, true, null);
                FSBreadcrumbItemDropDown.runOnGUIThread(() -> FSBreadcrumbItemDropDown.this.refreshTable(tableInputElements));
                ObjectionManager.getInstance().clear(Objection.BREADCRUMB_DROPDOWN);
                return Status.OK_STATUS;
            }
        };
        this.fDropdownJob.setSystem(true);
        this.fDropdownJob.schedule();
    }

    @Override
    public void updateDropDownViewer(final String searchText) {
        if (this.fDropDownViewer == null || this.fParent == null) {
            return;
        }
        this.fDropdownElements = this.fParent.getDropDownElements();
        if (this.fDropdownElements == null) {
            return;
        }
        if (searchText == null || "".equals(searchText)) {
            this.showComputedElements();
            return;
        }
        FSBCResourceWrapper dummyItem = FSBreadcrumbUtils.createDummyItem("Searching...");
        this.setDummyInput(dummyItem);
        final FSBCLazyDropdownContentProvider contentProvider = (FSBCLazyDropdownContentProvider)this.fDropDownViewer.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        contentProvider.setPrefix(searchText);
        if (this.fDropdownElements.size() != 100) {
            Object[] tableInputElements = contentProvider.filterInput(this.fDropdownElements, false, searchText);
            this.refreshTable(tableInputElements);
            return;
        }
        final Object data = this.fParent.getData();
        if (this.fDropdownJob != null) {
            this.fDropdownJob.cancel();
        }
        this.fDropdownJob = new Job("Computing dropdown elements for " + this.fParent.getText()){

            protected IStatus run(IProgressMonitor monitor) {
                ((FSBreadcrumbViewer)((FSBreadcrumbItemDropDown)FSBreadcrumbItemDropDown.this).fParent.getViewer()).computeAllDDChildren = true;
                FSBreadcrumbItemDropDown.this.fParent.getViewer().computeDropdownElements(data);
                FSBreadcrumbItemDropDown.this.fDropdownElements = FSBreadcrumbItemDropDown.this.fParent.getDropDownElements();
                Object[] tableInputElements = contentProvider.filterInput(FSBreadcrumbItemDropDown.this.fDropdownElements, false, searchText);
                FSBreadcrumbItemDropDown.runOnGUIThread(() -> FSBreadcrumbItemDropDown.this.refreshTable(tableInputElements));
                ObjectionManager.getInstance().clear(Objection.BREADCRUMB_DROPDOWN);
                return Status.OK_STATUS;
            }
        };
        this.fDropdownJob.setSystem(true);
        this.fDropdownJob.schedule();
    }

    private void showComputedElements() {
        if (this.fDropDownViewer == null || this.fParent == null) {
            return;
        }
        this.fDropdownElements = this.fParent.getDropDownElements();
        if (this.fDropdownElements == null) {
            return;
        }
        IContentProvider provider = this.fDropDownViewer.getContentProvider();
        if (!(provider instanceof FSBCLazyDropdownContentProvider)) {
            return;
        }
        FSBCLazyDropdownContentProvider lazyProvider = (FSBCLazyDropdownContentProvider)provider;
        lazyProvider.setPrefix("");
        Object[] tableInputElements = lazyProvider.filterInput(this.fDropdownElements, false, "");
        this.refreshTable(tableInputElements);
    }

    public void setDummyInput(FSBCResourceWrapper dummyWrapper) {
        this.refreshTable(new Object[]{dummyWrapper});
    }

    private void refreshTable(Object[] elements) {
        if (this.fDropDownViewer == null || elements == null || this.fShell.isDisposed()) {
            return;
        }
        this.fDropDownViewer.setInput((Object)elements);
        ((TableViewer)this.fDropDownViewer).setItemCount(elements.length);
        Table table = ((TableViewer)this.fDropDownViewer).getTable();
        if (table == null) {
            return;
        }
        table.update();
        this.fDropDownViewer.refresh();
        if (table.getItemCount() == 0) {
            return;
        }
        TableItem item = table.getItem(0);
        table.setSelection(item);
    }

    @Override
    public Composite getDropDownViewerComposite() {
        if (!(this.fDropDownViewer instanceof TableViewer)) {
            return null;
        }
        return ((TableViewer)this.fDropDownViewer).getTable();
    }

    @Override
    public void setDropDownViewerData(Composite dropDownViewer) {
        super.setDropDownViewerData(dropDownViewer);
        this.setShellBounds(this.fShell);
    }

    @Override
    public void setShellBounds(Shell shell) {
        Rectangle rect = this.fParentComposite.getBounds();
        Rectangle toolbarBounds = this.arrowLabel.getBounds();
        shell.pack();
        Point size = shell.getSize();
        int height = Math.max(Math.min(size.y, this.getMaxHeight()), 200);
        int width = Math.max(Math.min(size.x, 500), 250);
        Rectangle trim = this.fShell.computeTrim(0, 0, width, height);
        int x = toolbarBounds.x + toolbarBounds.width + trim.x;
        if (!this.isLTR()) {
            x += width;
        }
        Point pt = new Point(x, rect.y - height);
        pt = this.fParentComposite.toDisplay(pt);
        Rectangle monitor = FSBreadcrumbItemDropDown.getClosestMonitor(shell.getDisplay(), pt).getClientArea();
        int overlap = pt.x + width - (monitor.x + monitor.width);
        if (overlap > 0) {
            pt.x -= overlap;
        }
        if (pt.x < monitor.x) {
            pt.x = monitor.x;
        }
        shell.setLocation(pt);
        shell.setSize(width, height);
    }

    @Override
    public void openElement(Object data) {
        if (data == null) {
            return;
        }
        this.fParent.getViewer().fireMenuSelection(data);
    }

    @Override
    public void showMenu() {
        if (this.fParent == null) {
            return;
        }
        final FSBreadcrumbViewer viewer = (FSBreadcrumbViewer)this.fParent.getViewer();
        if (viewer == null) {
            return;
        }
        FSBCResourceWrapper segment = (FSBCResourceWrapper)viewer.getItem(viewer.getItemCount() - 1).getData();
        final Object data = this.fParent.getData();
        if (segment.isDirectory() && !viewer.isIntermediateState) {
            viewer.isIntermediateState = true;
            viewer.dropdownItemIndex = viewer.getIndexOfItem(this.fParent);
            FSBreadcrumbConfiguration config = new FSBreadcrumbConfiguration((FSBCResourceWrapper)data);
            viewer.updateNonGUIPart(FSBreadcrumbViewer.class, config, true);
            ObjectionManager.getInstance().clear(Objection.BREADCRUMB_DROPDOWN);
            return;
        }
        this.internalShowMenu();
        this.setDummyInput(FSBreadcrumbUtils.createDummyItem("Updating..."));
        if (this.fDropdownJob != null) {
            this.fDropdownJob.cancel();
        }
        this.fDropdownJob = new Job("Computing dropdown elements for " + this.fParent.getText()){

            protected IStatus run(IProgressMonitor monitor) {
                viewer.computeDropdownElements(data);
                FSBreadcrumbItemDropDown.runOnGUIThread(() -> {
                    FSBreadcrumbItemDropDown.this.showComputedElements();
                    FSBreadcrumbItemDropDown.this.setFocus();
                    ObjectionManager.getInstance().clear(Objection.BREADCRUMB_DROPDOWN);
                });
                return Status.OK_STATUS;
            }
        };
        this.fDropdownJob.setSystem(true);
        this.fDropdownJob.schedule();
    }

    @Override
    protected void internalShowMenu() {
        Composite menuComposite = this.createMenuComposite();
        if (menuComposite == null) {
            return;
        }
        this.fShell.addShellListener(new ShellListener(){

            public void shellClosed(ShellEvent e) {
                if (FSBreadcrumbItemDropDown.this.fParent == null || !(FSBreadcrumbItemDropDown.this.fParent.getViewer() instanceof FSBreadcrumbViewer)) {
                    return;
                }
                FSBreadcrumbViewer viewer = (FSBreadcrumbViewer)FSBreadcrumbItemDropDown.this.fParent.getViewer();
                if (viewer.isIntermediateState) {
                    return;
                }
                FSBreadcrumbConfiguration config = new FSBreadcrumbConfiguration(null);
                viewer.updateNonGUIPart(FSBreadcrumbViewer.class, config, true);
            }

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.fDropDownViewer = new BCDropDownTableViewer(this, menuComposite, 268436228);
        this.fDropDownViewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fDropDownViewer, (int)2);
        this.fDropdownElements = this.fParent.getDropDownElements();
        Table table = (Table)this.fDropDownViewer.getControl();
        this.setDropDownViewerData((Composite)table);
        this.addListenersAndFilter((Composite)table);
        this.addTableListeners(table);
        int index = this.fParent.getViewer().getIndexOfItem(this.fParent);
        this.fParent.getViewer().selectItem(this.fParent, true);
        if (index < this.fParent.getViewer().getItemCount() - 1) {
            table.setSelection(0);
            table.setTopIndex(0);
        }
        this.fShell.setVisible(true);
        this.installCloser(this.fShell);
    }

    public void setTooltip(String text) {
        if (this.arrowLabel == null) {
            return;
        }
        this.arrowLabel.setToolTipText(text);
    }

    private static void runOnGUIThread(Runnable r) {
        Display display = Display.getDefault();
        if (TestHelper.isTestMode()) {
            display.syncExec(r);
        } else {
            display.asyncExec(r);
        }
    }

    @Override
    protected void clearObjection() {
        ObjectionManager.getInstance().clear(Objection.FILESYSTEM_BC);
    }
}

