/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.fsbreadcrumb;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerRepo;
import ro.amiq.dvt.ui.editor.breadcrumb.DummyBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SlimBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCResourceWrapper;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbConfiguration;

public class FSBreadcrumbUtils
extends SlimBreadcrumbUtils {
    private static FSBreadcrumbUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    public static final int DROPDOWN_ELEMENT_THRESHOLD = 100;
    public static final String SEARCH = "Searching...";
    public static final String UPDATE = "Updating...";
    public static final String SHOW_ALL = "Showing 100. Search or click for more";

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new FSBreadcrumbUtils();
            }
        }
        return INSTANCE;
    }

    @Override
    public BreadcrumbInput computeBreadcrumbInput(IDVTBreadcrumbHost editor, AbstractBreadcrumbConfiguration configuration, boolean enabled) {
        URI filePath;
        block13: {
            FSBreadcrumbConfiguration fsConfig;
            DVTEditor dvtEditor;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            if (editor instanceof DVTEditor) break block9;
                            return null;
                        }
                        if (DVTPlugin.getDefault().collect().c(editor.getProject(), "F636F7265")) break block10;
                        return null;
                    }
                    if (configuration instanceof FSBreadcrumbConfiguration) break block11;
                    return null;
                }
                dvtEditor = (DVTEditor)editor;
                fsConfig = (FSBreadcrumbConfiguration)configuration;
                IFile currentFile = dvtEditor.getCurrentFile();
                if (currentFile == null || currentFile.isSynchronized(0)) break block12;
                return null;
            }
            filePath = this.getFileURI(fsConfig.getElement(), dvtEditor);
            if (filePath != null) break block13;
            return null;
        }
        try {
            ArrayList<BreadcrumbSegment> segments = new ArrayList<BreadcrumbSegment>();
            File currentRawFile = new File(filePath);
            while (currentRawFile != null) {
                FSBCResourceWrapper element = new FSBCResourceWrapper(currentRawFile, editor.getProject());
                segments.add(0, new BreadcrumbSegment(element));
                currentRawFile = currentRawFile.getParentFile();
            }
            int i = 1;
            while (i < segments.size()) {
                FSBCResourceWrapper element = (FSBCResourceWrapper)((BreadcrumbSegment)segments.get(i)).getElement();
                element.setParent((FSBCResourceWrapper)((BreadcrumbSegment)segments.get(i - 1)).getElement());
                ++i;
            }
            return new BreadcrumbInput(editor.getProject(), segments, this.getBreadcrumbSerializer());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private URI getFileURI(FSBCResourceWrapper oldWrapper, DVTEditor dvtEditor) {
        if (oldWrapper != null) {
            return oldWrapper.getURI();
        }
        IFile currentFile = dvtEditor.getCurrentFile();
        if (currentFile != null) {
            URI rawLocationURI = currentFile.getRawLocationURI();
            if (rawLocationURI.isAbsolute()) {
                return rawLocationURI;
            }
            return currentFile.getLocationURI();
        }
        IEditorInput input = dvtEditor.getEditorInput();
        if (input instanceof FileStoreEditorInput) {
            return ((FileStoreEditorInput)input).getURI();
        }
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getURI();
        }
        return null;
    }

    @Override
    public String getBCType() {
        return BreadcrumbMode.FILESYSTEM.getName();
    }

    @Override
    public boolean validateScopeForBreadcrumb(IRfBreadcrumbElement elem) {
        return false;
    }

    @Override
    public IBreadcrumbSerializer getBreadcrumbSerializer() {
        return BreadcrumbSerializerRepo.getSerializer(LanguageKind.UNKNOWN, DummyBreadcrumbSerializer.class);
    }

    public List<Object> getChildren(FSBCResourceWrapper inputElement, boolean computeAllDDChildren) {
        if (inputElement == null) {
            return null;
        }
        if (!inputElement.isDirectory()) {
            return null;
        }
        return inputElement.getChildrenFiles(computeAllDDChildren ? Integer.MAX_VALUE : 101);
    }

    public static FSBCResourceWrapper createDummyItem(final String text) {
        return new FSBCResourceWrapper(null, null){

            @Override
            public String getName() {
                return text;
            }

            @Override
            public boolean isDummy() {
                return true;
            }
        };
    }
}

