/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.fsbreadcrumb;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.TerminalHandler;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbStateHandler;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SlimBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCDropdownLabelProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCInputContentProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCInputLabelProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCLazyDropdownContentProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCResourceWrapper;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBCToolTipProvider;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbItem;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.utils.Utils;

public class FSBreadcrumbViewer
extends SlimBreadcrumbViewer {
    private static final String COPY_FULL_PATH = "Copy Full Path";
    private static final String OPEN_TERMINAL = "Open Terminal";
    int dropdownItemIndex = -1;
    boolean isIntermediateState;
    boolean computeAllDDChildren;
    boolean exceedsDropdownThreshold;

    public FSBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        super(editor, topContainer);
    }

    @Override
    public void createListeners() {
        super.createListeners();
        this.fContextMenuListener = e -> {
            ISelection selection = this.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object bcElement = ((IStructuredSelection)selection).getFirstElement();
            if (!(bcElement instanceof FSBCResourceWrapper)) {
                return;
            }
            Menu contextMenu = new Menu((Control)this.getContainer());
            this.addCopyFullPath((FSBCResourceWrapper)bcElement, contextMenu);
            this.addOpenTerminal((FSBCResourceWrapper)bcElement, contextMenu);
            contextMenu.setLocation(e.x, e.y);
            contextMenu.setVisible(true);
        };
        this.fOpenFromDropDownListener = new IOpenListener(){

            public void open(OpenEvent event) {
                Object eventSource = event.getSource();
                if (!(eventSource instanceof FSBreadcrumbViewer)) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                FSBreadcrumbViewer breadcrumbViewer = (FSBreadcrumbViewer)((Object)eventSource);
                IDVTBreadcrumbHost editor = breadcrumbViewer.getEditor();
                if (editor == null) {
                    return;
                }
                Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                if (!(selectedElement instanceof FSBCResourceWrapper)) {
                    return;
                }
                if (FSBreadcrumbViewer.this.fSelectedItem == null) {
                    return;
                }
                FSBCResourceWrapper selectedWrapper = (FSBCResourceWrapper)selectedElement;
                if (this.isShowAllItem(selectedWrapper)) {
                    ((FSBreadcrumbItem)FSBreadcrumbViewer.this.fSelectedItem).showAllDropdownChildren();
                    return;
                }
                if (selectedWrapper.isDummy()) {
                    return;
                }
                FSBreadcrumbViewer.this.computeAllDDChildren = false;
                if (selectedWrapper.isFiltered()) {
                    return;
                }
                if (!selectedWrapper.isDirectory()) {
                    FSBreadcrumbViewer.this.isIntermediateState = false;
                    selectedWrapper.openEditor();
                    return;
                }
                FSBreadcrumbViewer.this.isIntermediateState = true;
                FSBreadcrumbViewer.this.dropdownItemIndex = FSBreadcrumbViewer.this.getIndexOfItem(FSBreadcrumbViewer.this.fSelectedItem) + 1;
                FSBreadcrumbViewer.this.fSelectedItem.closeDropDownMenu();
                FSBreadcrumbConfiguration config = new FSBreadcrumbConfiguration(selectedWrapper);
                FSBreadcrumbViewer.this.updateNonGUIPart(FSBreadcrumbViewer.class, config, true);
            }

            private boolean isShowAllItem(FSBCResourceWrapper selectedWrapper) {
                return selectedWrapper.isDummy() && "Showing 100. Search or click for more".equals(selectedWrapper.getName());
            }
        };
    }

    public void disposeDropDownModel() {
        if (this.fDropdownElements == null) {
            return;
        }
        this.fDropdownElements.clear();
        this.fDropdownElements = null;
    }

    @Override
    public void updateGuiPart(boolean enabled, BreadcrumbInput bcInput) {
        super.updateGuiPart(enabled, bcInput);
        if (this.forceUpdate) {
            this.refresh();
        }
    }

    public void refresh() {
        if (!BreadcrumbStateHandler.isBreadcrumbEnabled() || !BreadcrumbMode.FILESYSTEM.isEnabled()) {
            this.hideBreadcrumb();
            return;
        }
        if (this.isDisposed()) {
            super.updateGuiPart(true, this.fBreadcrumbInput);
            return;
        }
        super.refresh();
        List<AbstractBreadcrumbItem> breadcrumbItems = this.getItems();
        if (breadcrumbItems == null) {
            return;
        }
        if (this.isIntermediateState && this.dropdownItemIndex >= 0 && this.dropdownItemIndex < breadcrumbItems.size()) {
            this.getItem(this.dropdownItemIndex).openDropDownMenu();
            this.isIntermediateState = false;
            this.dropdownItemIndex = -1;
        }
    }

    private void addCopyFullPath(final FSBCResourceWrapper bcElement, Menu contextMenu) {
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(COPY_FULL_PATH);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (bcElement == null) {
                    return;
                }
                String fullPath = bcElement.getFullPath();
                if (fullPath == null) {
                    return;
                }
                Utils.copyToClipboard(fullPath.trim(), 3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void addOpenTerminal(final FSBCResourceWrapper bcElement, Menu contextMenu) {
        if (!TerminalHandler.hasHandler()) {
            return;
        }
        if (!bcElement.isDirectory()) {
            return;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(OPEN_TERMINAL);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IPath path = bcElement.getPath();
                    if (path == null) {
                        return;
                    }
                    TerminalHandler.openTerminal(path);
                }
                catch (Exception ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void createBreadcrumbDropDownProviders() {
        this.fDropDownLabelProvider = new FSBCDropdownLabelProvider();
    }

    @Override
    public void createBreadcrumbInputProviders() {
        try {
            this.fInputContentProvider = new FSBCInputContentProvider();
            this.fInputTooltipProvider = new FSBCToolTipProvider();
            this.fInputLabelProvider = new FSBCInputLabelProvider();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void filterItem(AbstractBreadcrumbItem item, Object element) {
        if (item == null || !(element instanceof FSBCResourceWrapper)) {
            return;
        }
        item.setGrayedOut(((FSBCResourceWrapper)element).isFiltered());
    }

    @Override
    protected int getWidthOfExtraWidgets() {
        return 0;
    }

    @Override
    protected AbstractBreadcrumbItem createItem() {
        return new FSBreadcrumbItem(this, this.getContainer());
    }

    @Override
    public void configureDropDownViewer(ColumnViewer viewer, Object input) {
        if (!(viewer instanceof TableViewer) || !(input instanceof IRfBreadcrumbElement)) {
            return;
        }
        ((TableViewer)viewer).getTable().addMenuDetectListener(e -> {
            ISelection selection = viewer.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object bcElement = ((IStructuredSelection)selection).getFirstElement();
            if (!(bcElement instanceof FSBCResourceWrapper)) {
                return;
            }
            if (this.fActiveEditor == null) {
                return;
            }
            Menu contextMenu = new Menu((Control)this.getContainer());
            this.addCopyFullPath((FSBCResourceWrapper)bcElement, contextMenu);
            this.addOpenTerminal((FSBCResourceWrapper)bcElement, contextMenu);
            contextMenu.setLocation(e.x, e.y);
            contextMenu.setVisible(true);
        });
        this.fDropDownContentProvider = new FSBCLazyDropdownContentProvider((TableViewer)viewer, this);
        viewer.setContentProvider(this.fDropDownContentProvider);
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)this.fDropDownLabelProvider);
    }

    @Override
    public void computeDropdownElements(Object input) {
        if (!(input instanceof FSBCResourceWrapper)) {
            return;
        }
        if (this.fActiveEditor == null) {
            return;
        }
        List<Object> children = FSBreadcrumbUtils.getInstance().getChildren((FSBCResourceWrapper)input, this.computeAllDDChildren);
        if (children == null) {
            return;
        }
        this.fDropdownElements = children;
        this.exceedsDropdownThreshold = children.size() == 100;
    }

    public IOpenListener testGetClickFromDropDownListener() {
        return this.fOpenFromDropDownListener;
    }
}

