/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.highlight;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtilsCommon;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;

public class DVTHlUtils
extends DVTHlUtilsCommon {
    public static final int SEMANTIC_HIGHLIGHT_INVALIDATE_VISIBLE_LINE_LIMIT = 15000;
    public static final ISchedulingRule JOB_SCHED_RULE = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public static void startHighlight(IRfFileDef file, DVTEditor editor, DVTSemanticHighlighter semanticHighlighter, AbstractUIPlugin plugin, String semanticHighlightID) {
        if (editor == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            return;
        }
        IDocument document = editor.getDocument();
        if (document == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            return;
        }
        if (!editor.isVisible()) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            return;
        }
        IPreferenceStore store = plugin.getPreferenceStore();
        boolean isSemanticHighlightEnabled = semanticHighlightID != null ? store.getBoolean(String.valueOf(semanticHighlightID) + ".value") : false;
        editor.startHighlightJob(semanticHighlighter, file, isSemanticHighlightEnabled);
    }

    protected static SemanticHighlightPosition computeSemanticHighlightPosition(IDocument document, int offset, HighlightKind highlightKind) {
        return new SemanticHighlightPosition(offset, highlightKind);
    }

    public static void invalidateVisibleTextPresentation(ITextViewer textViewer, int startOffset, int length) {
        DVTHlUtils.invalidateVisibleTextPresentation(textViewer, startOffset, length, false);
    }

    public static void invalidateVisibleTextPresentation(ITextViewer textViewer, int startOffset, int length, boolean clearObjection) {
        if (textViewer == null) {
            return;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return;
        }
        if (textViewer instanceof TextViewer && !TestHelper.isTestMode()) {
            ((TextViewer)textViewer).invalidateTextPresentation(startOffset, length);
        } else {
            textViewer.invalidateTextPresentation();
        }
        if (clearObjection) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
        }
    }
}

