/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.highlight;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.DVTSynchronizableDocument;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;

public abstract class DVTHlUtilsCommon {
    protected static ListenerList fHighlightListeners = new ListenerList();

    public static void notifyListeners(IDocument document, IRfFileDef file) {
        Object[] listeners = fHighlightListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IHighlightListener)listeners[i]).updateSHPositions(document, file);
            ++i;
        }
    }

    public static void removeListener(IHighlightListener listener) {
        fHighlightListeners.remove((Object)listener);
    }

    public static void addListener(IHighlightListener listener) {
        fHighlightListeners.add((Object)listener);
    }

    public static void addPosition(IDocument document, int offset, HighlightKind highlightKind, Map<Integer, Position> positions) {
        if (document == null) {
            return;
        }
        if (highlightKind == null || offset < 0 || offset >= document.getLength() || positions == null) {
            return;
        }
        Position currentPosition = positions.get(offset);
        if (currentPosition == null || currentPosition instanceof SemanticHighlightPosition && ((SemanticHighlightPosition)currentPosition).getHighlightKind() == HighlightKind.DEFAULT) {
            SemanticHighlightPosition semanticHighlightPosition = DVTHlUtils.computeSemanticHighlightPosition(document, offset, highlightKind);
            if (semanticHighlightPosition == null) {
                return;
            }
            positions.put(offset, semanticHighlightPosition);
        }
    }

    public static void notifyKeywordsListeners() {
        Object[] listeners = fHighlightListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IHighlightListener)listeners[i]).updateKeywords();
            ++i;
        }
    }

    public static void addPositionsToDocument(IDocument document, Collection<Position> positions) throws Exception {
        if (document == null || positions.isEmpty()) {
            return;
        }
        if (document instanceof DVTSynchronizableDocument) {
            ((DVTSynchronizableDocument)document).addPositions("SEMANTIC_HIGHLIGHT", positions);
        } else {
            for (Position position : positions) {
                document.addPosition("SEMANTIC_HIGHLIGHT", position);
            }
        }
    }
}

