/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.highlight;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightJob;

public abstract class DVTSemanticHighlighter<T extends IRfBaseElement> {
    private IDocument fDocument;
    private Map<Integer, Position> fPositions;
    private int fStartOffset;
    private int fEndOffset;

    public DVTSemanticHighlighter(IDocument document) {
        this.fDocument = document;
        this.fPositions = new HashMap<Integer, Position>();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public Map<Integer, Position> getPositions() {
        return this.fPositions;
    }

    protected IStatus doHighlightRecursive(T root, Set<T> visited, SemanticHighlightJob job) throws BadLocationException, BadPositionCategoryException, Exception {
        if (job.isCanceled()) {
            throw new Exception("Semantic Highlight canceled");
        }
        this.doHighlight(root);
        visited.add(root);
        Collection<T> children = this.getChildren(root);
        if (children == null) {
            return Status.OK_STATUS;
        }
        for (IRfBaseElement child : children) {
            if (visited.contains(child)) continue;
            this.doHighlightRecursive(child, visited, job);
        }
        return Status.OK_STATUS;
    }

    public void process(IRfFileDef file, SemanticHighlightJob job, int startOffset, int endOffset) {
        if (this.fDocument == null) {
            return;
        }
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        if (!this.fDocument.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
            this.fDocument.addPositionCategory("SEMANTIC_HIGHLIGHT");
        } else {
            try {
                this.fDocument.removePositionCategory("SEMANTIC_HIGHLIGHT");
                this.fDocument.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            catch (BadPositionCategoryException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
        }
        try {
            this.doHighlightRecursive((IRfBaseElement)((Object)file), new HashSet(), job);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            String fileName = file != null && file.getParserPath() != null ? file.getParserPath().path : "Could not determine the file path.";
            if ("Semantic Highlight canceled".equals(e.getMessage())) {
                DVTLogger.INSTANCE.logError("Semantic Highlight canceled for file:\n" + fileName);
            }
            DVTLogger.INSTANCE.logError("Exception during Semantic Highlight in file:\n" + fileName, (Throwable)e);
        }
    }

    public void clean() {
        this.fDocument = null;
        this.fPositions = null;
    }

    protected abstract Collection<T> getChildren(T var1);

    protected abstract void doHighlight(T var1) throws BadLocationException, BadPositionCategoryException;

    public int getStartOffset() {
        return this.fStartOffset;
    }

    public int getEndOffset() {
        return this.fEndOffset;
    }
}

