/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.highlight;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;

public class SemanticHighlightJob
extends Job {
    private IRfFileDef file;
    private DVTSemanticHighlighter<IRfBaseElement> semanticHighlighter;
    private DVTEditor editor;
    private boolean cancel;
    private boolean isSemanticHighlightEnabled;

    public SemanticHighlightJob(DVTSemanticHighlighter<IRfBaseElement> semanticHighlighter, IRfFileDef file, DVTEditor editor, boolean isSemanticHighlightEnabled) {
        super("Semantic Highlight for '" + editor.getTitleToolTip() + "'");
        this.semanticHighlighter = semanticHighlighter;
        this.editor = editor;
        this.file = file;
        this.isSemanticHighlightEnabled = isSemanticHighlightEnabled;
    }

    protected void canceling() {
        this.cancel = true;
        this.semanticHighlighter.clean();
        this.semanticHighlighter = null;
        this.editor = null;
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            int endOffset;
            int startOffset;
            TestHelper.fStartSemanticHighlight = System.currentTimeMillis();
            if (this.semanticHighlighter == null) {
                return Status.OK_STATUS;
            }
            IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return Status.OK_STATUS;
            }
            Shell shell = activeWorkbenchWindow.getShell();
            if (shell == null) {
                return Status.OK_STATUS;
            }
            Display display = shell.getDisplay();
            if (display == null) {
                return Status.OK_STATUS;
            }
            if (this.editor == null) {
                return Status.OK_STATUS;
            }
            ITextViewer textViewer = this.editor.getTextViewer();
            if (textViewer == null) {
                return Status.OK_STATUS;
            }
            if (TestHelper.isTestMode()) {
                startOffset = 0;
                endOffset = this.editor.getDocument().getLength();
            } else {
                Region limits = Utils.getEditorVisibleLimits(textViewer);
                if (limits == null) {
                    return Status.OK_STATUS;
                }
                startOffset = limits.getOffset();
                endOffset = startOffset + limits.getLength();
            }
            if (this.isSemanticHighlightEnabled) {
                this.semanticHighlighter.process(this.file, this, startOffset, endOffset);
            }
            if (this.semanticHighlighter == null) {
                return Status.OK_STATUS;
            }
            Map<Integer, Position> highlightPositions = this.semanticHighlighter.getPositions();
            if (highlightPositions == null) {
                return Status.OK_STATUS;
            }
            try {
                DVTHlUtils.addPositionsToDocument(this.editor.getDocument(), highlightPositions.values());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            display.asyncExec(() -> {
                try {
                    if (this.editor == null) {
                        return;
                    }
                    DVTHlUtils.notifyListeners(this.editor.getDocument(), this.file);
                    DVTHlUtils.invalidateVisibleTextPresentation(this.editor.getTextViewer(), startOffset, endOffset - startOffset, true);
                    TestHelper.fStopSemanticHighlight = System.currentTimeMillis();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.OK_STATUS;
        }
    }
}

