/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class DVTDefaultAnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int annotationLine;
            block5: {
                try {
                    annotationLine = document.getLineOfOffset(position.getOffset());
                    if (line != annotationLine) break block5;
                    return 1;
                }
                catch (Exception exception) {}
            }
            if (annotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        ArrayList<Annotation> including = new ArrayList<Annotation>();
        Iterator e = model.getAnnotationIterator();
        HashMap messagesAtPosition = new HashMap();
        while (e.hasNext()) {
            Annotation a;
            Position position;
            Object o = e.next();
            if (!(o instanceof Annotation) || (position = model.getPosition(a = (Annotation)o)) == null || this.isDuplicateAnnotation(messagesAtPosition, position, a.getText())) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(a);
                    break;
                }
                case 2: {
                    including.add(a);
                }
            }
        }
        return this.select(exact, including);
    }

    private boolean isDuplicateAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message == null || value == null) {
                return false;
            }
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List annotations = this.getAnnotationsForLine(sourceViewer, lineNumber);
        if (annotations != null) {
            if (annotations.size() == 1) {
                Annotation annotation = (Annotation)annotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (Annotation annotation : annotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        if (message.trim().isEmpty()) {
            return "";
        }
        return "<pre class=\"marker\">" + message.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>") + "</pre>";
    }

    private String formatMultipleMessages(List messages) {
        StringBuilder buffer = new StringBuilder();
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            buffer.append("- ");
            buffer.append((String)e.next());
            if (!e.hasNext()) continue;
            buffer.append('\n');
        }
        String result = buffer.toString();
        if (result.trim().isEmpty()) {
            return "";
        }
        return "<pre class=\"marker\">" + result.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>") + "</pre>";
    }
}

