/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hover;

import java.util.EnumMap;
import java.util.Map;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;

public class DVTTooltipContent {
    public static final int COMPUTATION_TIMEOUT_MS = 200;
    private Map<TooltipContent, Object> fData = new EnumMap<TooltipContent, Object>(TooltipContent.class);
    private boolean isComputing;
    private static final String COMPUTING_MESSAGE = "Computing tooltip content...";

    public void set(TooltipContent type, String value) {
        this.internalAdd(type, value, false);
    }

    public void set(TooltipContent type, Integer value) {
        this.internalAdd(type, value, false);
    }

    public void append(TooltipContent type, String value, boolean append) {
        this.internalAdd(type, value, append);
    }

    public void set(TooltipContent type, BitFieldModel value) {
        this.internalAdd(type, value, false);
    }

    public boolean isEmpty() {
        return this.getComment().isEmpty() && this.getSignature().isEmpty() && this.getDebugInfo().isEmpty() && this.getShallow().isEmpty() && this.getUPFSignature().isEmpty() && this.getWaveDromDiagram().isEmpty() && this.getLinterPragma().isEmpty();
    }

    public void setComputingStatus(boolean status) {
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return;
        }
        this.isComputing = status;
        if (status) {
            this.set(TooltipContent.COMMENT, COMPUTING_MESSAGE);
        } else if (COMPUTING_MESSAGE.equals(this.getComment())) {
            this.set(TooltipContent.COMMENT, "");
        }
    }

    public boolean isComputing() {
        return this.isComputing;
    }

    public boolean has(TooltipContent type) {
        switch (type) {
            case SIGNATURE: {
                return this.hasSignature();
            }
            case COMMENT: {
                return this.hasComment();
            }
            case SHALLOW: {
                return this.hasShallow();
            }
            case UPF_SIGNATURE: {
                return this.hasUPFSignature();
            }
            case WAVEDROM_DIAGRAM: {
                return this.hasWaveDromDiagram();
            }
            case DEBUG_INFO: {
                return this.hasDebugInfo();
            }
            case BITFIELD_DIAGRAM: {
                return this.hasBitfieldDiagram();
            }
            case BITFIELD_REGISTER: {
                return this.hasBitfieldRegisterModel();
            }
            case LINE: {
                return this.hasLine();
            }
            case COLUMN: {
                return this.hasColumn();
            }
            case FILE: {
                return this.hasFile();
            }
            case PREFERENCE: {
                return this.hasPreference();
            }
            case WAVE_VALUE: {
                return this.hasWaveValue();
            }
            case LINTER_PRAGMA: {
                return this.hasLinterPragma();
            }
        }
        return false;
    }

    private boolean hasBitfieldDiagram() {
        return this.fData.containsKey((Object)TooltipContent.BITFIELD_DIAGRAM);
    }

    private boolean hasPreference() {
        return this.fData.containsKey((Object)TooltipContent.PREFERENCE);
    }

    private boolean hasFile() {
        return this.fData.containsKey((Object)TooltipContent.FILE);
    }

    private boolean hasSignature() {
        return this.fData.containsKey((Object)TooltipContent.SIGNATURE);
    }

    private boolean hasComment() {
        return this.fData.containsKey((Object)TooltipContent.COMMENT);
    }

    private boolean hasShallow() {
        return this.fData.containsKey((Object)TooltipContent.SHALLOW);
    }

    private boolean hasUPFSignature() {
        return this.fData.containsKey((Object)TooltipContent.UPF_SIGNATURE);
    }

    private boolean hasWaveValue() {
        return this.fData.containsKey((Object)TooltipContent.WAVE_VALUE);
    }

    private boolean hasDebugInfo() {
        return this.fData.containsKey((Object)TooltipContent.DEBUG_INFO);
    }

    private boolean hasBitfieldRegisterModel() {
        return this.fData.containsKey((Object)TooltipContent.BITFIELD_REGISTER);
    }

    private boolean hasWaveDromDiagram() {
        Object waveDromDiagram = this.fData.get((Object)TooltipContent.WAVEDROM_DIAGRAM);
        return waveDromDiagram instanceof String && !((String)waveDromDiagram).isEmpty();
    }

    private boolean hasLine() {
        return this.fData.containsKey((Object)TooltipContent.LINE);
    }

    private boolean hasColumn() {
        return this.fData.containsKey((Object)TooltipContent.COLUMN);
    }

    private boolean hasLinterPragma() {
        return this.fData.containsKey((Object)TooltipContent.LINTER_PRAGMA);
    }

    public String getSignature() {
        return this.fData.containsKey((Object)TooltipContent.SIGNATURE) ? (String)this.fData.get((Object)TooltipContent.SIGNATURE) : "";
    }

    public String getComment() {
        return this.fData.containsKey((Object)TooltipContent.COMMENT) ? (String)this.fData.get((Object)TooltipContent.COMMENT) : "";
    }

    public String getShallow() {
        return this.fData.containsKey((Object)TooltipContent.SHALLOW) ? (String)this.fData.get((Object)TooltipContent.SHALLOW) : "";
    }

    public String getUPFSignature() {
        return this.fData.containsKey((Object)TooltipContent.UPF_SIGNATURE) ? (String)this.fData.get((Object)TooltipContent.UPF_SIGNATURE) : "";
    }

    public String getWaveDromDiagram() {
        return this.fData.containsKey((Object)TooltipContent.WAVEDROM_DIAGRAM) ? (String)this.fData.get((Object)TooltipContent.WAVEDROM_DIAGRAM) : "";
    }

    public String getWaveValue() {
        return this.fData.containsKey((Object)TooltipContent.WAVE_VALUE) ? (String)this.fData.get((Object)TooltipContent.WAVE_VALUE) : "";
    }

    public String getBitFieldDiagram() {
        return this.fData.containsKey((Object)TooltipContent.BITFIELD_DIAGRAM) ? (String)this.fData.get((Object)TooltipContent.BITFIELD_DIAGRAM) : "";
    }

    public BitFieldModel getRegisterModel() {
        return this.fData.containsKey((Object)TooltipContent.BITFIELD_REGISTER) ? (BitFieldModel)this.fData.get((Object)TooltipContent.BITFIELD_REGISTER) : null;
    }

    public String getDebugInfo() {
        return this.fData.containsKey((Object)TooltipContent.DEBUG_INFO) ? (String)this.fData.get((Object)TooltipContent.DEBUG_INFO) : "";
    }

    public int getLine() {
        return this.fData.containsKey((Object)TooltipContent.LINE) ? (Integer)this.fData.get((Object)TooltipContent.LINE) : -1;
    }

    public int getColumn() {
        return this.fData.containsKey((Object)TooltipContent.COLUMN) ? (Integer)this.fData.get((Object)TooltipContent.COLUMN) : -1;
    }

    public String getFile() {
        return this.fData.containsKey((Object)TooltipContent.FILE) ? (String)this.fData.get((Object)TooltipContent.FILE) : "";
    }

    public String getPreference() {
        return this.fData.containsKey((Object)TooltipContent.PREFERENCE) ? (String)this.fData.get((Object)TooltipContent.PREFERENCE) : "";
    }

    public String getLinterPragma() {
        return this.fData.containsKey((Object)TooltipContent.LINTER_PRAGMA) ? (String)this.fData.get((Object)TooltipContent.LINTER_PRAGMA) : "";
    }

    public String getAllStrings() {
        return String.valueOf(this.getSignature()) + this.getComment() + this.getShallow() + this.getUPFSignature() + this.getDebugInfo() + this.getWaveValue();
    }

    private void internalAdd(TooltipContent type, Object value, boolean append) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String || value instanceof BitFieldModel || value instanceof Integer)) {
            DVTLogger.INSTANCE.logError((Throwable)new Exception("Unexpected tooltip content: " + value.getClass().getCanonicalName()));
            return;
        }
        switch (type) {
            case SIGNATURE: {
                String signature = (String)this.fData.get((Object)TooltipContent.SIGNATURE);
                if (signature != null && append) {
                    this.fData.put(TooltipContent.SIGNATURE, String.valueOf(signature) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.SIGNATURE, value);
                break;
            }
            case COMMENT: {
                String comment = (String)this.fData.get((Object)TooltipContent.COMMENT);
                if (comment != null && append) {
                    this.fData.put(TooltipContent.COMMENT, String.valueOf(comment) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.COMMENT, value);
                break;
            }
            case SHALLOW: {
                String shallow = (String)this.fData.get((Object)TooltipContent.SHALLOW);
                if (shallow != null && append) {
                    this.fData.put(TooltipContent.SHALLOW, String.valueOf(shallow) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.SHALLOW, value);
                break;
            }
            case UPF_SIGNATURE: {
                String upfSignature = (String)this.fData.get((Object)TooltipContent.UPF_SIGNATURE);
                if (upfSignature != null && append) {
                    this.fData.put(TooltipContent.UPF_SIGNATURE, String.valueOf(upfSignature) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.UPF_SIGNATURE, value);
                break;
            }
            case WAVEDROM_DIAGRAM: {
                String wavedromDiagram = (String)this.fData.get((Object)TooltipContent.WAVEDROM_DIAGRAM);
                if (wavedromDiagram != null) {
                    this.fData.put(TooltipContent.WAVEDROM_DIAGRAM, String.valueOf(wavedromDiagram) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.WAVEDROM_DIAGRAM, value);
                break;
            }
            case WAVE_VALUE: {
                String waveValue = (String)this.fData.get((Object)TooltipContent.WAVE_VALUE);
                if (waveValue != null && append) {
                    this.fData.put(TooltipContent.WAVE_VALUE, String.valueOf(waveValue) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.WAVE_VALUE, value);
                break;
            }
            case BITFIELD_REGISTER: {
                String bitfieldRegister = (String)this.fData.get((Object)TooltipContent.BITFIELD_REGISTER);
                if (bitfieldRegister != null) {
                    this.fData.put(TooltipContent.BITFIELD_REGISTER, String.valueOf(bitfieldRegister) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.BITFIELD_REGISTER, value);
                break;
            }
            case BITFIELD_DIAGRAM: {
                this.fData.put(TooltipContent.BITFIELD_DIAGRAM, value);
                break;
            }
            case DEBUG_INFO: {
                String debugInfo = (String)this.fData.get((Object)TooltipContent.DEBUG_INFO);
                if (debugInfo != null && append) {
                    this.fData.put(TooltipContent.DEBUG_INFO, String.valueOf(debugInfo) + (String)value);
                    break;
                }
                this.fData.put(TooltipContent.DEBUG_INFO, value);
                break;
            }
            case LINE: {
                this.fData.put(TooltipContent.LINE, value);
                break;
            }
            case COLUMN: {
                this.fData.put(TooltipContent.COLUMN, value);
                break;
            }
            case FILE: {
                this.fData.put(TooltipContent.FILE, value);
                break;
            }
            case PREFERENCE: {
                this.fData.put(TooltipContent.PREFERENCE, value);
                break;
            }
            case LINTER_PRAGMA: {
                this.fData.put(TooltipContent.LINTER_PRAGMA, value);
                break;
            }
        }
    }

    public static enum TooltipContent {
        SIGNATURE,
        COMMENT,
        SHALLOW,
        UPF_SIGNATURE,
        WAVEDROM_DIAGRAM,
        BITFIELD_DIAGRAM,
        BITFIELD_REGISTER,
        DEBUG_INFO,
        LINE,
        COLUMN,
        FILE,
        PREFERENCE,
        WAVE_VALUE,
        LINTER_PRAGMA;

    }
}

