/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hover;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.CommentLinkResolverContributor;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.CopyTooltipToClipboardHelper;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipInformationUtils;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;

public class DVTTooltipInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private static final String TOOLTIP_HTML_TEMPLATE;
    static final int TOOLTIP_MAX_WIDTH = 940;
    static final int TOOLTIP_MAX_HEIGHT = 720;
    static final int TOOLTIP_MIN_WIDTH = 384;
    static final int TOOLTIP_MIN_HEIGHT = 216;
    private int computedContentWidth = 384;
    private int computedContentHeight = 216;
    private static final int TOOLTIP_MIN_FONT_SIZE = 4;
    private static final int TOOLTIP_BROWSER_DELAY = 200;
    public static final String HTML_CONTENT_UUID_TAG = "CONTENT_UUID_VALUE";
    private static final String HTML_TOOLTIP_TITLE_TAG = "TOOLTIP_TITLE_VALUE";
    private static final String HTML_TOOLTIP_CONTENT_TAG = "TOOLTIP_CONTENT_VALUE";
    private static final String HTML_TOOLTIP_CONTAINER_ID = "container";
    private static final String CSS_BACKGROUND_COLOR_TAG = "BACKGROUND_COLOR_VALUE";
    private static final String CSS_FOREGROUND_COLOR_TAG = "FOREGROUND_COLOR_VALUE";
    private static final String CSS_HYPERLINK_COLOR_TAG = "HYPERLINK_COLOR_VALUE";
    private static final String CSS_FONT_SIZE_TAG = "FONT_SIZE_VALUE";
    private static final String CSS_FONT_FAMILY_TAG = "FONT_FAMILY_VALUE";
    private static final String CSS_PRE_COLOR_TAG = "PRE_COLOR_VALUE";
    private static final String UNIT;
    private static final String SET_STYLE_OVERFLOW_HIDDEN = "document.body.style.overflow = \"hidden\";";
    private static final String SET_STYLE_OVERFLOW_SCROLL = "document.body.style.overflow = \"auto\";";
    private static String browserHTMLContent;
    private static AtomicBoolean browserLoadCompleted;
    private Point fgScrollBarSize;
    private static DVTTooltipInformationControl currentInstance;
    private Object fTooltipInput;
    private static String browserContentUUID;

    static {
        String tooltipHTMLSource = "";
        try {
            InputStream fileStream = JarUtils.getFileStream("/resources/tooltip/tooltip.html", DVTTooltipInformationControl.class);
            tooltipHTMLSource = DVTStringUtil.streamToString(fileStream);
            fileStream.close();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        TOOLTIP_HTML_TEMPLATE = tooltipHTMLSource;
        UNIT = Util.isMac() ? "px" : "pt";
        browserLoadCompleted = new AtomicBoolean(false);
    }

    public static DVTTooltipInformationControl getCurrentInstance() {
        return currentInstance;
    }

    private static synchronized void saveCurrentInstance(DVTTooltipInformationControl tooltipInstance) {
        currentInstance = tooltipInstance;
    }

    public DVTTooltipInformationControl(Shell parent, String statusFieldText) {
        super(parent, statusFieldText);
        DVTTooltipInformationControl.saveCurrentInstance(this);
        this.create();
    }

    public DVTTooltipInformationControl(Shell parent, ToolBarManager toolBarManager) {
        super(parent, toolBarManager);
        DVTTooltipInformationControl.saveCurrentInstance(this);
        this.create();
    }

    protected void createContent(Composite parent) {
        BrowserProvider.INSTANCE.setParent(parent);
        DVTColorUtil.INSTANCE.setBackgroundRecursive((Control)parent.getParent(), JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.backgroundColor"));
        DVTColorUtil.INSTANCE.setForegroundRecursive((Control)parent.getParent(), JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.foregroundColor"));
        Slider sliderV = new Slider(parent, 512);
        Slider sliderH = new Slider(parent, 256);
        int width = sliderV.computeSize((int)-1, (int)-1).x;
        int height = sliderH.computeSize((int)-1, (int)-1).y;
        this.fgScrollBarSize = new Point(width, height);
        sliderV.dispose();
        sliderH.dispose();
    }

    public void setInput(Object input) {
        if (!(input instanceof String) && !(input instanceof DVTTooltipContent)) {
            DVTLogger.INSTANCE.logError("DVTTooltipInformationControl: Unexpected input " + input.getClass().getCanonicalName());
            return;
        }
        this.fTooltipInput = input;
        Shell shell = this.getShell();
        Control[] children = shell.getChildren();
        if (children != null && children.length > 0 && children[0] instanceof Composite) {
            BrowserProvider.INSTANCE.setParent((Composite)children[0]);
        }
        if (!this.isResizable()) {
            BrowserProvider.INSTANCE.updateContent(input, false);
        }
        if (this.getToolBarManager() != null) {
            this.fillToolbar();
            this.getToolBarManager().update(true);
        }
    }

    protected void fillToolbar() {
        if (!TestHelper.isTestMode()) {
            return;
        }
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager == null) {
            return;
        }
        CopyTooltipToClipboardHelper action = new CopyTooltipToClipboardHelper();
        toolBarManager.add((IAction)action);
    }

    private static String getHTMLPage(Object input) {
        String title = input instanceof DVTTooltipContent ? DVTTooltipInformationUtils.getInstance().extractTitle((DVTTooltipContent)input) : "";
        String content = input instanceof DVTTooltipContent ? DVTTooltipInformationUtils.getInstance().extractContent((DVTTooltipContent)input) : (String)input;
        String temp = TOOLTIP_HTML_TEMPLATE.replace(HTML_TOOLTIP_TITLE_TAG, DVTStringUtil.replaceAll(DVTStringUtil.NEW_LINE, title, "<br>"));
        String delim = content.trim().isEmpty() || title.trim().isEmpty() || content.equals("<br>") || title.equals("<br>") ? "" : CommentUtils.getInstance().getHorizontalLine(CommentUtils.useHtml());
        temp = temp.replace(HTML_TOOLTIP_CONTENT_TAG, content.equals("<br>") ? "" : String.valueOf(delim) + content);
        temp = temp.replace(CSS_BACKGROUND_COLOR_TAG, DVTTooltipInformationControl.getHexColor(JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.backgroundColor")));
        temp = temp.replace(CSS_FOREGROUND_COLOR_TAG, DVTTooltipInformationControl.getHexColor(JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.foregroundColor")));
        temp = temp.replace(CSS_HYPERLINK_COLOR_TAG, DVTTooltipInformationControl.getHexColor(JFaceResources.getColorRegistry().get("HYPERLINK_COLOR")));
        temp = temp.replace(CSS_PRE_COLOR_TAG, DVTTooltipInformationControl.getHexColor(DVTTooltipInformationControl.alterColor(JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.backgroundColor"))));
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.dialogfont");
        if (font != null) {
            int size = Math.max(4, font.getFontData()[0].getHeight());
            String familyFont = "'" + font.getFontData()[0].getName() + "'";
            temp = temp.replace(CSS_FONT_SIZE_TAG, String.valueOf(size) + UNIT);
            temp = temp.replace(CSS_FONT_FAMILY_TAG, familyFont);
        } else {
            temp = temp.replace(CSS_FONT_SIZE_TAG, "");
            temp = temp.replace(CSS_FONT_FAMILY_TAG, "");
        }
        return temp;
    }

    private boolean isEmptyLink(String link) {
        return link == null || link.isEmpty() || link.equals("about:blank");
    }

    private void openPreferencePage(String link) {
        PreferenceDialog preferenceDialog;
        Shell parentShell = this.getShell().getParent().getShell();
        if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().equals(parentShell)) {
            parentShell.close();
        }
        if ((preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)link.substring(0, link.indexOf(63)), null, null)) != null) {
            preferenceDialog.open();
        }
    }

    private boolean isPreferenceDialogLink(String link) {
        return link.endsWith("?openPreferenceDialog");
    }

    public void handleClickOnLinkEvent(String link) {
        try {
            this.getShell().forceFocus();
            if (this.isEmptyLink(link)) {
                return;
            }
            if (this.isPreferenceDialogLink(link)) {
                this.openPreferencePage(link);
                return;
            }
            DVTTooltipContent tooltipContentFromLink = null;
            Matcher matcher = CommentConstants.TOOLTIP_LINK_PATTERN.matcher(link);
            if (matcher != null && matcher.find() && matcher.groupCount() >= 1) {
                String elementPath = matcher.group(1);
                LanguageKind kind = this.getNatureFromLink(elementPath);
                if (kind == null) {
                    DVTLogger.INSTANCE.logError("Invalid tooltip hyperlink: " + link);
                    return;
                }
                tooltipContentFromLink = CommentLinkResolverContributor.get(kind).getCommentFromLink(matcher.group(1));
                if (tooltipContentFromLink == null) {
                    DVTLogger.INSTANCE.logError("Invalid tooltip hyperlink link: " + link);
                    return;
                }
            }
            if (tooltipContentFromLink == null || tooltipContentFromLink.getSignature().equals("") && tooltipContentFromLink.getComment().equals("")) {
                if (link.startsWith("file://") && !link.contains("#")) {
                    int index = link.indexOf("file://");
                    IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)new File(link.substring(index + "file://".length())).getName(), (boolean)true, (boolean)true);
                    DVTFileUtils.getInstance().openEditor(new File(link.substring(index + "file://".length())), 0, editorDescriptor.getId());
                    return;
                }
                BrowserProvider.INSTANCE.setURL(link);
                return;
            }
            BrowserProvider.INSTANCE.updateContent(tooltipContentFromLink, true);
            Display.getDefault().asyncExec(() -> this.getShell().setSize(this.computeSizeHint()));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void handleCtrlClickOnLinkEvent(String link) {
        if (!this.isResizable()) {
            return;
        }
        this.getShell().forceFocus();
        if (this.isEmptyLink(link)) {
            return;
        }
        Matcher matcher = CommentConstants.TOOLTIP_LINK_PATTERN.matcher(link);
        if (matcher == null || !matcher.find() || matcher.groupCount() < 1) {
            return;
        }
        String elementPath = matcher.group(1);
        LanguageKind kind = this.getNatureFromLink(elementPath);
        if (kind == null) {
            return;
        }
        CommentLinkResolverContributor.get(kind).goToDeclarationOfElementFromLink(elementPath);
    }

    public LanguageKind getNatureFromLink(String link) {
        String[] segments = DVTStringUtil.split(RfElementPath.SPLIT_PATTERN, link);
        if (segments.length < 1) {
            return null;
        }
        return LanguageKind.from(segments[0]);
    }

    public boolean hasContents() {
        if (this.fTooltipInput instanceof DVTTooltipContent) {
            return !DVTTooltipInformationUtils.getInstance().extractTitle((DVTTooltipContent)this.fTooltipInput).isEmpty() || !DVTTooltipInformationUtils.getInstance().extractContent((DVTTooltipContent)this.fTooltipInput).isEmpty();
        }
        if (this.fTooltipInput instanceof String) {
            return !((String)this.fTooltipInput).isEmpty();
        }
        return false;
    }

    public Rectangle computeTrim() {
        if (this.getShell().isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle trim = super.computeTrim();
        if (this.isResizable()) {
            boolean RTL;
            boolean bl = RTL = (this.getShell().getStyle() & 0x4000000) != 0;
            if (RTL) {
                trim.x -= this.fgScrollBarSize.x;
            }
            trim.width += this.fgScrollBarSize.x;
            trim.height += this.fgScrollBarSize.y;
        }
        return trim;
    }

    public Point computeSizeHint() {
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        long timeout = System.currentTimeMillis() + 200L;
        while (!(browserLoadCompleted.get() || System.currentTimeMillis() >= timeout || shell.isDisposed() || display.isDisposed())) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!browserLoadCompleted.get()) {
            return new Point(384, 216);
        }
        return new Point(this.computedContentWidth, this.computedContentHeight);
    }

    public void setSize(int width, int height) {
        BrowserProvider.INSTANCE.setRedraw(false);
        try {
            super.setSize(width, height);
        }
        finally {
            BrowserProvider.INSTANCE.setSize(width, height);
            BrowserProvider.INSTANCE.setRedraw(true);
        }
    }

    protected void handleDispose() {
        BrowserProvider.INSTANCE.resetParent();
        super.handleDispose();
    }

    private static String getHexColor(Color color) {
        if (color == null) {
            return "#FFFFFF";
        }
        String hex = "#" + String.format("%02X", color.getRed()) + String.format("%02X", color.getGreen()) + String.format("%02X", color.getBlue());
        return hex;
    }

    private static Color alterColor(Color color) {
        boolean isLightColor;
        if (color == null) {
            return null;
        }
        boolean bl = isLightColor = DVTTooltipInformationControl.calculateHSP(color.getRed(), color.getGreen(), color.getBlue()) > 127.5;
        if (isLightColor) {
            return new Color(color.getDevice(), Math.max(0, color.getRed() - 20), Math.max(0, color.getGreen() - 20), Math.max(0, color.getBlue() - 20));
        }
        return new Color(color.getDevice(), Math.min(255, color.getRed() + 20), Math.min(255, color.getGreen() + 20), Math.min(255, color.getBlue() + 20));
    }

    private static double calculateHSP(int r, int g, int b) {
        double hsp = Math.sqrt(0.299 * (double)(r * r) + 0.587 * (double)(g * g) + 0.114 * (double)(b * b));
        return hsp;
    }

    public static void updateCurrentTooltip(DVTTooltipContent tooltipContent) {
        DVTTooltipInformationControl tooltipInstance = DVTTooltipInformationControl.getCurrentInstance();
        if (tooltipInstance == null || tooltipInstance.getShell() == null || tooltipInstance.getShell().isDisposed()) {
            return;
        }
        if (tooltipContent != tooltipInstance.getInput()) {
            return;
        }
        Display.getDefault().asyncExec(() -> BrowserProvider.INSTANCE.updateContent(tooltipContent, true));
    }

    public DVTTooltipContent getInput() {
        if (this.fTooltipInput instanceof DVTTooltipContent) {
            return (DVTTooltipContent)this.fTooltipInput;
        }
        return null;
    }

    private static enum BrowserProvider {
        INSTANCE;

        static final String GET_PAGE_WIDTH_SCRIPT = "rectangle = document.getElementById('container').getBoundingClientRect(); return rectangle.width + 10";
        static final String GET_PAGE_HEIGHT_SCRIPT = "rectangle = document.getElementById('container').getBoundingClientRect(); return rectangle.height + 30";
        private Shell browserDummyShell;
        private Browser browserComponent;
        private OpenLinkJSFunction openLinkJSFunction;
        private AtomicBoolean browserResizeShellAfterLoad = new AtomicBoolean();

        private BrowserProvider() {
            try {
                if (!EclipseUtils.hasWorkingBrowser()) {
                    return;
                }
                this.browserDummyShell = new Shell();
                this.browserDummyShell.setSize(940, 720);
                this.browserDummyShell.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                this.browserComponent = new Browser((Composite)this.browserDummyShell, 0);
                this.browserComponent.setSize(940, 720);
                this.openLinkJSFunction = new OpenLinkJSFunction(this.browserComponent);
                this.browserComponent.addListener(35, event -> {
                    boolean bl = event.doit = false;
                });
                this.browserComponent.setMenu(new Menu((Decorations)this.browserDummyShell, 0));
                this.browserComponent.addProgressListener(new ProgressListener(){

                    public void completed(ProgressEvent event) {
                        if (browserContentUUID == null || DVTTooltipInformationControl.getCurrentInstance() == null) {
                            return;
                        }
                        boolean isChromium = Objects.equals(System.getProperty("org.eclipse.swt.browser.DefaultType"), "chromium");
                        if (!isChromium && !browserComponent.getText().contains(browserContentUUID)) {
                            return;
                        }
                        try {
                            try {
                                browserComponent.execute(DVTTooltipInformationControl.getCurrentInstance().isResizable() ? DVTTooltipInformationControl.SET_STYLE_OVERFLOW_SCROLL : DVTTooltipInformationControl.SET_STYLE_OVERFLOW_HIDDEN);
                                if (DVTThemeUtils.isDarkUI()) {
                                    browserComponent.execute("document.documentElement.classList.add('dark-mode');");
                                } else {
                                    browserComponent.execute("document.documentElement.classList.remove('dark-mode');");
                                }
                                if (EclipseUtils.isAtLeastEclipse411()) {
                                    openLinkJSFunction.dispose();
                                    openLinkJSFunction = new OpenLinkJSFunction(browserComponent);
                                } else {
                                    browserComponent.execute("registerOnClickHandlers()");
                                }
                                Object realWidth = BrowserProvider.INSTANCE.browserComponent.evaluate(BrowserProvider.GET_PAGE_WIDTH_SCRIPT);
                                Object realHeight = BrowserProvider.INSTANCE.browserComponent.evaluate(BrowserProvider.GET_PAGE_HEIGHT_SCRIPT);
                                if (realWidth instanceof Double && realHeight instanceof Double) {
                                    DVTTooltipInformationControl tooltipInstance = DVTTooltipInformationControl.getCurrentInstance();
                                    Rectangle computeTrim = tooltipInstance.computeTrim();
                                    tooltipInstance.computedContentWidth = Math.min(((Double)realWidth).intValue() + computeTrim.width, 940);
                                    tooltipInstance.computedContentHeight = Math.min(((Double)realHeight).intValue() + computeTrim.height, 720);
                                    if (browserResizeShellAfterLoad.get()) {
                                        tooltipInstance.getShell().setSize(tooltipInstance.computedContentWidth, tooltipInstance.computedContentHeight);
                                    }
                                }
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                browserLoadCompleted.set(true);
                                ObjectionManager.getInstance().clear(Objection.TOOLTIP);
                            }
                        }
                        finally {
                            browserLoadCompleted.set(true);
                            ObjectionManager.getInstance().clear(Objection.TOOLTIP);
                        }
                    }

                    public void changed(ProgressEvent event) {
                    }
                });
            }
            catch (SWTError e) {
                DVTLogger.INSTANCE.logError((Throwable)new Exception(e));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public boolean setParent(Composite parent) {
            if (parent == null || parent.isDisposed() || this.browserComponent == null) {
                return false;
            }
            if (browserLoadCompleted.get() && DVTTooltipInformationControl.getCurrentInstance() != null && DVTTooltipInformationControl.getCurrentInstance().isResizable()) {
                this.browserComponent.execute(DVTTooltipInformationControl.SET_STYLE_OVERFLOW_SCROLL);
            }
            return this.browserComponent.setParent(parent);
        }

        public synchronized void updateContent(Object input, boolean resize) {
            if (this.browserComponent == null) {
                return;
            }
            browserContentUUID = UUID.randomUUID().toString();
            browserHTMLContent = DVTTooltipInformationControl.getHTMLPage(input);
            browserLoadCompleted.set(false);
            this.browserResizeShellAfterLoad.set(resize);
            this.browserComponent.setText(browserHTMLContent.replace(DVTTooltipInformationControl.HTML_CONTENT_UUID_TAG, browserContentUUID));
        }

        void setURL(String link) {
            if (this.browserComponent == null) {
                return;
            }
            this.browserComponent.setUrl(link);
        }

        void setRedraw(boolean value) {
            if (this.browserComponent == null) {
                return;
            }
            this.browserComponent.setRedraw(value);
        }

        void setSize(int width, int height) {
            if (this.browserComponent == null) {
                return;
            }
            this.browserComponent.setSize(width, height);
        }

        void resetParent() {
            if (this.browserComponent == null || this.browserComponent.isDisposed()) {
                return;
            }
            if (this.browserDummyShell == null || this.browserDummyShell.isDisposed()) {
                return;
            }
            this.browserComponent.setParent((Composite)this.browserDummyShell);
            this.browserComponent.setSize(940, 720);
        }
    }

    private static final class OpenLinkJSFunction
    extends BrowserFunction {
        public OpenLinkJSFunction(Browser browser) {
            super(browser, "DVTOpenLink");
        }

        public Object function(Object[] arguments) {
            super.function(arguments);
            if (arguments == null || arguments.length < 2) {
                return null;
            }
            if (!(arguments[0] instanceof String)) {
                return null;
            }
            if (!(arguments[1] instanceof Boolean)) {
                return null;
            }
            if (((Boolean)arguments[1]).booleanValue()) {
                DVTTooltipInformationControl.getCurrentInstance().handleCtrlClickOnLinkEvent((String)arguments[0]);
            } else {
                DVTTooltipInformationControl.getCurrentInstance().handleClickOnLinkEvent((String)arguments[0]);
            }
            return null;
        }
    }
}

