/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hover;

import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipInformationUtilsCommon;
import ro.amiq.dvt.utils.CommentUtils;

public class DVTTooltipInformationUtils
implements DVTTooltipInformationUtilsCommon {
    private static DVTTooltipInformationUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    private static final String TOOLTIP_DEFAULT_LABEL = "default: ";

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTTooltipInformationUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DVTTooltipInformationUtils();
            }
        }
        return INSTANCE;
    }

    @Override
    public void appendParamDefaultValue(StringBuilder result, String initialValue) {
        if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("Display parameter default value alongside actual value")) {
            return;
        }
        if (initialValue == null || initialValue.isEmpty()) {
            return;
        }
        result.append(" (").append(TOOLTIP_DEFAULT_LABEL).append(initialValue).append(")");
    }

    @Override
    public String extractContent(DVTTooltipContent input) {
        String result;
        block6: {
            result = "";
            if (input != null) break block6;
            return "";
        }
        try {
            if (input.has(DVTTooltipContent.TooltipContent.WAVEDROM_DIAGRAM)) {
                return input.getWaveDromDiagram();
            }
            if (input.has(DVTTooltipContent.TooltipContent.LINTER_PRAGMA)) {
                return input.getLinterPragma();
            }
            if (input.has(DVTTooltipContent.TooltipContent.BITFIELD_DIAGRAM)) {
                result = String.valueOf(result) + CommentUtils.getInstance().getBitfieldDiagramDiv(input.getBitFieldDiagram());
            }
            result = String.valueOf(result) + input.getShallow();
            result = String.valueOf(result) + input.getComment();
            result = String.valueOf(result) + input.getUPFSignature();
            result = String.valueOf(result) + input.getDebugInfo();
            result = String.valueOf(result) + input.getWaveValue();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }
}

