/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hover;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class HTMLTextPresenter
implements DefaultInformationControl.IInformationPresenter,
DefaultInformationControl.IInformationPresenterExtension {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private int fCounter;
    private boolean fEnforceUpperLineLimit;

    public HTMLTextPresenter(boolean enforceUpperLineLimit) {
        this.fEnforceUpperLineLimit = enforceUpperLineLimit;
    }

    public HTMLTextPresenter() {
        this(true);
    }

    protected HTML2TextReader createReader(String hoverInfo, TextPresentation presentation) {
        return new HTML2TextReader((Reader)new StringReader(hoverInfo), presentation);
    }

    protected void adaptTextPresentation(TextPresentation presentation, int offset, int insertLength) {
        int yoursStart = offset;
        int yoursEnd = offset + insertLength - 1;
        yoursEnd = Math.max(yoursStart, yoursEnd);
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            StyleRange range = (StyleRange)e.next();
            int myStart = range.start;
            int myEnd = range.start + range.length - 1;
            if ((myEnd = Math.max(myStart, myEnd)) < yoursStart) continue;
            if (myStart < yoursStart) {
                range.length += insertLength;
                continue;
            }
            range.start += insertLength;
        }
    }

    private void append(StringBuilder buffer, String string, TextPresentation presentation) {
        int length = string.length();
        buffer.append(string);
        if (presentation != null) {
            this.adaptTextPresentation(presentation, this.fCounter, length);
        }
        this.fCounter += length;
    }

    @Deprecated
    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        return this.updatePresentation((Drawable)display, hoverInfo, presentation, maxWidth, maxHeight);
    }

    public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        if (hoverInfo == null) {
            return null;
        }
        if (!this.fEnforceUpperLineLimit) {
            maxHeight = Integer.MAX_VALUE;
        }
        if ((hoverInfo = this.getHoverInfo(hoverInfo, presentation)) == null) {
            return null;
        }
        GC gc = new GC(drawable);
        Font newFont = null;
        try {
            String string;
            TextLayout layout;
            block16: {
                Font font = gc.getFont();
                FontData[] fd = font.getFontData();
                if (fd != null && fd.length > 0) {
                    fd[0].setStyle(1);
                    newFont = new Font(font.getDevice(), fd);
                    gc.setFont(newFont);
                }
                layout = new TextLayout(gc.getDevice());
                layout.setWidth(maxWidth);
                layout.setText(hoverInfo);
                layout.setFont(newFont);
                if (layout.getLineCount() != 0) break block16;
                layout.dispose();
                return "";
            }
            try {
                int[] lineOffsets = layout.getLineOffsets();
                this.fCounter = 0;
                int textHeight = 0;
                StringBuilder buffer = new StringBuilder();
                Rectangle currentLineBounds = layout.getLineBounds(0);
                int currentLineIndex = 0;
                ArrayList<Integer> positionOfInsertedLineBreaks = new ArrayList<Integer>();
                boolean addMoreLines = true;
                while (currentLineIndex < layout.getLineCount() - 1) {
                    Rectangle nextLineBounds = layout.getLineBounds(currentLineIndex + 1);
                    if ((textHeight += currentLineBounds.height) + nextLineBounds.height > maxHeight) {
                        addMoreLines = false;
                        this.appendLastLine(hoverInfo, presentation, lineOffsets, buffer, currentLineIndex);
                        break;
                    }
                    this.appendFullLine(hoverInfo, presentation, lineOffsets, buffer, currentLineIndex, positionOfInsertedLineBreaks);
                    currentLineBounds = nextLineBounds;
                    ++currentLineIndex;
                }
                if (addMoreLines && currentLineIndex < layout.getLineCount()) {
                    this.appendRemainingText(hoverInfo, lineOffsets, buffer, currentLineIndex);
                }
                string = this.trim(buffer, presentation);
            }
            catch (Throwable throwable) {
                layout.dispose();
                throw throwable;
            }
            layout.dispose();
            return string;
        }
        finally {
            if (newFont != null) {
                newFont.dispose();
            }
            gc.dispose();
        }
    }

    private void appendLastLine(String hoverInfo, TextPresentation presentation, int[] lineOffsets, StringBuilder buffer, int currentLineIndex) {
        if (currentLineIndex == 0) {
            this.appendRemainingText(hoverInfo, lineOffsets, buffer, currentLineIndex);
        } else {
            this.append(buffer, "...", presentation);
        }
    }

    private void appendFullLine(String hoverInfo, TextPresentation presentation, int[] lineOffsets, StringBuilder buffer, int currentLineIndex, List<Integer> positionOfInsertedLineBreaks) {
        String line = hoverInfo.substring(lineOffsets[currentLineIndex], lineOffsets[currentLineIndex + 1]);
        this.append(buffer, line, null);
        if (!line.endsWith(LINE_DELIM)) {
            positionOfInsertedLineBreaks.add(lineOffsets[currentLineIndex + 1]);
            this.append(buffer, LINE_DELIM, presentation);
        }
    }

    private void appendRemainingText(String hoverInfo, int[] lineOffsets, StringBuilder buffer, int currentLineIndex) {
        this.append(buffer, hoverInfo.substring(lineOffsets[currentLineIndex], lineOffsets[currentLineIndex + 1]), null);
    }

    private String trim(StringBuilder buffer, TextPresentation presentation) {
        int length = buffer.length();
        int end = length - 1;
        while (end >= 0 && Character.isWhitespace(buffer.charAt(end))) {
            --end;
        }
        if (end == -1) {
            return "";
        }
        if (end < length - 1) {
            buffer.delete(end + 1, length);
        } else {
            end = length;
        }
        int start = 0;
        while (start < end && Character.isWhitespace(buffer.charAt(start))) {
            ++start;
        }
        buffer.delete(0, start);
        presentation.setResultWindow((IRegion)new Region(start, buffer.length()));
        return buffer.toString();
    }

    private String getHoverInfo(String hoverInfo, TextPresentation presentation) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (HTML2TextReader reader = this.createReader(hoverInfo, presentation);){
                return reader.getString().trim();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

