/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hover;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipInformationControl;
import ro.amiq.dvt.utils.CommentUtils;

public interface IDVTHover
extends ITextHoverExtension {
    public static final int MAKE_INFO_TIMEOUT = TestHelper.isTestMode() || CommentUtils.getInstance().shouldUseOldTooltip() ? 50000 : 200;

    default public DVTTooltipContent makeInfo(final ITextViewer textViewer, final IRegion region, final List<ITextHoverParticipant> hoverParticipants) {
        IFile currentFile;
        DVTEditor editor;
        final DVTTooltipContent tooltipContent = new DVTTooltipContent();
        if (region == null) {
            return tooltipContent;
        }
        StringBuilder jobName = new StringBuilder("Computing tooltip content for: ");
        if (textViewer instanceof DVTProjectionViewer && (editor = ((DVTProjectionViewer)textViewer).getEditor()) != null && (currentFile = editor.getCurrentFile()) != null) {
            jobName.append(currentFile.getName());
        }
        jobName.append("@" + region.getOffset());
        Job job = new Job(jobName.toString()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (ITextHoverParticipant textHoverParticipant : hoverParticipants) {
                        textHoverParticipant.makeInfo(textViewer, region, tooltipContent);
                    }
                    if (tooltipContent.isComputing()) {
                        tooltipContent.setComputingStatus(false);
                        DVTTooltipInformationControl.updateCurrentTooltip(tooltipContent);
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        try {
            job.schedule();
            if (!job.join((long)MAKE_INFO_TIMEOUT, (IProgressMonitor)new NullProgressMonitor())) {
                tooltipContent.setComputingStatus(true);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return tooltipContent;
    }
}

