/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkTimeoutException;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StrLenComparator;

public abstract class DVTCommentHyperlinkDetector
implements IHyperlinkDetector {
    private static final List<String> AT_PRAGMAS = Arrays.asList("@link", "@see");
    private static final int AT_PRAGMAS_MAX_LEN = AT_PRAGMAS.stream().max(StrLenComparator.INSTANCE).get().length();
    private static final long TIMEOUT_MILLIS = TestHelper.isIgnoringTimeouts() ? Integer.MAX_VALUE : 500;
    private static final String EXTRA_LINK_CHARACTERS = ":.()#<>,";
    private DVTEditor fEditor;
    private IRfSingleLangProject fRfProject;

    public DVTCommentHyperlinkDetector(DVTEditor editor, IRfSingleLangProject project) {
        this.fEditor = editor;
        this.fRfProject = project;
    }

    public DVTCommentHyperlinkDetector(IRfSingleLangProject project) {
        this.fRfProject = project;
    }

    public IHyperlink[] detectHyperlinks(IDocument document, IRegion region) {
        if (region == null) {
            return null;
        }
        return this.detectHyperlinksHelper(region.getOffset(), document);
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (this.fRfProject == null) {
            return null;
        }
        if (region == null || this.fEditor == null) {
            return null;
        }
        int offset = region.getOffset();
        if (offset < 0) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (!this.isInCommentPartition(document, offset)) {
            return null;
        }
        return this.detectHyperlinksHelper(offset, document);
    }

    private IHyperlink[] detectHyperlinksHelper(int offset, IDocument document) {
        ParseCommentResult parsedComment = this.parseComment(document, offset);
        if (parsedComment == null || parsedComment.getTypes() == null || parsedComment.getTypes().length == 0) {
            return null;
        }
        try {
            IHyperlink[] accurateHyperlinks = null;
            if (parsedComment.getPackageName() != null) {
                accurateHyperlinks = this.getAbsolutePathHyperlink(parsedComment, document);
            }
            if (accurateHyperlinks != null) {
                return accurateHyperlinks;
            }
            Collection<IRfNamedElement> candidates = this.getInitialCandidates(document, parsedComment.getRegion().getOffset());
            return this.getRelativePathHyperlinks(candidates, parsedComment, document);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected ParseCommentResult parseComment(IDocument document, int anchor) {
        String types;
        Region resultRegion;
        String packName;
        block20: {
            int start;
            char c;
            DVTCharacterScanner scanner;
            char p;
            int offset;
            boolean isAbsolutePath;
            DVTStringBuilder buffer;
            block19: {
                packName = null;
                buffer = new DVTStringBuilder();
                isAbsolutePath = false;
                offset = anchor;
                p = '\uffff';
                scanner = new DVTCharacterScanner(200, document, offset, false);
                c = (char)scanner.read();
                if (Character.isJavaIdentifierPart(c) || EXTRA_LINK_CHARACTERS.indexOf(c) != -1) {
                    scanner.unread();
                }
                while (scanner.getOffset() >= 0) {
                    p = c;
                    c = (char)scanner.read();
                    if (c == ' ' && p == '#') continue;
                    if (c == ',' && p == ' ') {
                        buffer.prepend(c);
                        continue;
                    }
                    if (!Character.isJavaIdentifierPart(c) && EXTRA_LINK_CHARACTERS.indexOf(c) == -1) {
                        scanner.unread();
                        break;
                    }
                    if (c == ':' && p == ':') {
                        isAbsolutePath = true;
                    }
                    buffer.prepend(c);
                }
                start = scanner.getOffset();
                boolean foundLink = false;
                DVTStringBuilder matchInclude = new DVTStringBuilder();
                while (scanner.getOffset() >= 0) {
                    c = (char)scanner.read();
                    if (Character.isWhitespace(c) && c != '\n') continue;
                    if (!Character.isAlphabetic(c) && c != '@') break;
                    matchInclude.prepend(c);
                    if (matchInclude.length() > AT_PRAGMAS_MAX_LEN) {
                        matchInclude.deleteLastChar();
                    }
                    if (!AT_PRAGMAS.contains(matchInclude.toString())) continue;
                    foundLink = true;
                    break;
                }
                if (foundLink) break block19;
                return null;
            }
            try {
                int indexOfPackageDelimiter;
                int end;
                offset = anchor;
                int length = document.getLength();
                p = '\uffff';
                scanner = new DVTCharacterScanner(200, document, offset, true);
                c = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(c) && EXTRA_LINK_CHARACTERS.indexOf(c) == -1) {
                    scanner.unread();
                }
                while (scanner.getOffset() < length) {
                    p = c;
                    c = (char)scanner.read();
                    if (c == ' ' && Character.isJavaIdentifierPart(p) && buffer.getLastChar() == ',') continue;
                    if (p == ' ' && c == '#') {
                        buffer.append(c);
                        continue;
                    }
                    if (p == ',' && c == ' ') continue;
                    if (!Character.isJavaIdentifierPart(c) && EXTRA_LINK_CHARACTERS.indexOf(c) == -1) break;
                    if (c == ':' && p == ':') {
                        isAbsolutePath = true;
                    }
                    if (scanner.getOffset() == anchor) continue;
                    buffer.append(c);
                }
                resultRegion = start == (end = scanner.getOffset()) ? new Region(start, 0) : new Region(start, end - start - 1);
                types = buffer.toString();
                if (isAbsolutePath && (indexOfPackageDelimiter = types.indexOf("::")) > 0) {
                    packName = types.substring(0, indexOfPackageDelimiter);
                    if (!packName.isEmpty() && !packName.contains(".")) {
                        types = types.substring(indexOfPackageDelimiter + 2);
                    } else {
                        packName = null;
                    }
                }
                if (!CommentUtils.getInstance().containsUnpermittedPatterns(types)) break block20;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        String[] relativePathTypes = DVTStringUtil.split(CommentConstants.LINK_SPLIT_PATTERN, types);
        if (relativePathTypes.length != 0) {
            return new ParseCommentResult(packName, CommentUtils.getInstance().cleanArray(relativePathTypes), (IRegion)resultRegion);
        }
        relativePathTypes = new String[]{types};
        return new ParseCommentResult(packName, relativePathTypes, (IRegion)resultRegion);
    }

    public IRfSingleLangProject getProject() {
        return this.fRfProject;
    }

    public DVTEditor getEditor() {
        return this.fEditor;
    }

    public IHyperlink[] getAbsolutePathHyperlink(ParseCommentResult parsedComment, IDocument document) throws HyperlinkTimeoutException {
        String[] types = parsedComment.getTypes();
        List<IRfNamedElement> packageCandidates = this.getPackageCandidates(parsedComment);
        if (packageCandidates == null) {
            return null;
        }
        List<IHyperlink> actionHyperlinks = this.solveHyperlinkForAllCandidates(packageCandidates, types, parsedComment.getRegion(), document, System.currentTimeMillis() + TIMEOUT_MILLIS);
        if (actionHyperlinks.isEmpty()) {
            return null;
        }
        return actionHyperlinks.toArray(new IHyperlink[actionHyperlinks.size()]);
    }

    public IHyperlink[] getRelativePathHyperlinks(Collection<IRfNamedElement> candidates, ParseCommentResult parsedComment, IDocument document) throws HyperlinkTimeoutException {
        if (candidates == null) {
            return null;
        }
        String[] types = parsedComment.getAllTypes();
        List<IHyperlink> actionHyperlinks = this.solveHyperlinkForAllCandidates(candidates, types, parsedComment.getRegion(), document, System.currentTimeMillis() + TIMEOUT_MILLIS);
        if (actionHyperlinks.isEmpty()) {
            return null;
        }
        return actionHyperlinks.toArray(new IHyperlink[actionHyperlinks.size()]);
    }

    protected abstract boolean isInCommentPartition(IDocument var1, int var2);

    protected abstract Collection<IRfNamedElement> getInitialCandidates(IDocument var1, int var2) throws BadLocationException;

    protected abstract List<IRfNamedElement> getPackageCandidates(ParseCommentResult var1);

    protected abstract List<IHyperlink> solveHyperlinkForAllCandidates(Collection<IRfNamedElement> var1, String[] var2, IRegion var3, IDocument var4, long var5) throws HyperlinkTimeoutException;

    protected static class ParseCommentResult {
        private String packName;
        private String[] types;
        private IRegion region;

        ParseCommentResult(String packName, String[] types, IRegion region) {
            this.packName = packName;
            this.types = types;
            this.region = region;
        }

        public String getPackageName() {
            return this.packName;
        }

        public String[] getTypes() {
            return this.types;
        }

        public IRegion getRegion() {
            return this.region;
        }

        public String[] getAllTypes() {
            if (this.packName != null) {
                return (String[])ArrayUtils.add((Object[])this.types, (int)0, (Object)this.packName);
            }
            return this.types;
        }
    }
}

