/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class DVTHyperlinkDetector
implements IHyperlinkDetector {
    protected ITextEditor fTextEditor;
    public static final int COMPUTING_HYPERLINKS_TIMEOUT_MS = 200;
    private static final Pattern fOpenTypePattern = Pattern.compile("Open\\s\\w+\\sType");
    private static final Pattern fOpenDeclarationPattern = Pattern.compile("Open\\s\\w+\\sDeclaration");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] result = this.detectHyperlinksWrapper(textViewer, region, canShowMultipleHyperlinks, 200);
        if (result != null && result.length == 0) {
            return null;
        }
        return result;
    }

    public IDVTHyperlink[] detectHyperlinksWrapper(final ITextViewer textViewer, final IRegion region, final boolean canShowMultipleHyperlinks, int timeout) {
        try {
            final AtomicBoolean doneComputingHyperlinks = new AtomicBoolean();
            final ArrayList hyperlinks = new ArrayList();
            final Job computingHyperlinksJob = new Job("Detecting hyperlinks in " + (this.fTextEditor != null ? this.fTextEditor.getTitle() : "") + " @ " + region.getOffset()){

                protected IStatus run(IProgressMonitor monitor) {
                    IDVTHyperlink[] computedHyperlinks = DVTHyperlinkDetector.this.detectHyperlinksInternal(textViewer, region, canShowMultipleHyperlinks);
                    if (computedHyperlinks != null) {
                        hyperlinks.addAll(Arrays.asList(computedHyperlinks));
                    }
                    doneComputingHyperlinks.set(true);
                    return Status.OK_STATUS;
                }
            };
            computingHyperlinksJob.setSystem(true);
            computingHyperlinksJob.schedule();
            computingHyperlinksJob.join((long)timeout, null);
            if (doneComputingHyperlinks.get()) {
                return hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
            }
            List<String> defaultHyperlinks = this.getDefaultHyperlinks();
            return defaultHyperlinks.stream().map(hyperlink -> new IDVTHyperlink((String)hyperlink, textViewer, region){
                private Optional<IDVTHyperlink> validHyperlink;
                private final /* synthetic */ String val$hyperlink;
                private final /* synthetic */ ITextViewer val$textViewer;
                private final /* synthetic */ IRegion val$region;
                {
                    this.val$hyperlink = string;
                    this.val$textViewer = iTextViewer;
                    this.val$region = iRegion;
                }

                @Override
                public boolean updateNonGuiPart() {
                    try {
                        computingHyperlinksJob.join();
                        this.validHyperlink = hyperlinks.stream().filter(Objects::nonNull).filter(hyperlink -> this.isEqual(hyperlink.getHyperlinkText())).findFirst();
                        if (this.validHyperlink.isPresent()) {
                            return this.validHyperlink.get().updateNonGuiPart();
                        }
                        return true;
                    }
                    catch (InterruptedException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }

                @Override
                public void updateGuiPart() {
                    if (this.validHyperlink.isPresent()) {
                        this.validHyperlink.get().updateGuiPart();
                    } else {
                        Utils.popMessage(1, "Operation not possible!", "'" + this.getHyperlinkText() + "' hyperlink not available for element under cursor.");
                    }
                }

                @Override
                public void postUpdateNonGuiPart(IEditorPart editor) {
                    if (this.validHyperlink.isPresent()) {
                        this.validHyperlink.get().postUpdateNonGuiPart(editor);
                    }
                }

                public boolean isEqual(String validHyperlinkText) {
                    String hyperlinkText = this.getHyperlinkText();
                    if (this.getHyperlinkText().startsWith(validHyperlinkText)) {
                        return true;
                    }
                    if (hyperlinkText.contains("Open Associated Type") && fOpenTypePattern.matcher(validHyperlinkText).matches()) {
                        return true;
                    }
                    return hyperlinkText.contains("Open Design Declaration") && fOpenDeclarationPattern.matcher(validHyperlinkText).matches();
                }

                public String getTypeLabel() {
                    return this.val$hyperlink;
                }

                public String getHyperlinkText() {
                    return this.val$hyperlink;
                }

                public IRegion getHyperlinkRegion() {
                    return DVTHyperlinkDetector.this.getWordFinder().getWordAtOffset(((DVTProjectionViewer)this.val$textViewer).getDocument(), this.val$region.getOffset());
                }
            }).collect(Collectors.toList()).toArray(new IDVTHyperlink[defaultHyperlinks.size()]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IDVTHyperlink[0];
        }
    }

    private IDVTHyperlink createELHyperlink(final IActionHyperlink hyperlinkAction, final String label) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction != null ? hyperlinkAction.getHyperlinkRegion() : null;
            }

            public String getTypeLabel() {
                return hyperlinkAction != null ? hyperlinkAction.getTypeLabel() : "";
            }

            public String getHyperlinkText() {
                return label;
            }

            private void updateDPM(ElementPath bcPath, IEditorPart activeEditor) {
                if (bcPath == null || bcPath == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
                    return;
                }
                if (!(activeEditor instanceof DVTEditor)) {
                    return;
                }
                DesignPathManager.getInstance().updateFor((IDVTBreadcrumbTextHost)activeEditor, bcPath);
            }

            @Override
            public void updateGuiPart() {
                hyperlinkAction.updateGuiPart();
            }

            @Override
            public void postUpdateNonGuiPart(IEditorPart editor) {
                this.updateDPM(hyperlinkAction.getElementPath(), editor);
            }

            @Override
            public boolean updateNonGuiPart() {
                if (!(DVTHyperlinkDetector.this.fTextEditor instanceof DVTEditor)) {
                    return false;
                }
                if (hyperlinkAction == null) {
                    return false;
                }
                if (((DVTEditor)DVTHyperlinkDetector.this.fTextEditor).hasBreadcrumbViewer(new Class[]{VHBreadcrumbViewer.class})) {
                    DVTHyperlinkDetector.this.setDataForVHBreadcrumb((DVTEditor)DVTHyperlinkDetector.this.fTextEditor, label, hyperlinkAction);
                }
                return true;
            }
        };
    }

    public IDVTHyperlink createHyperlink(final IActionHyperlink hyperlinkAction, final String label) {
        IRfNamedElement rfNamedElement = hyperlinkAction.getRfNamedElement();
        if (this.fTextEditor instanceof DVTEditor && DesignPathManager.getInstance().isEligible((DVTEditor)this.fTextEditor)) {
            boolean isDesignElement;
            boolean bl = isDesignElement = rfNamedElement instanceof IRfDesignElement || RfSearchUtils.isPortOrParameterElement(rfNamedElement) || RfSearchUtils.canBeReadOrWritten(rfNamedElement);
            if (isDesignElement) {
                ElementPath pathFor = DesignPathManager.getInstance().getPathFor((DVTEditor)this.fTextEditor, hyperlinkAction.getHyperlinkRegion().getOffset(), rfNamedElement, hyperlinkAction.getScope(), false, false);
                hyperlinkAction.setElementPath(pathFor);
            }
            return this.createELHyperlink(hyperlinkAction, label);
        }
        return new IDVTHyperlink(){

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return label;
            }

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            @Override
            public void updateGuiPart() {
                if (hyperlinkAction != null) {
                    hyperlinkAction.updateGuiPart();
                }
            }

            @Override
            public boolean updateNonGuiPart() {
                DVTHyperlinkDetector.this.setDataForBreadcrumb(hyperlinkAction, label);
                return hyperlinkAction.updateNonGuiPart();
            }
        };
    }

    protected void createOpenInstanceHyperlink(ITextEditor textEditor, IRegion region, IRfNamedElement namedElement, List<IDVTHyperlink> links) {
        if (region == null || namedElement == null || links == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        if (!(namedElement instanceof IRfDesignElement) || !RfSearchUtils.isInstantiable(namedElement)) {
            return;
        }
        IRfNamedElement.ElementKind elementKind = ((IRfDesignElement)namedElement).getKind();
        if (IRfNamedElement.ElementKind.VHDL_COMPONENT.equals((Object)elementKind)) {
            return;
        }
        DVTEditor editor = (DVTEditor)textEditor;
        ElementPath instancePath = DesignPathManager.getInstance().getPathFor(editor, region.getOffset(), false, false);
        if (instancePath == null || instancePath == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
            return;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(editor.getProject());
        if (memory == null) {
            return;
        }
        ELInstance elInstance = memory.instanceFor(instancePath);
        if (elInstance == null) {
            return;
        }
        IRfInstanceElement instance = elInstance.getDescription();
        if (instance == null) {
            return;
        }
        IRfNamedElement leafDesignElement = elInstance.getBinding(true);
        if (leafDesignElement == null || !ELUtils.hasValidBinding(elInstance) || !leafDesignElement.checkEquals(namedElement)) {
            return;
        }
        IActionHyperlink createOpenAction = this.createOpenAction(instance, editor.getProject(), region);
        ElementPath elementPath = instancePath.removeLastSegment();
        createOpenAction.setElementPath(elementPath);
        links.add(this.createELHyperlink(createOpenAction, DVTHyperlinkMessages.openCurrentInstance));
    }

    protected boolean isDesignElementDefinition(DVTEditor editor, IRegion region, IRfNamedElement namedElement) {
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        Object iFile = editor.getAdapter(IResource.class);
        if (!(iFile instanceof IFile)) {
            return false;
        }
        IRfFileDef file = rfProject.getFile((IResource)iFile);
        if (file == null) {
            return false;
        }
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration.getLanguageKind() != this.getSourceLanguageKind()) {
            return false;
        }
        if (file != declaration.getDefFile()) {
            return false;
        }
        int startLine = declaration.getStartLine();
        int endLine = declaration.getEndLine();
        int offset = region.getOffset();
        int hyperlinkLine = DVTFileUtils.getInstance().getLineFromOffset((IFile)iFile, offset);
        return startLine <= hyperlinkLine && hyperlinkLine <= endLine;
    }

    protected IDVTHyperlink createShowInstancesHyperlink(final IActionHyperlink hyperlinkAction, IRfNamedElement element) {
        if (!RfSearchUtils.isInstantiable(element)) {
            return null;
        }
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showInstances;
            }

            @Override
            public boolean updateNonGuiPart() {
                return true;
            }

            @Override
            public void updateGuiPart() {
                DVTHyperlinkDetector.this.openShowInstances(hyperlinkAction.getRfNamedElement());
            }
        };
    }

    protected void createShowInstancesInDHHyperlink(IActionHyperlink hyperlink, List<IDVTHyperlink> links, IRfNamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        boolean canHaveInstances = RfSearchUtils.isInstantiable(namedElement);
        if (!canHaveInstances) {
            return;
        }
        IRfSingleLangProject project = namedElement.getRfProject();
        if (project == null || project.getELManager() == null) {
            return;
        }
        links.add(this.createShowInstancesInDHHyperlink(hyperlink, namedElement));
    }

    private IDVTHyperlink createShowInstancesInDHHyperlink(final IActionHyperlink hyperlinkAction, final IRfNamedElement element) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                String message = DVTHyperlinkMessages.getMessage(DVTHyperlinkMessages.showInstancesInDH, element.getName());
                return message;
            }

            @Override
            public boolean updateNonGuiPart() {
                return true;
            }

            @Override
            public void updateGuiPart() {
                DVTHyperlinkDetector.this.openShowInstancesInDH(element);
            }
        };
    }

    protected IDVTHyperlink createReadersUsagesHyperlink(final IActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showReadersUsages;
            }

            @Override
            public boolean updateNonGuiPart() {
                return true;
            }

            @Override
            public void updateGuiPart() {
                DVTHyperlinkDetector.this.openShowReadersUsages(hyperlinkAction);
            }
        };
    }

    protected IDVTHyperlink createWritersUsagesHyperlink(final IActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showWritersUsages;
            }

            @Override
            public boolean updateNonGuiPart() {
                return true;
            }

            @Override
            public void updateGuiPart() {
                DVTHyperlinkDetector.this.openShowWritersUsages(hyperlinkAction);
            }
        };
    }

    protected void createShowInstancesHyperlink(IActionHyperlink hyperlink, List<IDVTHyperlink> hyperlinks, IRfNamedElement namedElement) {
        if (!RfSearchUtils.isInstantiable(namedElement)) {
            return;
        }
        hyperlinks.add(this.createShowInstancesHyperlink(hyperlink, namedElement));
    }

    protected void createShowReadersHyperlink(IActionHyperlink hyperlink, List<IDVTHyperlink> links) {
        if (!RfSearchUtils.canBeReadOrWritten(hyperlink.getRfNamedElement())) {
            return;
        }
        links.add(this.createReadersUsagesHyperlink(hyperlink));
    }

    protected void createShowWritersHyperlink(IActionHyperlink hyperlink, List<IDVTHyperlink> links) {
        if (!RfSearchUtils.canBeReadOrWritten(hyperlink.getRfNamedElement())) {
            return;
        }
        links.add(this.createWritersUsagesHyperlink(hyperlink));
    }

    protected abstract void openShowInstances(IRfNamedElement var1);

    protected abstract void openShowInstancesInDH(IRfNamedElement var1);

    public abstract IDVTHyperlink[] detectHyperlinksInternal(ITextViewer var1, IRegion var2, boolean var3);

    public abstract DVTWordFinder getWordFinder();

    public abstract List<String> getDefaultHyperlinks();

    protected abstract IActionHyperlink createOpenAction(IRfInstanceElement var1, IProject var2, IRegion var3);

    protected abstract void openShowReadersUsages(IActionHyperlink var1);

    protected abstract void openShowWritersUsages(IActionHyperlink var1);

    protected abstract void setDataForBreadcrumb(IActionHyperlink var1, String var2);

    protected void setDataForVHBreadcrumb(DVTEditor activeEditor, String label, IActionHyperlink hyperlinkAction) {
    }

    protected abstract LanguageKind getSourceLanguageKind();
}

