/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hyperlink.IHyperlinkContext;
import ro.amiq.dvt.ui.editor.hyperlink.IHyperlinkDetectorContributor;

public enum DVTHyperlinkDetectorContributors {
    INSTANCE;

    private static final String EXTENSION_POINT_ID = "ro.amiq.dvt.hyperlinkDetectorContributors";
    private final List<IHyperlinkDetectorContributor> contributors = new LinkedList<IHyperlinkDetectorContributor>();

    private DVTHyperlinkDetectorContributors() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n2 = elements.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement element = iConfigurationElementArray[n3];
            Object contributor = null;
            try {
                contributor = element.createExecutableExtension("class");
                if (contributor != null && contributor instanceof IHyperlinkDetectorContributor) {
                    this.contributors.add((IHyperlinkDetectorContributor)contributor);
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n3;
        }
    }

    public void insertHyperlinks(List<IDVTHyperlink> hyperlinks, IHyperlinkContext context) {
        if (hyperlinks == null) {
            hyperlinks = new ArrayList<IDVTHyperlink>();
        }
        for (IHyperlinkDetectorContributor contributor : this.contributors) {
            try {
                contributor.insertHyperlinks(hyperlinks, context);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

