/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtilsCommon;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsCommon;

public class DVTHyperlinkUtils
extends DVTHyperlinkUtilsCommon {
    private static DVTHyperlinkUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    private static final String HYPERLINKS_ELEMENT_FROM_CURSOR_BENCHMARK = "[HYPERLINKS] Element from cursor benchmark: ";
    private static final String HYPERLINKS_HYPERLINK_PROPOPALS_BENCHMARK = "[HYPERLINKS] Hyperlink propopals benchmark: ";
    public static final String SHOW_MORE_HYPERLINKS = "Show more...";
    public static final String SHOW_MORE_PREFIX = "+ ";
    public static final int NO_OF_PVLOG_HYPERLINKS = 1;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTHyperlinkUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DVTHyperlinkUtils();
            }
        }
        return INSTANCE;
    }

    public void reportHyperlinkElementFromCursorBenchmark(long time) {
        DVTLogger.INSTANCE.logInfo(HYPERLINKS_ELEMENT_FROM_CURSOR_BENCHMARK + time + "ms");
    }

    public void reportHyperlinkProposalsBenchmark(long time) {
        DVTLogger.INSTANCE.logInfo(HYPERLINKS_HYPERLINK_PROPOPALS_BENCHMARK + time + "ms");
    }

    @Override
    protected IRfNamedElement getEnclosingDesignOrInstance(IRfNamedElement signal, int offset, DVTEditor editor) {
        IRfNamedElement enclosingDesignOrInstance;
        IRfBreadcrumbElement scopeAtOffset = ((ScopeBreadcrumbUtils)editor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class)).getScopeForBreadcrumb((ITextEditor)editor, offset, true);
        IRfScopeElement enclosingScopeOfSignal = signal.getEnclosingScope();
        IRfNamedElement iRfNamedElement = enclosingDesignOrInstance = enclosingScopeOfSignal instanceof IRfNamedElement ? (IRfNamedElement)enclosingScopeOfSignal : TCViewUtilsCommon.getModuleOrEntity(signal);
        if (scopeAtOffset instanceof IRfInstanceElement && enclosingScopeOfSignal instanceof IRfDesignElement && ((IRfInstanceElement)scopeAtOffset).getInstantiatedDesign() == enclosingScopeOfSignal) {
            enclosingDesignOrInstance = (IRfNamedElement)scopeAtOffset;
        }
        return enclosingDesignOrInstance;
    }

    @Override
    protected IRfNamedElementAndScope getNamedElementAndScope(int offset, DVTEditor editor) {
        return editor.getElementFromOffset(offset);
    }

    @Override
    protected IEditorPart openEditor(IFile file) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)false);
    }

    @Override
    protected IRfScopeElement getEnclosingScopeElement(DVTEditor editor, IEditorPart openEditor, TCPathPoint finalPathPoint) {
        AbstractBreadcrumbUtils scopeBreadcrumbUtils = editor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (!(scopeBreadcrumbUtils instanceof ScopeBreadcrumbUtils)) {
            return null;
        }
        IRfBreadcrumbElement enclosingScope = ((ScopeBreadcrumbUtils)scopeBreadcrumbUtils).getScopeForBreadcrumb((ITextEditor)openEditor, finalPathPoint.statement.goToInfo.offset, true);
        if (enclosingScope instanceof IRfInstanceElement) {
            enclosingScope = (IRfBreadcrumbElement)((Object)enclosingScope.getEnclosingScope());
        }
        return enclosingScope instanceof IRfScopeElement ? (IRfScopeElement)((Object)enclosingScope) : null;
    }
}

