/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfoWithElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtils;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManagerCommon;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TCWrapperAdapter;
import ro.amiq.dvt.ui.views.designhierarchy.IDHNodeFactory;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class DVTHyperlinkUtilsCommon {
    protected TCNode oldExpandedBreadcrumbLeaf;
    public final Predicate<TCPathPoint> PATH_POINT_VALIDATOR = t -> t.statement != null && t.statement.goToInfo != null && t.statement.goToInfo.filePath != null && t.statement.goToInfo.line >= 0 && t.statement.goToInfo.offset >= 0;
    public static final int NO_OF_OPEN_DECLARATION_HYPERLINKS = 1;

    public List<ELInstance> getInstancesFor(final IRfInstanceElement instanceToSearch, final boolean stripToEntity, IProject project, final int maxNoOfInstances) {
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return Collections.emptyList();
        }
        final ArrayList<ELInstance> instances = new ArrayList<ELInstance>(2);
        final HashSet uniqueBinding = new HashSet();
        memory.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfNamedElement binding = instance.getBinding(stripToEntity);
                if (binding == ELConstants.RECURRENCE_INSTANCE_TYPE) {
                    return true;
                }
                if (instance.getDescription() == instanceToSearch && uniqueBinding.add(binding)) {
                    instances.add(ELInstance.copyOf(instance, path, false));
                }
                return instances.size() < maxNoOfInstances;
            }
        });
        return instances;
    }

    public List<ELInstance> getInstancesFor(final IRfNamedElement binding, final boolean stripToEntity, IProject project, final int maxNoOfInstances) {
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return Collections.emptyList();
        }
        if (binding == null || !memory.hasBindings()) {
            return Collections.emptyList();
        }
        final boolean isComponent = DesignUtils.getDesignKind(binding) == IRfNamedElement.ElementKind.VHDL_COMPONENT;
        final ArrayList<ELInstance> instances = new ArrayList<ELInstance>(2);
        final HashSet uniqueBinding = new HashSet();
        memory.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (isComponent) {
                    IRfInstanceElement description = instance.getDescription();
                    if (description == null || description.getLanguageKind() != LanguageKind.VHDL) {
                        return instances.size() < maxNoOfInstances;
                    }
                    if (description.getVHDLPreElaborationDesign() == binding && uniqueBinding.add(instance.getBinding(stripToEntity))) {
                        instances.add(ELInstance.copyOf(instance, path, false));
                    }
                    return instances.size() < maxNoOfInstances;
                }
                if (instance.getBinding(stripToEntity) == binding && uniqueBinding.add(instance.getBinding(stripToEntity))) {
                    instances.add(ELInstance.copyOf(instance, path, false));
                }
                return instances.size() < maxNoOfInstances;
            }
        });
        return instances;
    }

    public TCPathPoint getFirstWriter(List<TCPathPoint> writers, IFile file, IDocument document, int offset) {
        IFile file1 = file;
        int line = -1;
        try {
            line = document.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        ArrayList<TCPathPoint> writersAfter = new ArrayList<TCPathPoint>();
        ArrayList<TCPathPoint> writersInOtherFiles = new ArrayList<TCPathPoint>();
        ArrayList<TCPathPoint> writersBefore = new ArrayList<TCPathPoint>();
        for (TCPathPoint info : writers) {
            if (!this.PATH_POINT_VALIDATOR.test(info)) continue;
            if (info.statement.goToInfo.filePath.contains(file1.getName())) {
                if (info.statement.goToInfo.line <= line) {
                    writersBefore.add(info);
                    continue;
                }
                writersAfter.add(info);
                continue;
            }
            writersInOtherFiles.add(info);
        }
        Comparator filePathComparator = (o1, o2) -> o1.statement.goToInfo.filePath.compareTo(o2.statement.goToInfo.filePath);
        Comparator offsetComparator = (o1, o2) -> o1.statement.goToInfo.offset - o2.statement.goToInfo.offset;
        Comparator lineComparator = (o1, o2) -> o1.statement.goToInfo.line - o2.statement.goToInfo.line;
        writersInOtherFiles.sort(filePathComparator);
        writersAfter.sort(offsetComparator);
        writersInOtherFiles.sort(offsetComparator);
        writersBefore.sort(offsetComparator);
        writersAfter.sort(lineComparator);
        writersInOtherFiles.sort(lineComparator);
        writersBefore.sort(lineComparator);
        return !writersAfter.isEmpty() ? (TCPathPoint)writersAfter.get(0) : (!writersInOtherFiles.isEmpty() ? (TCPathPoint)writersInOtherFiles.get(0) : (!writersBefore.isEmpty() ? (TCPathPoint)writersBefore.get(0) : null));
    }

    public void createJumpToAssignmentHyperlink(ITextEditor textEditor, IFile file, IActionHyperlink action, int offset, IRfFieldElement field, IRfSingleLangProject rfProject, List<IDVTHyperlink> links) {
        if (textEditor == null || action == null || field == null || links == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        DVTEditor editor = (DVTEditor)textEditor;
        if (!DesignPathManager.getInstance().isEligible(editor)) {
            return;
        }
        if (editor.getDesignPathProvider().isPort(field)) {
            links.add(this.createJumpToSignalHyperlink(editor, file, action, offset, field, rfProject));
        } else {
            links.add(this.createJumpToParamAssignmentHyperlink(editor, action, field, rfProject));
        }
    }

    private IDVTHyperlink createJumpToParamAssignmentHyperlink(final DVTEditor editor, final IActionHyperlink action, final IRfFieldElement field, final IRfSingleLangProject rfProject) {
        return new IDVTHyperlink(){
            private GoToInfoWithElementPath goToParamAssignment;

            @Override
            public boolean updateNonGuiPart() {
                if (!DesignPathManager.getInstance().isEligible(editor)) {
                    return false;
                }
                IRegion region = action.getHyperlinkRegion();
                if (region == null) {
                    return false;
                }
                ElementPath path = DesignPathManager.getInstance().getPathFor(editor, region.getOffset(), field, action.getScope(), false, false);
                if (path == null || path == DesignPathManagerCommon.FROZEN_MANAGER_EL_PATH) {
                    return false;
                }
                this.goToParamAssignment = DVTRfUtils.computeGoToParamAssignment(field, rfProject, path);
                return this.goToParamAssignment != null;
            }

            @Override
            public void updateGuiPart() {
                this.goToParamAssignment.open(editor.getProject(), true);
            }

            public String getTypeLabel() {
                return DVTHyperlinkMessages.jumpToAssignment;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.jumpToAssignment;
            }

            public IRegion getHyperlinkRegion() {
                return action.getHyperlinkRegion();
            }
        };
    }

    private IDVTHyperlink createJumpToSignalHyperlink(final DVTEditor editor, final IFile file, final IActionHyperlink action, final int offset, final IRfFieldElement field, IRfSingleLangProject rfProject) {
        return new IDVTHyperlink(){
            private IFile destinationFile;
            private TCPathPoint writer;

            @Override
            public void updateGuiPart() {
                try {
                    DVTHyperlinkUtilsCommon.this.openEditor(this.destinationFile);
                }
                catch (PartInitException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                IDocument document = DVTFileUtils.getInstance().getOpenDocument(this.destinationFile);
                if (document != null) {
                    DVTFileUtils.getInstance().openEditor(this.destinationFile, DVTHyperlinkUtils.getInstance().getRegionOfHyperlink(document, this.writer.statement.goToInfo.offset, this.writer.isPortConnection(), field));
                } else {
                    DVTFileUtils.getInstance().openEditor(this.destinationFile, (IRegion)new Region(this.writer.statement.goToInfo.offset, 2));
                }
            }

            @Override
            public boolean updateNonGuiPart() {
                if (editor == null) {
                    return false;
                }
                IProject project = editor.getProject();
                if (project == null) {
                    return false;
                }
                ELManager manager = RfMixedLangManager.getInstance().getELManager(project);
                if (manager == null) {
                    return false;
                }
                IRegion region = action.getHyperlinkRegion();
                if (region == null) {
                    return false;
                }
                ElementPath path = DesignPathManager.getInstance().getPathFor(editor, region.getOffset(), field, action.getScope(), false, TestHelper.isTestMode());
                if (path == null || path == DesignPathManager.FROZEN_MANAGER_EL_PATH) {
                    return false;
                }
                IELMemory memory = manager.getMemory();
                ELInstance instance = memory.instanceFor(path);
                if (instance == null) {
                    return false;
                }
                if (!ELUtils.hasValidBinding(instance)) {
                    return false;
                }
                IRfNamedElement binding = instance.getBinding(true);
                IDHNodeFactory<IDVTElementWrapper> factory = DVTHyperlinkUtilsCommon.this.getNodeFactory();
                Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap = DVTHyperlinkUtilsCommon.this.getDummyPortMap();
                IRfScopeElement enclosingScopeOfSignal = field.getEnclosingScope();
                IRfNamedElementAndScope namedElementAndScope = DVTHyperlinkUtilsCommon.this.getNamedElementAndScope(offset, editor);
                IRfNamedElement enclosingDesignOrInstance = (IRfNamedElement)enclosingScopeOfSignal;
                if (namedElementAndScope != null && DesignPathManager.getInstance().appendInstanceScope(field, namedElementAndScope.getScope())) {
                    enclosingDesignOrInstance = namedElementAndScope.getScope() instanceof IRfNamedElement ? (IRfNamedElement)namedElementAndScope.getScope() : ((IRfDefElement)((Object)namedElementAndScope.getScope())).getNamedElement();
                }
                List<ElementPath> subPaths = path.getSubPaths();
                IDVTElementWrapper node = null;
                IDVTElementWrapper enclosingWrapper = null;
                for (ElementPath subPath : subPaths) {
                    ELInstance elInstance = memory.instanceFor(subPath);
                    if (elInstance == null) continue;
                    if (node == null) {
                        node = TCUtils.createTCNodeWrapperNewElab(elInstance, factory);
                    } else {
                        IDVTElementWrapper newNode = TCUtils.createTCNodeWrapperNewElab(elInstance, factory);
                        node.addChild(newNode);
                        node = newNode;
                    }
                    if ((!(enclosingDesignOrInstance instanceof IRfInstanceElement) || !enclosingDesignOrInstance.equals(elInstance.getDescription())) && !enclosingDesignOrInstance.equals(elInstance.getBinding(false)) && !enclosingDesignOrInstance.equals(elInstance.getBinding(true))) continue;
                    enclosingWrapper = node;
                }
                List<IRfNamedElement> stackAsList = namedElementAndScope != null && namedElementAndScope.getElementAndScopeStack() != null ? namedElementAndScope.getElementAndScopeStack().stream().filter(scope -> scope != null).map(scopeAndStack -> scopeAndStack.getIRfNamedElement()).collect(Collectors.toList()) : null;
                TCNode tcNode = null;
                IDVTElementWrapper newParent = null;
                boolean isHierachical = false;
                if (stackAsList != null && !stackAsList.isEmpty()) {
                    Collections.reverse(stackAsList);
                    isHierachical = true;
                    tcNode = this.getNodeFromStack(stackAsList, binding, dummyPortMap);
                    newParent = tcNode != null ? new TCWrapperAdapter(tcNode.parent) : null;
                    enclosingDesignOrInstance = stackAsList.get(0);
                } else if (enclosingWrapper != null) {
                    tcNode = enclosingWrapper.getRfElement(TCNode.class);
                    newParent = enclosingWrapper.getParent();
                    if (newParent != null) {
                        newParent.removeChild(enclosingWrapper);
                    }
                }
                if (tcNode == null) {
                    return false;
                }
                IDVTElementWrapper newNodeWrapper = TCUtils.buildDHElabMode(tcNode.getElementPath(), new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>(0), memory);
                if (newParent != null && newNodeWrapper != null) {
                    newParent.addChild(newNodeWrapper);
                }
                if (isHierachical && (binding instanceof IRfDesignElement || binding instanceof IRfInstanceElement) && (newNodeWrapper = DVTHyperlinkUtils.getInstance().findElementOfType(newNodeWrapper, enclosingDesignOrInstance)) == null) {
                    newNodeWrapper = TCUtils.buildDHElabMode(ElementPath.join(null, binding.getName()), new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>(0), memory);
                }
                if (newNodeWrapper == null) {
                    return false;
                }
                TCNode newNode = newNodeWrapper.getRfElement(TCNode.class);
                newNode.addHotSignal(field, TCOperation.DRIVE);
                TCPathPoint p = TCPathPoint.of(newNode, field, null);
                List<TCPathPoint> writers = TCUtils.getSignalWritersOrReaders2(TCOperation.DRIVE, p, p.node, null, true);
                if (writers == null || writers.isEmpty()) {
                    return false;
                }
                ArrayList<TCPathPoint> allWriters = new ArrayList<TCPathPoint>(writers);
                for (TCPathPoint writer : writers) {
                    List<TCPathPoint> secondStepWriters;
                    if (!(writer.signal instanceof HierarchicalElement) || (secondStepWriters = TCUtils.getSignalWritersOrReaders2(TCOperation.DRIVE, writer, writer.node, null, true)) == null || secondStepWriters.isEmpty()) continue;
                    allWriters.remove(writer);
                    allWriters.addAll(secondStepWriters);
                }
                this.writer = DVTHyperlinkUtils.getInstance().getFirstWriter(allWriters, file, editor.getDocument(), offset);
                if (this.writer == null) {
                    return false;
                }
                this.destinationFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, this.writer.statement.goToInfo.filePath);
                return true;
            }

            private TCNode getNodeFromStack(List<IRfNamedElement> stack, IRfNamedElement binding, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
                int end;
                if (stack == null || stack.isEmpty()) {
                    return null;
                }
                if (binding == null) {
                    return null;
                }
                IRfNamedElement root = stack.get(stack.size() - 1);
                boolean found = binding.getLocalMember(null, root.getName(), null) != null;
                TCNode tcNode = null;
                tcNode = found ? TCNode.of(binding, dummyPortMap) : TCNode.of(stack.get(stack.size() - 1), dummyPortMap);
                int i = end = found ? stack.size() - 1 : stack.size() - 2;
                while (i >= 0) {
                    IRfNamedElement elem = stack.get(i);
                    TCNode newNode = TCNode.of(elem, dummyPortMap);
                    if (elem instanceof IRfInstanceElement) {
                        newNode.setDesignHint(DesignUtils.getDesign(DesignUtils.DesignRequest.of(elem, true)));
                    }
                    tcNode.addChild(newNode);
                    tcNode = newNode;
                    --i;
                }
                return tcNode;
            }

            public String getTypeLabel() {
                return DVTHyperlinkMessages.jumpToAssignment;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.jumpToAssignment;
            }

            public IRegion getHyperlinkRegion() {
                return action.getHyperlinkRegion();
            }
        };
    }

    protected Map<IRfInstanceElement, Set<DummyPort>> getDummyPortMap() {
        return new IdentityHashMap<IRfInstanceElement, Set<DummyPort>>(0);
    }

    protected IDHNodeFactory<IDVTElementWrapper> getNodeFactory() {
        return new IDHNodeFactory<IDVTElementWrapper>(){
            private Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap;
            {
                this.dummyPortMap = DVTHyperlinkUtilsCommon.this.getDummyPortMap();
            }

            @Override
            public IDVTElementWrapper create(IRfNamedElement element) {
                TCNode node = TCNode.of(element, this.dummyPortMap);
                if (element instanceof IRfInstanceElement) {
                    node.setDesignHint(DesignUtils.getDesign(DesignUtils.DesignRequest.of(element, true)));
                }
                return new TCWrapperAdapter(node);
            }

            @Override
            public boolean allowEmptyGenerateBlocks() {
                return true;
            }
        };
    }

    public IDVTElementWrapper findElementOfType(IDVTElementWrapper treeRoot, IRfNamedElement type) {
        if (treeRoot == null) {
            return null;
        }
        ArrayDeque<IDVTElementWrapper> queue = new ArrayDeque<IDVTElementWrapper>();
        queue.add(treeRoot);
        IRfNamedElement typeDesign = type instanceof IRfDesignElement && ((IRfDesignElement)type).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE ? ((IRfBlockElement)type).getEntity() : type;
        while (!queue.isEmpty()) {
            IRfNamedElement designHint;
            IDVTElementWrapper node = (IDVTElementWrapper)queue.poll();
            TCNode tcNode = node.getRfElement(TCNode.class);
            IRfNamedElement iRfNamedElement = designHint = tcNode.designHint instanceof IRfDesignElement && ((IRfDesignElement)tcNode.designHint).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE ? ((IRfBlockElement)tcNode.designHint).getEntity() : tcNode.designHint;
            if (typeDesign.equals(tcNode.namedElement) || typeDesign.equals(designHint)) {
                return node;
            }
            if (!node.hasChildren()) continue;
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public IRegion getRegionOfHyperlink(IDocument document, int offset, boolean startFromOffset, IRfNamedElement signal) {
        Region lineInfo = null;
        try {
            if (offset > document.getLength()) {
                return new Region(0, 2);
            }
            int lineOfOffset = document.getLineOfOffset(offset);
            lineInfo = document.getLineInformation(lineOfOffset);
            int[] regionInLine = DVTFileUtils.getInstance().getIdentifierOffsetInLine(lineOfOffset + 1, signal.getName(), document, startFromOffset ? offset : -1);
            if (regionInLine[1] <= 0) {
                return lineInfo;
            }
            return new Region(regionInLine[0], regionInLine[1]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return lineInfo != null ? new Region(offset, 2) : lineInfo;
        }
    }

    protected abstract IRfNamedElement getEnclosingDesignOrInstance(IRfNamedElement var1, int var2, DVTEditor var3);

    protected abstract IRfNamedElementAndScope getNamedElementAndScope(int var1, DVTEditor var2);

    protected abstract IEditorPart openEditor(IFile var1) throws PartInitException;

    protected abstract IRfScopeElement getEnclosingScopeElement(DVTEditor var1, IEditorPart var2, TCPathPoint var3);
}

