/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkWrapper;
import ro.amiq.dvt.ui.editor.hyperlink.MultipleHyperlinksTableViewer;
import ro.amiq.dvt.ui.views.TextFilterObject;

public class MultipleHyperlinksDialog
extends PopupDialog {
    private LinkedHashMap<String, List<HyperlinkWrapper>> hyperlinkMap;
    private MultipleHyperlinksTableViewer hyperlinkActionsViewer;
    private Composite contentsComposite;
    private Composite hyperlinkTypesComposite;

    public MultipleHyperlinksDialog(List<HyperlinkWrapper> allLinks) {
        super(Utils.getActiveShell(), 0, true, false, false, false, false, null, null);
        this.initializeContent(allLinks);
    }

    private void initializeContent(List<HyperlinkWrapper> allLinks) {
        try {
            this.filterLinksCommonBase(allLinks);
            this.hyperlinkMap = new LinkedHashMap();
            for (HyperlinkWrapper link : allLinks) {
                String hyperlinkType = link.getLink().getHyperlinkText();
                List<HyperlinkWrapper> hyperlinkList = this.hyperlinkMap.get(hyperlinkType);
                if (hyperlinkList == null) {
                    this.hyperlinkMap.put(hyperlinkType, new ArrayList<HyperlinkWrapper>(Arrays.asList(link)));
                    continue;
                }
                hyperlinkList.add(link);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getDefault().getCursorLocation();
    }

    private void filterLinksCommonBase(List<HyperlinkWrapper> allLinks) throws PatternSyntaxException {
        int minLength = Integer.MAX_VALUE;
        ArrayList<String[]> textToBeFilteredList = new ArrayList<String[]>();
        for (HyperlinkWrapper link : allLinks) {
            String[] splitText = link.getElementLabel().split("\\.");
            textToBeFilteredList.add(splitText);
            if (splitText.length >= minLength) continue;
            minLength = splitText.length;
        }
        int firstExclusivePos = 0;
        int i = 0;
        while (i < minLength) {
            String removeCandidate = ((String[])textToBeFilteredList.get(0))[i];
            boolean shouldRemoveCandidate = true;
            for (String[] textToBeFiltered : textToBeFilteredList) {
                if (textToBeFiltered[i].equals(removeCandidate)) continue;
                shouldRemoveCandidate = false;
                break;
            }
            if (!shouldRemoveCandidate) {
                firstExclusivePos = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < allLinks.size()) {
            String[] textToBeFiltered = (String[])textToBeFilteredList.get(i);
            StringBuilder sb = new StringBuilder();
            int j = firstExclusivePos;
            while (j < textToBeFiltered.length) {
                sb.append(textToBeFiltered[j]).append(".");
                ++j;
            }
            allLinks.get(i).setElementLabel(sb.deleteCharAt(sb.length() - 1).toString());
            ++i;
        }
    }

    protected final Control createContents(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.contentsComposite);
        Dialog.applyDialogFont((Control)this.contentsComposite);
        this.createMainArea();
        return this.contentsComposite;
    }

    private void createMainArea() {
        Composite innerComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)innerComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).numColumns(2).applyTo(innerComposite);
        this.createHyperlinkTypesComposite(innerComposite);
        Composite rightComposite = new Composite(innerComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)rightComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(rightComposite);
        this.createHyperlinkActionsComposite(rightComposite);
        this.createOkCancelButtons(innerComposite);
        String defaultHyperlinkType = ((Button)this.hyperlinkTypesComposite.getChildren()[0]).getText();
        this.hyperlinkActionsViewer.initializeHyperlinkActionsList(defaultHyperlinkType);
    }

    private void createOkCancelButtons(Composite innerComposite) {
        new Label(innerComposite, 0);
        Composite subButtonsComposite = new Composite(innerComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)subButtonsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 5, 0).numColumns(2).equalWidth(true).applyTo(subButtonsComposite);
        Button cancelButton = new Button(subButtonsComposite, 8);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)cancelButton);
        cancelButton.setText("Cancel");
        cancelButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MultipleHyperlinksDialog.this.close();
            }
        });
        Button okButton = new Button(subButtonsComposite, 8);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)okButton);
        okButton.setText("OK");
        okButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MultipleHyperlinksDialog.this.goToHyperlink();
            }
        });
    }

    private void createHyperlinkTypesComposite(Composite composite) {
        this.hyperlinkTypesComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 128).applyTo((Control)this.hyperlinkTypesComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.hyperlinkTypesComposite);
        for (final String hyperlinkType : this.hyperlinkMap.keySet()) {
            Button hyperlinkTypeButton = new Button(this.hyperlinkTypesComposite, 16);
            hyperlinkTypeButton.setText(hyperlinkType);
            hyperlinkTypeButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    MultipleHyperlinksDialog.this.hyperlinkActionsViewer.initializeHyperlinkActionsList(hyperlinkType);
                }
            });
        }
        Button firstType = (Button)this.hyperlinkTypesComposite.getChildren()[0];
        firstType.setSelection(true);
    }

    private void createHyperlinkActionsComposite(Composite innerComposite) {
        Composite hyperlinkActionsComposite = new Composite(innerComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)hyperlinkActionsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(hyperlinkActionsComposite);
        this.hyperlinkActionsViewer = new MultipleHyperlinksTableViewer(this.hyperlinkMap, hyperlinkActionsComposite, 772);
        GridDataFactory.fillDefaults().grab(false, false).applyTo(this.hyperlinkActionsViewer.getControl());
        TextFilterObject textFilterObject = new TextFilterObject(this.hyperlinkActionsViewer, "", hyperlinkActionsComposite, "", false);
        textFilterObject.getControl().moveAbove(this.hyperlinkActionsViewer.getControl());
    }

    private void goToHyperlink() {
        ISelection selection = this.hyperlinkActionsViewer.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        Object element = ((StructuredSelection)selection).getFirstElement();
        if (!(element instanceof HyperlinkWrapper)) {
            return;
        }
        ((HyperlinkWrapper)element).getLink().open();
        this.close();
    }

    protected Control getFocusControl() {
        return this.contentsComposite;
    }

    public int open() {
        int result = super.open();
        Shell shell = this.getShell();
        if (shell != null) {
            shell.forceActive();
        }
        return result;
    }

    public boolean close() {
        this.hyperlinkMap = null;
        this.hyperlinkActionsViewer = null;
        this.hyperlinkTypesComposite.dispose();
        this.hyperlinkTypesComposite = null;
        this.contentsComposite.dispose();
        this.contentsComposite = null;
        return super.close();
    }
}

