/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkWrapper;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class MultipleHyperlinksTableViewer
extends TableViewer
implements IFilterableView {
    private HashMap<String, List<HyperlinkWrapper>> hyperlinkMap;
    private List<HyperlinkWrapper> currentActionList;

    public MultipleHyperlinksTableViewer(HashMap<String, List<HyperlinkWrapper>> hyperlinkMap, Composite parent, int style) {
        super(parent, style);
        super.setLabelProvider((IBaseLabelProvider)new ElemLabelProvider());
        super.setContentProvider((IContentProvider)new ElemContentProvider());
        this.hyperlinkMap = hyperlinkMap;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
    }

    @Override
    public void setFocusOnTree(String treeId) {
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        this.filterActions(text);
        return null;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
    }

    private void filterActions(String text) {
        if (this.currentActionList == null) {
            return;
        }
        if (text == null || text.isEmpty()) {
            super.setInput(this.currentActionList);
            this.getTable().select(0);
            return;
        }
        StringMatcher localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(text, true, false);
        ArrayList<HyperlinkWrapper> hyperlinkActionsList = new ArrayList<HyperlinkWrapper>();
        for (HyperlinkWrapper pVlogLink : this.currentActionList) {
            String elementLabel = pVlogLink.getElementLabel();
            if (!ViewsUtils.matchCamelCaseOrRegex(localMatcher, elementLabel)) continue;
            hyperlinkActionsList.add(pVlogLink);
        }
        super.setInput(hyperlinkActionsList);
        this.getTable().select(0);
    }

    public void initializeHyperlinkActionsList(String defaultSelectedHyperlinkLabel) {
        this.currentActionList = this.hyperlinkMap.get(defaultSelectedHyperlinkLabel);
        super.setInput(this.currentActionList);
        this.getTable().select(0);
    }

    private static class ElemContentProvider
    implements ITreeContentProvider {
        private ElemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof List)) {
                return null;
            }
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private static class ElemLabelProvider
    extends LabelProvider {
        private ElemLabelProvider() {
        }

        public String getText(Object linkWrapper) {
            if (!(linkWrapper instanceof HyperlinkWrapper)) {
                return "";
            }
            IRfNamedElement element = ((HyperlinkWrapper)linkWrapper).getHyperlinkAction().getRfNamedElement();
            String label = ((HyperlinkWrapper)linkWrapper).getElementLabel();
            if (!(element instanceof IRfBlockElement)) {
                return label;
            }
            if (((IRfBlockElement)element).getKind() != IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                return label;
            }
            return this.getArchLabel(label);
        }

        private String getArchLabel(String label) {
            String[] splitText;
            block4: {
                splitText = label.split("\\.");
                if (splitText.length >= 2) break block4;
                return "";
            }
            try {
                StringBuilder archLabel = new StringBuilder();
                int i = 0;
                while (i < splitText.length - 2) {
                    archLabel.append(splitText[i]).append(".");
                    ++i;
                }
                archLabel.append(splitText[splitText.length - 1]).append(" of ").append(splitText[splitText.length - 2]);
                return archLabel.toString();
            }
            catch (PatternSyntaxException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }

        public Image getImage(Object linkWrapper) {
            if (!(linkWrapper instanceof HyperlinkWrapper)) {
                return null;
            }
            return ((HyperlinkWrapper)linkWrapper).getElementImage();
        }
    }
}

