/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.lazy.outline;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.editor.lazy.outline.ILazyOutlineModel;
import ro.amiq.dvt.ui.editor.lazy.outline.LazyOutlineASTModel;
import ro.amiq.dvt.ui.editor.lazy.outline.LazyOutlineModel;
import ro.amiq.dvt.ui.editor.lazy.outline.LazyOutlineTestUtils;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.DVTHelpListener;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewManagerCommon;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.MenuCommandInstaller;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEventType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class DVTLazyOutlinePage
extends ContentOutlinePage
implements IDVTLazyView,
IFilterableView,
IRfFilterableTreeAccessor {
    public static final String ID = "org.eclipse.ui.views.ContentOutline";
    public static final String TEXT_FILTER_SWTBOT_ID = String.valueOf(DVTLazyOutlinePage.class.getCanonicalName()) + ".textFilterSWTBotId";
    private static final Set<LanguageKind> LANGUAGES_WITH_AST = EnumSet.of(LanguageKind.E, LanguageKind.PSS, LanguageKind.SLN);
    private LazyTree lazyTree;
    protected ILazyOutlineModel model;
    protected DVTEditor editor;
    public AbstractLazyOutlineProvider provider;
    private IBuildEventManagerListener buildListener;
    protected IPropertyChangeListener propertyChangeListener;
    private Composite childComposite;
    protected Action cancelAction;
    protected Action categorySelectAction;
    protected Action lexicalSortingAction;
    protected Action categorySortingAction;
    private Map<String, TextFilterObject> textFilters;
    protected Composite parent;
    private Composite textBoxComposite;
    private Text selectRootTextBox;
    private Label contentFiltersLabel;
    private Image contentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image contentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    private LazyOutlineTestUtils testUtils;
    private boolean isDirty;
    public static final String OUTLINE_DIALOG_TITLE = "Outline Element Filters";
    public static final String DEFAULT_FILTER_ID = "default-filter";
    public static final String DEFAULT_TREE_ID = "default-tree";

    protected DVTLazyOutlinePage(DVTEditor editor) {
        this.textFilters = new HashMap<String, TextFilterObject>();
        this.editor = editor;
        this.testUtils = new LazyOutlineTestUtils(this);
        this.buildListener = this.createBuildListener();
        BuildEventManager.getInstance().registerListener(this.buildListener);
    }

    private IBuildEventManagerListener createBuildListener() {
        return new IBuildEventManagerListener(){

            @Override
            public void notifyCleanBuild(IProject project) {
                if (DVTLazyOutlinePage.this.editor == null) {
                    return;
                }
                if (project != DVTLazyOutlinePage.this.editor.getProject() || DVTLazyOutlinePage.this.model == null) {
                    return;
                }
                DVTLazyOutlinePage.this.model.clearCache();
                DVTLazyOutlinePage.this.swapToMessageComposite();
            }

            @Override
            public void notifyFullBuild(IProject project) {
                if (DVTLazyOutlinePage.this.editor == null) {
                    return;
                }
                if (project != DVTLazyOutlinePage.this.editor.getProject()) {
                    return;
                }
                DVTLazyOutlinePage.this.doUpdate(true);
            }

            @Override
            public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
                if (DVTLazyOutlinePage.this.editor == null) {
                    return;
                }
                if (project != DVTLazyOutlinePage.this.editor.getProject()) {
                    return;
                }
                DVTLazyOutlinePage.this.doUpdate(false);
            }
        };
    }

    protected IPropertyChangeListener createPropertyChangeListener() {
        return event -> {
            if (event.getProperty().equals("outline.prefs_changed")) {
                this.doUpdate(false);
            }
        };
    }

    public void createControl(Composite parent) {
        if (this.textFilters == null) {
            this.textFilters = new HashMap<String, TextFilterObject>();
        }
        if (this.provider == null) {
            this.provider = this.createOutlineProvider();
        }
        if (this.buildListener == null) {
            this.buildListener = this.createBuildListener();
            BuildEventManager.getInstance().registerListener(this.buildListener);
        }
        this.model = (ILazyOutlineModel)this.getModel(IModel.class);
        parent.addHelpListener((HelpListener)DVTHelpListener.getInstance());
        this.parent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        lazyTree.setLabelProvider(this.getLabelProvider(), true);
        this.childComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.childComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.childComposite.setLayout((Layout)layout);
        Composite filterComposite = new Composite(this.childComposite, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterLayout.verticalSpacing = 0;
        GridData filterData = new GridData(4, 0x1000000, true, false);
        filterComposite.setLayout((Layout)filterLayout);
        filterComposite.setLayoutData((Object)filterData);
        this.contentFiltersLabel = new Label(filterComposite, 0);
        GridData indicationGridData = new GridData(16384, 0x1000000, false, false);
        indicationGridData.horizontalIndent = 5;
        this.contentFiltersLabel.setLayoutData((Object)indicationGridData);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(this.model.hasContentFilteredElements() ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
        } else {
            this.contentFiltersLabel.setImage(this.contentFiltersEnabledIcon);
        }
        this.contentFiltersLabel.setToolTipText("Content Filters matched!");
        this.contentFiltersLabel.setEnabled(this.model.hasContentFilteredElements());
        this.createTextFilter(DEFAULT_FILTER_ID, filterComposite, DEFAULT_TREE_ID, false);
        TextFilterObject filter = this.getTextFilterObject(DEFAULT_FILTER_ID);
        filter.setTextFilterMessage("Filter by: name");
        filter.setTextFilterSWTBotId(TEXT_FILTER_SWTBOT_ID);
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                DVTLazyOutlinePage.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        lazyTree.setSearchBar(filter);
        lazyTree.install(this.childComposite);
        lazyTree.getTree().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                DVTLazyOutlinePage.this.gotoSelectedElement(DVTLazyOutlinePage.DEFAULT_TREE_ID);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        lazyTree.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    DVTLazyOutlinePage.this.gotoSelectedElement(DVTLazyOutlinePage.DEFAULT_TREE_ID);
                }
            }
        });
        lazyTree.getTree().addListener(13, event -> this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection())));
        lazyTree.getTree().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                DVTLazyOutlinePage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)DVTLazyOutlinePage.this, DVTLazyOutlinePage.this.getSelection()));
            }
        });
        MenuCommandInstaller.installContextMenu((IPageBookViewPage)this, (Control)this.getLazyTree().getTree());
    }

    public Control getControl() {
        return this.childComposite;
    }

    protected TextFilterObject getTextFilterObject(String textFilterId) {
        if (textFilterId == null) {
            return null;
        }
        if (this.textFilters == null) {
            return null;
        }
        return this.textFilters.get(textFilterId);
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
        if (treeIterator == null) {
            return;
        }
        treeIterator.addStateListener(event -> {
            if (event.getEventType() != TreeIteratorEventType.UPDATE_GUI_FILTERED_INDICATION) {
                return;
            }
            Display.getDefault().asyncExec(() -> {
                if (this.model == null || this.contentFiltersLabel == null) {
                    return;
                }
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.contentFiltersLabel.setImage(this.model.hasContentFilteredElements() ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
                }
                this.contentFiltersLabel.setEnabled(this.model.hasContentFilteredElements());
            });
        });
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts) {
        this.createTextFilter(textFilterId, parent, treeId, searchForPorts, null);
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts, List<String> quickSearchPreferences) {
        this.textFilters.put(textFilterId, new TextFilterObject(this, textFilterId, parent, treeId, searchForPorts, quickSearchPreferences));
    }

    @Override
    public LazyTree getLazyTree() {
        return this.lazyTree;
    }

    public void setLazyTree(LazyTree lazyTree) {
        this.lazyTree = lazyTree;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_OUTLINE;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
        if (this.cancelAction == null) {
            return;
        }
        this.cancelAction.setEnabled(enabled);
    }

    @Override
    public final void createToolBar() {
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.createLanguageSpecificActions();
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        if (this.categorySelectAction != null) {
            toolBarManager.add((IAction)this.categorySelectAction);
            toolBarManager.add((IContributionItem)new Separator());
        }
        if (this.lexicalSortingAction != null) {
            toolBarManager.add((IAction)this.lexicalSortingAction);
        }
        if (this.categorySortingAction != null) {
            toolBarManager.add((IAction)this.categorySortingAction);
        }
        if (this.lexicalSortingAction != null || this.categorySelectAction != null) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        toolBarManager.add((IAction)new ExpandAllAction(this.lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(this.lazyTree));
        toolBarManager.update(true);
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (modelClass != IModel.class) {
            return null;
        }
        if (this.switchModels()) {
            this.clean();
        }
        if (this.editor == null) {
            return null;
        }
        if (this.provider == null) {
            this.provider = this.createOutlineProvider();
        }
        if (this.model == null) {
            this.model = this.isShowAST() ? new LazyOutlineASTModel(this.provider) : new LazyOutlineModel(this.provider, this);
        }
        return this.model;
    }

    private void clean() {
        if (this.model != null) {
            this.model.clean();
        }
        if (this.provider != null) {
            this.provider.clean();
        }
        if (this.lazyTree != null) {
            this.lazyTree.doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(this.getObjection()));
        }
        this.model = null;
        this.provider = null;
    }

    @Override
    public Objection getObjection() {
        return Objection.OUTLINE;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        try {
            if (this.editor == null) {
                return;
            }
            TreePath selection = this.lazyTree.getSelection();
            if (selection == null) {
                return;
            }
            Object element = selection.getElement();
            if (element == null) {
                return;
            }
            int line = -1;
            if (element instanceof IRfDefElement) {
                line = ((IRfDefElement)element).getStartLine();
            } else if (element instanceof IDVTElementWrapper && ((IDVTElementWrapper)element).getRfElement() instanceof AST) {
                line = ((AST)((IDVTElementWrapper)element).getRfElement()).getLine();
            } else {
                return;
            }
            line = line == 0 ? 0 : line - 1;
            IDocument document = this.editor.getDocument();
            if (document == null) {
                return;
            }
            this.editor.selectAndReveal(document.getLineOffset(line), document.getLineLength(line));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public Object getEditor() {
        return this.editor;
    }

    public void setEditor(DVTEditor editor) {
        this.editor = editor;
    }

    public void update(boolean force) {
        this.doUpdate(force);
    }

    protected void doUpdate(boolean isResetTop) {
        if (this.lazyTree == null) {
            return;
        }
        if (this.model == null || this.switchModels()) {
            this.model = (ILazyOutlineModel)this.getModel(IModel.class);
        }
        if (this.model != null) {
            this.model.clearCache();
        }
        this.lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.getModel(IModel.class), false, isResetTop, true, this.getObjection()));
    }

    private boolean switchModels() {
        boolean showAST = this.isShowAST();
        if (this.model instanceof LazyOutlineModel && showAST) {
            return true;
        }
        return this.model instanceof LazyOutlineASTModel && !showAST;
    }

    @Override
    public void setFocusOnTree(String treeId) {
        this.lazyTree.getTree().setFocus();
    }

    @Override
    public void swapToMessageComposite() {
        Display.getDefault().syncExec(() -> {
            LazyTree lazyTree = this.getLazyTree();
            if (lazyTree == null) {
                return;
            }
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            if (this.textBoxComposite == null || this.textBoxComposite.isDisposed() || this.selectRootTextBox == null || this.selectRootTextBox.isDisposed()) {
                this.textBoxComposite = new Composite(stackComposite, 16);
                GridLayout textBox = new GridLayout();
                textBox.marginBottom = 0;
                textBox.marginHeight = 0;
                textBox.marginLeft = 0;
                textBox.marginRight = 0;
                textBox.marginTop = 0;
                textBox.marginWidth = 0;
                this.textBoxComposite.setLayout((Layout)textBox);
                GridData textBoxCompositeGridData = new GridData(4, 4, true, true);
                this.textBoxComposite.setLayoutData((Object)textBoxCompositeGridData);
                this.selectRootTextBox = new Text(this.textBoxComposite, 74);
                GridData textBoxGridData = new GridData(4, 4, true, true);
                this.selectRootTextBox.setLayoutData((Object)textBoxGridData);
            }
            this.selectRootTextBox.setText(this.getMessageText());
            ((StackLayout)layout).topControl = this.textBoxComposite;
            stackComposite.layout();
        });
    }

    @Override
    public String getMessageText() {
        if (!this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilterText().isEmpty()) {
            if (this.model.hasSearchedElementContentFiltered()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            if (this.model.hasSearchedElementPreferenceFiltered()) {
                return LazyTreeMessageCompositeType.OUTLINE_ELEMENT_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.model.hasPreferenceFilteredElements()) {
            return LazyTreeMessageCompositeType.OUTLINE_ELEMENT_FILTERED.getMessage();
        }
        if (this.model.hasContentFilteredElements()) {
            return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public void swapToTreeComposite() {
        Display.getDefault().syncExec(() -> {
            LazyTree lazyTree = this.getLazyTree();
            if (lazyTree == null) {
                return;
            }
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            ((StackLayout)layout).topControl = lazyTree.getTableAndTreeComposite();
            stackComposite.layout();
        });
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.lazyTree.doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.getModel(IModel.class), this.getObjection()));
    }

    @Override
    public IProject getProject() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getProject();
    }

    public ISelection getSelection() {
        if (this.lazyTree == null) {
            return null;
        }
        ArrayList<IDVTElementWrapper> list = new ArrayList<IDVTElementWrapper>();
        TreeItem[] treeItemArray = this.lazyTree.getTreeItemSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem i = treeItemArray[n2];
            if (i.getData() != null && (data = i.getData()) instanceof TreePath) {
                Object element = ((TreePath)data).getElement();
                IDVTElementWrapper wrapper = element instanceof IDVTElementWrapper ? (IDVTElementWrapper)element : new DVTTreeElementWrapper(element);
                wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, data);
                wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TO_STRING, this.getLabelProvider().getText(data));
                list.add(wrapper);
            }
            ++n2;
        }
        return new StructuredSelection(list.toArray());
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    @Override
    public void selectionChanged() {
    }

    public Comparator<TreePath> getComparator() {
        if (this.model == null) {
            return null;
        }
        return this.model.getComparator();
    }

    @Override
    public boolean isFiltered() {
        List<GUIFilter> guiFilters = DVTViewManagerCommon.getGuiFilters(this.getProject(), ViewSet.ViewName.OUTLINE);
        return guiFilters != null && !guiFilters.isEmpty();
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.provider.getLabelProvider();
    }

    public void dispose() {
        this.cancelAction = null;
        this.categorySelectAction = null;
        this.categorySortingAction = null;
        this.lexicalSortingAction = null;
        this.textFilters = null;
        if (this.lazyTree != null) {
            this.lazyTree.cancelOperations();
            this.lazyTree.doAction(LazyTreeAction.CLEAR_CACHE, new LazyTreeActionArguments(this.getObjection()));
        }
        this.lazyTree = null;
        this.testUtils = null;
        if (this.model != null) {
            this.model.clean();
        }
        if (this.provider != null) {
            this.provider.clean();
        }
        this.model = null;
        this.provider = null;
        if (this.buildListener != null) {
            BuildEventManager.getInstance().unregisterListener(this.buildListener);
        }
        this.buildListener = null;
        this.editor = null;
        super.dispose();
    }

    public Label testGetContentFiltersLabel() {
        return this.contentFiltersLabel;
    }

    protected abstract AbstractLazyOutlineProvider createOutlineProvider();

    protected abstract void createLanguageSpecificActions();

    @Override
    public ILazyTreeTestUtils getLazyTreeTestUtils() {
        return this.testUtils;
    }

    private boolean isShowAST() {
        State state;
        block12: {
            ParameterizedCommand actualCommand;
            block11: {
                ICommandService commandService;
                block10: {
                    block9: {
                        block8: {
                            if (this.editor != null) break block8;
                            return false;
                        }
                        if (LANGUAGES_WITH_AST.contains((Object)this.editor.getLanguageKind())) break block9;
                        return false;
                    }
                    commandService = (ICommandService)Utils.getActiveWorkbenchWindow().getService(ICommandService.class);
                    if (commandService != null) break block10;
                    return false;
                }
                actualCommand = ParameterizedCommand.generateCommand((Command)commandService.getCommand("ro.amiq.dvt.testutilities.EOutlineShowASTHandler"), null);
                if (actualCommand != null) break block11;
                return false;
            }
            state = actualCommand.getCommand().getState("org.eclipse.ui.commands.toggleState");
            if (state != null) break block12;
            return false;
        }
        try {
            if (state.getValue() instanceof Boolean) {
                return (Boolean)state.getValue();
            }
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
        return false;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.getLabelProvider();
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject(DEFAULT_FILTER_ID);
        if (textFilterObject == null) {
            return new StringMatcher[0];
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject(DEFAULT_FILTER_ID);
        if (textFilterObject == null) {
            return new boolean[0];
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    public String getTreeSearchPort() {
        TextFilterObject textFilterObject = this.getTextFilterObject(DEFAULT_FILTER_ID);
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }
}

