/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.lazy.outline;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.editor.lazy.outline.ILazyOutlineModel;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class LazyOutlineASTModel
implements ILazyOutlineModel {
    private AbstractLazyOutlineProvider provider;
    protected Comparator<TreePath> comparator;

    public LazyOutlineASTModel(AbstractLazyOutlineProvider provider) {
        this.provider = provider;
        this.comparator = new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                if (o1 == o2) {
                    return 0;
                }
                IDVTElementWrapper wrapper1 = (IDVTElementWrapper)o1.getElement();
                IDVTElementWrapper wrapper2 = (IDVTElementWrapper)o2.getElement();
                AST ast1 = (AST)wrapper1.getRfElement();
                AST ast2 = (AST)wrapper2.getRfElement();
                if (ast1.getOffset() == ast2.getOffset()) {
                    if (ast1.getOffset() == 0) {
                        int[] indices1 = o1.getIndices();
                        int[] indices2 = o2.getIndices();
                        int i = 0;
                        while (i < indices1.length && i < indices2.length) {
                            if (indices1[i] - indices2[i] != 0) {
                                return indices1[i] - indices2[i];
                            }
                            ++i;
                        }
                        return indices1.length - indices2.length;
                    }
                    if (ast1.getText().equals(ast2.getText())) {
                        return o1.getIndexInParent() - o2.getIndexInParent();
                    }
                    return ast1.getText().compareTo(ast2.getText());
                }
                return ast1.getOffset() - ast2.getOffset();
            }
        };
    }

    @Override
    public List<TreePath> getChildren(TreePath segments, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (segments == null) {
            return null;
        }
        AST ast = null;
        IDVTElementWrapper root = null;
        if (segments == TreePath.TOP_DUMMY_TREE_PATH) {
            root = this.provider.createElementTreeWrapper(this.provider.getFileDef());
            ast = this.provider.getRootAST();
        } else {
            root = (IDVTElementWrapper)segments.getElement();
            ast = (AST)root.getRfElement();
        }
        if (ast == null || root == null) {
            return null;
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        HashSet<TreePath> uniques = new HashSet<TreePath>();
        AST firstChild = ast.getFirstChild();
        if (firstChild != null) {
            AST nextSibling = firstChild;
            do {
                IDVTElementWrapper nextSiblingwrapper = this.provider.createElementTreeWrapper(nextSibling);
                root.addChild(nextSiblingwrapper);
                TreePath child = TreePath.child(segments, nextSibling.getText(), result.size(), this.getComparator());
                child.setElement(nextSiblingwrapper);
                if (uniques.contains(child)) {
                    child.append("@(" + result.size() + ")@");
                }
                result.add(child);
                uniques.add(child);
            } while ((nextSibling = nextSibling.getNextSibling()) != null);
        }
        return result;
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        if (!this.hasChildren(currentPath, monitor).booleanValue()) {
            return currentPath;
        }
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl9
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl9:
            // 2 sources

            ** while (this.hasChildren((TreePath)currentPath, (IProgressMonitor)monitor).booleanValue() && children != null && !children.isEmpty())
        }
lbl10:
        // 1 sources

        return currentPath;
    }

    @Override
    public Comparator<TreePath> getComparator() {
        return this.comparator;
    }
}

