/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.lazy.outline;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.editor.lazy.outline.LazyOutlineModel;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class LazyOutlineCache {
    AbstractLazyOutlineProvider provider;
    private LazyOutlineModel model;
    private Comparator<TreePath> comparator;
    private Map<TreePath, List<TreePath>> childrenCache = new LinkedHashMap<TreePath, List<TreePath>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<TreePath, List<TreePath>> eldest) {
            return this.size() > 15000;
        }
    };
    private boolean hasContentFilteredElements;
    private boolean hasPreferenceFilteredElements;
    private boolean hasSearchedElementContentFiltered;
    private boolean hasSearchedElementPreferenceFiltered;

    public LazyOutlineCache(LazyOutlineModel model, AbstractLazyOutlineProvider provider) {
        this.model = model;
        this.provider = provider;
        this.comparator = (o1, o2) -> {
            if (o1 == null || o2 == null) {
                return 0;
            }
            IRfDefElement def1 = (IRfDefElement)o1.getElement();
            IRfDefElement def2 = (IRfDefElement)o2.getElement();
            String text1 = provider.getLabelProvider().getText(o1);
            String text2 = provider.getLabelProvider().getText(o2);
            if (text1 == null || text2 == null) {
                return 0;
            }
            if (provider.isCategoricallySorted()) {
                int cat1 = provider.getCategory(def1);
                int cat2 = provider.getCategory(def2);
                if (o1.getParent().equals(o2.getParent()) && cat1 != cat2) {
                    return cat1 - cat2;
                }
            }
            int offsetDiff = def1.getStartOffset() - def2.getStartOffset();
            int[] inds1 = o1.getIndices();
            int[] inds2 = o2.getIndices();
            if (provider.isLexicallySorted()) {
                if (o1.getParent().equals(o2.getParent())) {
                    if (text1.equals(text2)) {
                        return offsetDiff;
                    }
                    return text1.compareTo(text2);
                }
                int i = 0;
                while (i < Math.min(inds1.length, inds2.length)) {
                    if (inds1[i] != inds2[i]) {
                        return inds1[i] - inds2[i];
                    }
                    ++i;
                }
                return offsetDiff;
            }
            int i = 0;
            while (i < Math.min(inds1.length, inds2.length)) {
                if (inds1[i] != inds2[i]) {
                    return inds1[i] - inds2[i];
                }
                ++i;
            }
            if (offsetDiff != 0) {
                return offsetDiff;
            }
            return text1.compareTo(text2);
        };
    }

    private void put(TreePath path, List<TreePath> children) {
        if (path == null || "...".equals(path.getLastSegment())) {
            return;
        }
        if (children == null || children.isEmpty()) {
            return;
        }
        this.childrenCache.put(path, children);
    }

    public List<TreePath> get(TreePath path, IRfFilterableTreeAccessor view, IProgressMonitor monitor, int startIndex, int endIndex) {
        List<TreePath> children = this.childrenCache.get(path);
        if (children == null) {
            children = this.computeChildren(path, view, monitor);
            this.put(path, children);
        }
        if (children == null || children.isEmpty()) {
            return null;
        }
        if (endIndex > children.size()) {
            endIndex = children.size();
        }
        if (startIndex == 0 && endIndex == children.size()) {
            return children;
        }
        return children.subList(startIndex, endIndex);
    }

    public void clear() {
        this.childrenCache.clear();
        this.hasContentFilteredElements = false;
        this.hasPreferenceFilteredElements = false;
        this.hasSearchedElementContentFiltered = false;
        this.hasSearchedElementPreferenceFiltered = false;
    }

    private List<TreePath> computeChildren(TreePath path, IRfFilterableTreeAccessor view, IProgressMonitor monitor) {
        if (path == null) {
            return null;
        }
        if (!(path.getElement() instanceof IRfDefElement) && path != TreePath.TOP_DUMMY_TREE_PATH) {
            return null;
        }
        Collection<?> childrenDefs = null;
        if (path == TreePath.TOP_DUMMY_TREE_PATH) {
            IRfFileDef fileDef = this.provider.getFileDef();
            if (fileDef == null) {
                return null;
            }
            childrenDefs = fileDef.getChildren();
        } else {
            IRfDefElement root = (IRfDefElement)path.getElement();
            childrenDefs = this.provider.getChildren(root);
        }
        if (childrenDefs == null || childrenDefs.isEmpty()) {
            return null;
        }
        boolean isSorted = this.shouldBeSorted(childrenDefs);
        AbstractCollection childrenTreePath = null;
        childrenTreePath = isSorted ? new TreeSet<TreePath>(this.comparator) : new ArrayList();
        this.addChildrenInternal(path, childrenDefs, view, childrenTreePath, monitor);
        if (isSorted) {
            int index = 0;
            ArrayList<TreePath> sortedChildrenTreePath = new ArrayList<TreePath>();
            for (TreePath childPath : childrenTreePath) {
                int[] indices = childPath.getIndices();
                indices[indices.length - 1] = index++;
                sortedChildrenTreePath.add(childPath);
            }
            return sortedChildrenTreePath;
        }
        return childrenTreePath;
    }

    private void addChildrenInternal(TreePath path, Collection<?> children, IRfFilterableTreeAccessor view, Collection<TreePath> result, IProgressMonitor monitor) {
        if (children == null || children.isEmpty()) {
            return;
        }
        HashSet<TreePath> uniques = new HashSet<TreePath>();
        for (Object child : children) {
            DVTGUIFilterMatcher.GUIFilterResult filterResult;
            IRfDefElement def;
            if (monitor != null && monitor.isCanceled()) break;
            if (!(child instanceof IRfDefElement) || (def = (IRfDefElement)child).getChildren() == children || !this.provider.isOutlineElement(def) && !this.provider.isUnnamedBlock(def)) continue;
            if (this.provider.isUnnamedBlock(def)) {
                this.addChildrenInternal(path, def.getChildren(), view, result, monitor);
                continue;
            }
            TreePath childPath = TreePath.child(path, def.getName(), result.size(), this.comparator);
            childPath.setElement(def);
            if (uniques.contains(childPath)) {
                childPath.append("@(" + result.size() + ")@");
            }
            if ((filterResult = this.provider.getFilterResult(def)) != null && filterResult.ordinal() >= DVTGUIFilterMatcher.GUIFilterResult.PREDEFINED.ordinal()) {
                if (!this.hasSearchedElementContentFiltered && ViewsUtils.matchesPath(new DVTTreeElementWrapper(def), view)) {
                    this.hasSearchedElementContentFiltered = true;
                }
                this.hasContentFilteredElements = true;
                continue;
            }
            boolean isVisible = true;
            if (filterResult == DVTGUIFilterMatcher.GUIFilterResult.PREFERENCE) {
                if (!this.hasSearchedElementContentFiltered && ViewsUtils.matchesPath(new DVTTreeElementWrapper(def), view)) {
                    this.hasSearchedElementPreferenceFiltered = true;
                }
                this.hasPreferenceFilteredElements = true;
                isVisible = this.model.hasChildren(childPath, monitor);
            }
            if (!isVisible) continue;
            result.add(childPath);
            uniques.add(childPath);
        }
        uniques = null;
    }

    public boolean hasContentFilteredElements() {
        return this.hasContentFilteredElements;
    }

    public boolean hasPreferenceFilteredElements() {
        return this.hasPreferenceFilteredElements;
    }

    public boolean hasSearchedElementContentFiltered() {
        return this.hasSearchedElementContentFiltered;
    }

    public boolean hasSearchedElementPreferenceFiltered() {
        return this.hasSearchedElementPreferenceFiltered;
    }

    private boolean shouldBeSorted(Collection<?> children) {
        return children.size() <= 1000 && (this.provider.isLexicallySorted() || this.provider.isCategoricallySorted());
    }

    public Comparator<TreePath> getComparator() {
        return this.comparator;
    }

    public void clean() {
        this.childrenCache = null;
        this.comparator = null;
        this.provider = null;
    }
}

