/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.lazy.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.editor.lazy.outline.ILazyOutlineModel;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.utils.DVTStringUtil;

@ForTestingOrDebuggingOnly
public class LazyOutlineTestUtils
implements ILazyTreeTestUtils {
    private IDVTLazyView view;

    public LazyOutlineTestUtils(IDVTLazyView view) {
        this.view = view;
    }

    @Override
    public IDVTLazyView getLazyView() {
        return this.view;
    }

    public IModel getModel() {
        return (IModel)this.view.getModel(IModel.class);
    }

    @Override
    public boolean selectInLazyTree(String name, int num) {
        TreePath searchedPath = null;
        LazyTree lazyTree = this.getLazyView().getLazyTree();
        for (TreePath path : lazyTree.getViewContent()) {
            String instanceName = path.getLastSegment();
            if (instanceName == null || !instanceName.equals(name)) continue;
            searchedPath = path;
            break;
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + name);
        }
        Tree tree = lazyTree.getTree();
        if (tree == null) {
            return false;
        }
        TreeItem[] treeItems = tree.getItems();
        TreeItem selection = null;
        String[] stringArray = searchedPath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            selection = null;
            TreeItem[] treeItemArray = treeItems;
            int n3 = treeItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem candidate = treeItemArray[n4];
                Object data = candidate.getData();
                if (!(data instanceof TreePath)) {
                    return false;
                }
                if (((TreePath)data).getLastSegment().equals(segment)) {
                    treeItems = candidate.getItems();
                    selection = candidate;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (selection == null) {
            throw new RuntimeException("Unable to select non-existing node " + DVTStringUtil.join(searchedPath.getSegments(), "/"));
        }
        tree.setSelection(selection);
        lazyTree.testSetSelection(searchedPath);
        tree.showSelection();
        tree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        return true;
    }

    @Override
    public Objection getObjection() {
        return this.view.getObjection();
    }

    public List<IDVTElementWrapper> testGetWrapperData() {
        return this.testGetWrapperDataInteral(TreePath.TOP_DUMMY_TREE_PATH);
    }

    private List<IDVTElementWrapper> testGetWrapperDataInteral(TreePath path) {
        ILazyOutlineModel model = (ILazyOutlineModel)this.view.getModel(IModel.class);
        if (!model.hasChildren(path, null).booleanValue()) {
            return Collections.emptyList();
        }
        List<TreePath> children = model.getChildren(path, 0, Integer.MAX_VALUE, null);
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (TreePath child : children) {
            DVTTreeElementWrapper wrapper = new DVTTreeElementWrapper(child.getElement());
            if (model.hasChildren(child, null).booleanValue()) {
                ((IDVTElementWrapper)wrapper).addChildren(this.testGetWrapperDataInteral(child));
            }
            result.add(wrapper);
        }
        return result;
    }
}

