/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.lazy.outline;

import antlr.collections.AST;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.editor.lazy.outline.ILazyOutlineModel;
import ro.amiq.dvt.ui.editor.lazy.outline.LazyOutlineModel;
import ro.amiq.dvt.ui.editor.lazy.outline.LazyOutlineTestUtils;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class QuickLazyOutlineView
extends DVTQuickLazyView
implements IRfFilterableTreeAccessor {
    private static final String TITLE = "Quick Outline";
    private static final String ID = "ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView";
    private LazyOutlineModel model;
    protected AbstractLazyOutlineProvider provider;
    protected DVTEditor editor;
    protected IAction categorySelectAction;
    protected IAction lexicalSortingAction;
    protected IAction categorySortingAction;
    private LazyOutlineTestUtils lazyTreeTestUtils = new LazyOutlineTestUtils(this);
    protected IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("outline.prefs_changed")) {
            this.update();
        }
    };

    protected QuickLazyOutlineView(DVTEditor editor) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 48, editor.getProject());
        this.editor = editor;
        if (this.provider != null) {
            this.provider.setEditor(editor);
        }
        this.setTextFilterMessage("default-filter", "Filter by: name");
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (this.model == null) {
            if (this.provider == null) {
                this.provider = this.createProvider();
            }
            this.model = new LazyOutlineModel(this.provider, this);
        }
        return this.model;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.QUICK_LAZY_OUTLINE;
    }

    @Override
    public Objection getObjection() {
        return Objection.QUICK_OUTLINE;
    }

    @Override
    public LazyOutlineTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    @Override
    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.project, "F636F7265")) {
                return;
            }
            this.getShell().setText(this.getTitle());
            this.setTitleText(this.getTitle());
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public String getMessageText() {
        if (!this.getTextFilterObject("default-filter").getTextFilterText().isEmpty()) {
            if (this.model.hasSearchedElementPreferenceFiltered()) {
                return LazyTreeMessageCompositeType.OUTLINE_ELEMENT_FILTERED.getMessage();
            }
            if (this.model.hasSearchedElementContentFiltered()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.model.hasPreferenceFilteredElements()) {
            return LazyTreeMessageCompositeType.OUTLINE_ELEMENT_FILTERED.getMessage();
        }
        if (this.model.hasContentFilteredElements()) {
            return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    protected String getTitle() {
        IDVTModel model = this.getModel(IDVTModel.class);
        if (!(model instanceof ILazyOutlineModel)) {
            return "";
        }
        ILazyOutlineModel outlineModel = (ILazyOutlineModel)model;
        boolean hasGUIFilters = outlineModel.hasContentFilteredElements() || outlineModel.hasPreferenceFilteredElements();
        return String.valueOf(hasGUIFilters ? "*" : "") + TITLE + (this.project != null ? " [" + this.project.getName() + "]" : "");
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider.getLabelProvider();
    }

    @Override
    protected void gotoSelectedElement() {
        if (this.project == null) {
            return;
        }
        TreePath selectedPath = this.getSelectedPath();
        if (selectedPath == null) {
            return;
        }
        this.goToElement(selectedPath);
    }

    @Override
    protected void goToElement(TreePath selection) {
        try {
            Object element = selection.getElement();
            if (element == null) {
                return;
            }
            int line = -1;
            if (element instanceof IRfDefElement) {
                line = ((IRfDefElement)element).getStartLine();
            } else if (element instanceof IDVTElementWrapper && ((IDVTElementWrapper)element).getRfElement() instanceof AST) {
                line = ((AST)((IDVTElementWrapper)element).getRfElement()).getLine();
            } else {
                return;
            }
            line = line == 0 ? 0 : line - 1;
            IDocument document = this.editor.getDocument();
            if (document == null) {
                return;
            }
            this.editor.selectAndReveal(document.getLineOffset(line), document.getLineLength(line));
            this.close();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void update(boolean b) {
        this.update();
    }

    @Override
    public void update() {
        this.model.clearCache();
        this.getLazyTree().doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.getModel(IModel.class), false, true, true, this.getObjection()));
    }

    @Override
    protected String getId() {
        return ID;
    }

    public Comparator<TreePath> getComparator() {
        if (this.model == null) {
            return null;
        }
        return this.model.getComparator();
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.createLanguageSpecificActions();
        dialogMenu.add((IContributionItem)new Separator("Filters"));
        dialogMenu.add(this.categorySelectAction);
        dialogMenu.add((IContributionItem)new Separator("Sorters"));
        dialogMenu.add(this.lexicalSortingAction);
        dialogMenu.add(this.categorySortingAction);
    }

    @Override
    public boolean close() {
        boolean val = super.close();
        this.dispose();
        return val;
    }

    @Override
    public void dispose() {
        if (this.model != null) {
            this.model.clean();
        }
        this.model = null;
        this.provider = null;
        this.editor = null;
        this.categorySelectAction = null;
        this.categorySortingAction = null;
        this.lexicalSortingAction = null;
        this.propertyChangeListener = null;
        super.dispose();
    }

    protected abstract void createLanguageSpecificActions();

    protected abstract AbstractLazyOutlineProvider createProvider();

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.getLabelProvider();
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return this.getSearchPort("default-filter");
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        return this.model.hasContentFilteredElements();
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }
}

