/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotificationJob;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathListener;

public enum DPMListenerManager {
    INSTANCE;

    private Map<DVTEditor, Set<IDesignPathListener>> editorsMap = new LinkedHashMap<DVTEditor, Set<IDesignPathListener>>();
    private Map<IDesignPathListener, DPMNotificationJob> jobsMap = Collections.synchronizedMap(new HashMap());
    public static final int NOTIFICATION_DELAY = 300;
    static final String NOTIFY_LISTENER_JOB = "Notifying tree listeners for ";

    public void register(DVTEditor editor, IDesignPathListener listener) {
        if (!DesignPathManager.getInstance().isEligible(editor) || listener == null) {
            return;
        }
        if (!this.editorsMap.containsKey(editor)) {
            this.editorsMap.put(editor, new HashSet());
        }
        this.editorsMap.get(editor).add(listener);
    }

    public void unregister(DVTEditor editor) {
        if (!DesignPathManager.getInstance().isEligible(editor)) {
            return;
        }
        Set<IDesignPathListener> listeners = this.editorsMap.remove(editor);
        if (listeners == null) {
            return;
        }
        for (IDesignPathListener l : listeners) {
            DPMNotificationJob oldJob = this.jobsMap.remove(l);
            if (oldJob == null) continue;
            oldJob.cancel();
        }
    }

    public void notifyListeners(DVTEditor editor, DPMNotification.DPMNotificationKind kind) {
        if (!DesignPathManager.getInstance().isEligible(editor)) {
            return;
        }
        if (DesignPathManager.getInstance().isFrozen(editor.getProject())) {
            return;
        }
        if (this.editorsMap.get(editor) == null) {
            return;
        }
        if (this.isNotificationInhibited(editor.getCurrentFile(), kind == DPMNotification.DPMNotificationKind.FORCE_UPDATE)) {
            return;
        }
        for (IDesignPathListener l : this.editorsMap.get(editor)) {
            this.notifyListener(l, kind);
        }
    }

    public void notifyListener(IDesignPathListener listener, DPMNotification.DPMNotificationKind kind) {
        try {
            DVTEditor editor = listener.getDVTEditor();
            if (!DesignPathManager.getInstance().isEligible(editor) || this.isNotificationInhibited(editor.getCurrentFile(), kind == DPMNotification.DPMNotificationKind.FORCE_UPDATE)) {
                return;
            }
            if (DesignPathManager.getInstance().isFrozen(editor.getProject())) {
                return;
            }
            DPMNotificationJob notifyListenerJob = new DPMNotificationJob(kind, listener);
            DPMNotificationJob oldJob = this.jobsMap.put(listener, notifyListenerJob);
            if (oldJob != null) {
                if (kind == null && oldJob.getKind() != null) {
                    return;
                }
                oldJob.cancel();
                kind = DPMNotification.DPMNotificationKind.FORCE_UPDATE;
            }
            notifyListenerJob.setSystem(true);
            notifyListenerJob.schedule(kind == null ? 300 : 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void dispose(IDesignPathListener listener, DPMNotificationJob job) {
        this.jobsMap.remove(listener, (Object)job);
    }

    private boolean isNotificationInhibited(IFile file, boolean ignoreInhibit) {
        if (file == null || ignoreInhibit) {
            return false;
        }
        try {
            Object property = file.getSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN);
            return property != null;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }
}

