/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.pathmanager.DPMListenerManager;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathListener;

final class DPMNotificationJob
extends Job {
    private final DPMNotification.DPMNotificationKind kind;
    private final IDesignPathListener listener;
    private IProgressMonitor monitor;
    private static final String JOB_NAME = "Notifying a DPM listener for ";

    public DPMNotificationJob(DPMNotification.DPMNotificationKind kind, IDesignPathListener listener) {
        super(JOB_NAME + listener.getDVTEditor().getCurrentFile().getName());
        this.kind = kind;
        this.listener = listener;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                this.monitor = monitor;
                Job treeUpdateJob = DesignPathManager.getInstance().getTreeUpdateJob(this.listener.getDVTEditor());
                if (treeUpdateJob != null) {
                    treeUpdateJob.join();
                }
                this.listener.designPathNotification(new DPMNotification(this.listener, this.kind));
            }
            catch (InterruptedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                DPMListenerManager.INSTANCE.dispose(this.listener, this);
                return iStatus;
            }
        }
        finally {
            DPMListenerManager.INSTANCE.dispose(this.listener, this);
        }
        return Status.OK_STATUS;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public DPMNotification.DPMNotificationKind getKind() {
        return this.kind;
    }
}

