/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.pathmanager.DPMListenerManager;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManagerCommon;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTree;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTreeCommon;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class DesignPathManager
extends DesignPathManagerCommon {
    private static final String UPDATE_TREE_JOB = "Updating region tree for ";
    private static DesignPathManager INSTANCE;
    private static final Object LOCK;
    private Map<DVTEditor, Job> treeUpdateJobs = Collections.synchronizedMap(new HashMap());

    static {
        LOCK = new Object();
    }

    private DesignPathManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DesignPathManager getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new DesignPathManager();
            }
        }
        return INSTANCE;
    }

    @Override
    public void unfreeze(IProject project) {
        super.unfreeze(project);
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        for (IEditorReference iEditorReference : Utils.getCurrentlyOpenEditorReferences()) {
            IEditorPart editor = iEditorReference.getEditor(false);
            if (!(editor instanceof DVTEditor) || !activePage.isPartVisible((IWorkbenchPart)editor)) continue;
            this.registerEditor((DVTEditor)editor);
        }
        for (Map.Entry entry : this.getEntrySet()) {
            IDVTBreadcrumbTextHost bcHost = (IDVTBreadcrumbTextHost)entry.getKey();
            if (!(bcHost instanceof DVTEditor)) {
                return;
            }
            DVTEditor dvtEditor = (DVTEditor)bcHost;
            RegionTreeCommon editorTree = (RegionTreeCommon)entry.getValue();
            editorTree.setDirty(true);
            if (!activePage.isPartVisible((IWorkbenchPart)dvtEditor)) continue;
            DPMListenerManager.INSTANCE.notifyListeners(dvtEditor, DPMNotification.DPMNotificationKind.FORCE_UPDATE);
        }
    }

    public boolean isMetadataDifferent(DVTEditor editor) {
        boolean differentFileInstance;
        IEditorInput currentEditorInput;
        IDesignPathProvider pathProvider = editor.getDesignPathProvider();
        if (pathProvider == null) {
            return true;
        }
        RegionTreeCommon tree = this.getTree(editor);
        if (!(tree instanceof RegionTree)) {
            return true;
        }
        RegionTree editorTree = (RegionTree)tree;
        IEditorInput oldEditorInput = editorTree.getCachedEditorInput();
        if (oldEditorInput != (currentEditorInput = editor.getEditorInput())) {
            return true;
        }
        ElementPath potentialPathFromScope = pathProvider.getPathFromIncludeScope(editor.getCurrentFile(), false);
        IDVTFileInstance potentialInstance = pathProvider.getFileInstance(editor.getCurrentFile(), false);
        boolean differentPathFromScope = editorTree.getPathFromScope() != potentialPathFromScope && potentialPathFromScope != null;
        boolean bl = differentFileInstance = editorTree.getFileInstance() != potentialInstance && potentialInstance != null;
        return differentFileInstance || differentPathFromScope;
    }

    public IRfNamedElement getElementFor(DVTEditor editor, int offset, boolean computeIfDirty) {
        if (this.isFrozen(editor.getProject())) {
            return null;
        }
        RegionTreeCommon editorTree = this.getTree(editor);
        if (!(editorTree instanceof RegionTree)) {
            return null;
        }
        if (editorTree.isDirty() && !computeIfDirty) {
            return null;
        }
        return ((RegionTree)editorTree).getElementFor(offset);
    }

    @Override
    public ElementPath getPathFor(IDVTBreadcrumbTextHost bcHost, int offset, boolean parentIfNotElab, boolean computeIfDirty) {
        ElementPath pathFromOffset = super.getPathFor(bcHost, offset, parentIfNotElab, computeIfDirty);
        if (pathFromOffset != null) {
            return pathFromOffset;
        }
        RegionTreeCommon regionTree = this.getTree(bcHost);
        return regionTree instanceof RegionTree ? ((RegionTree)regionTree).getPathFromScope() : null;
    }

    @Override
    public void updateFor(final IDVTBreadcrumbTextHost editor, final ElementPath path) {
        try {
            if (!(editor instanceof DVTEditor) || path == null) {
                ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
                return;
            }
            if (this.isFrozen(editor.getProject())) {
                ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
                return;
            }
            final RegionTreeCommon editorTree = this.getTree(editor);
            if (!(editorTree instanceof RegionTree)) {
                ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
                return;
            }
            DVTEditor dvtEditor = (DVTEditor)editor;
            Job treeUpdateJob = new Job(UPDATE_TREE_JOB + dvtEditor.getCurrentFile().getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    ((RegionTree)editorTree).updateFor(path);
                    DesignPathManager.this.treeUpdateJobs.remove(editor);
                    ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
                    return Status.OK_STATUS;
                }
            };
            Job oldJob = this.treeUpdateJobs.remove(editor);
            if (oldJob != null) {
                oldJob.cancel();
            }
            this.treeUpdateJobs.put(dvtEditor, treeUpdateJob);
            treeUpdateJob.setSystem(true);
            treeUpdateJob.schedule();
            DPMListenerManager.INSTANCE.notifyListeners(dvtEditor, DPMNotification.DPMNotificationKind.FORCE_UPDATE);
            IFile file = dvtEditor.getCurrentFile();
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, null);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Job getTreeUpdateJob(DVTEditor editor) {
        if (!this.isEligible(editor)) {
            return null;
        }
        return this.treeUpdateJobs.get(editor);
    }

    @Override
    public boolean isEligible(IDVTBreadcrumbHost editor) {
        if (!(editor instanceof DVTEditor)) {
            return false;
        }
        DVTEditor dvtEditor = (DVTEditor)editor;
        if (dvtEditor.getCurrentFile() == null) {
            return false;
        }
        return dvtEditor.getDesignPathProvider() != null;
    }

    public IDVTFileInstance getFileInstanceFor(IDVTBreadcrumbHost editor) {
        if (!(editor instanceof IDVTBreadcrumbTextHost)) {
            return null;
        }
        RegionTreeCommon regionTree = this.getTree((IDVTBreadcrumbTextHost)editor);
        if (!(regionTree instanceof RegionTree)) {
            return null;
        }
        return ((RegionTree)regionTree).getFileInstance();
    }

    public Collection<ElementPath> testGetAllPathsFor(DVTEditor editor) {
        RegionTreeCommon regionTree = this.getTree(editor);
        if (regionTree == null) {
            return Collections.emptyList();
        }
        return regionTree.testGetAllPaths();
    }

    public boolean testIsDirty(IEditorPart editor) {
        if (!(editor instanceof DVTEditor)) {
            return false;
        }
        RegionTreeCommon tree = this.getTree((DVTEditor)editor);
        if (tree == null) {
            return false;
        }
        return tree.testIsDirty();
    }
}

