/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTree;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTreeCommon;

public abstract class DesignPathManagerCommon {
    private Map<String, Boolean> isFrozenMap;
    private Map<IDVTBreadcrumbTextHost, RegionTreeCommon> bcHostMapping = new HashMap<IDVTBreadcrumbTextHost, RegionTreeCommon>();
    public static final ElementPath FROZEN_MANAGER_EL_PATH = ElementPath.EMPTY_PATH;

    protected DesignPathManagerCommon() {
        this.isFrozenMap = new ConcurrentHashMap<String, Boolean>();
    }

    public boolean isFrozen(IProject project) {
        if (project == null) {
            return true;
        }
        Boolean isFrozen = this.isFrozenMap.get(project.getName());
        if (isFrozen == null) {
            return false;
        }
        return isFrozen;
    }

    public void freeze(IProject project) {
        if (project == null) {
            return;
        }
        this.isFrozenMap.put(project.getName(), true);
    }

    public void unfreeze(IProject project) {
        if (project == null) {
            return;
        }
        this.isFrozenMap.put(project.getName(), false);
    }

    public void remove(IProject project) {
        if (project == null) {
            return;
        }
        this.isFrozenMap.remove(project.getName());
    }

    protected Set<Map.Entry<IDVTBreadcrumbTextHost, RegionTreeCommon>> getEntrySet() {
        return this.bcHostMapping.entrySet();
    }

    protected RegionTreeCommon getTree(IDVTBreadcrumbTextHost bcHost) {
        return this.bcHostMapping.get(bcHost);
    }

    protected void putTree(IDVTBreadcrumbTextHost bcHost, RegionTreeCommon tree) {
        this.bcHostMapping.put(bcHost, tree);
    }

    public boolean isRegistered(IDVTBreadcrumbTextHost bcHost) {
        return this.bcHostMapping.get(bcHost) != null;
    }

    public void setDirty(IDVTBreadcrumbTextHost bcHost, boolean isDirty) {
        RegionTreeCommon editorTree = this.bcHostMapping.get(bcHost);
        if (editorTree == null) {
            return;
        }
        editorTree.setDirty(isDirty);
    }

    public boolean isEligible(IDVTBreadcrumbHost bcHost) {
        if (!(bcHost instanceof DVTEditor)) {
            return false;
        }
        DVTEditor dvtEditor = (DVTEditor)bcHost;
        IFile currentFile = dvtEditor.getCurrentFile();
        if (currentFile == null) {
            return false;
        }
        return dvtEditor.getDesignPathProvider() != null;
    }

    public void registerEditor(IDVTBreadcrumbTextHost bcHost) {
        if (!this.isEligible(bcHost)) {
            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
            return;
        }
        RegionTreeCommon editorTree = this.bcHostMapping.get(bcHost);
        if (editorTree != null) {
            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
            return;
        }
        editorTree = new RegionTree(bcHost);
        editorTree.setDirty(true);
        this.bcHostMapping.put(bcHost, editorTree);
        ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
    }

    public void unregister(IDVTBreadcrumbTextHost bcHost) {
        if (!this.isEligible(bcHost)) {
            return;
        }
        RegionTreeCommon editorTree = this.bcHostMapping.get(bcHost);
        if (editorTree == null) {
            return;
        }
        editorTree.clean();
        this.bcHostMapping.remove(bcHost);
    }

    public ElementPath getPathFor(IDVTBreadcrumbTextHost bcHost) {
        return this.getPathFor(bcHost, 0, true, false);
    }

    public ElementPath getPathFor(IDVTBreadcrumbTextHost bcHost, int offset, boolean parentIfNotElab, boolean computeIfDirty) {
        if (this.isFrozen(bcHost.getProject())) {
            return FROZEN_MANAGER_EL_PATH;
        }
        RegionTreeCommon editorTree = this.bcHostMapping.get(bcHost);
        if (editorTree == null) {
            return null;
        }
        if (editorTree.isDirty() && !computeIfDirty) {
            return null;
        }
        return editorTree.getPathFromOffset(offset, parentIfNotElab, false);
    }

    public IRegion getRegionFor(IDVTBreadcrumbHost bcHost, int offset, boolean computeIfDirty) {
        if (bcHost == null) {
            return null;
        }
        if (this.isFrozen(bcHost.getProject())) {
            return null;
        }
        RegionTreeCommon hostTree = this.bcHostMapping.get(bcHost);
        if (hostTree == null) {
            return null;
        }
        if (hostTree.isDirty() && !computeIfDirty) {
            return null;
        }
        return hostTree.getRegion(offset);
    }

    public boolean hasElaboratedDesignElements(IDVTBreadcrumbHost bcHost) {
        if (this.isFrozen(bcHost.getProject())) {
            return false;
        }
        RegionTreeCommon hostTree = this.bcHostMapping.get(bcHost);
        if (hostTree == null) {
            return false;
        }
        return hostTree.hasElaboratedDesignElements();
    }

    public ElementPath removeTrailingGenerateSegments(IProject project, IRfNamedElement element, ElementPath pathFromOffset) {
        if (element == null || pathFromOffset == null || pathFromOffset.isEmpty() || project == null) {
            return pathFromOffset;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return pathFromOffset;
        }
        ELInstance instance = memory.instanceFor(pathFromOffset);
        if (instance == null) {
            return pathFromOffset;
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        boolean stripToEntity = IRfNamedElement.ElementKind.VHDL_ENTITY == DesignUtils.getDesignKind(enclosingScope);
        IRfNamedElement binding = instance.getBinding(stripToEntity);
        while (binding != enclosingScope) {
            if (!memory.isGenerateBlock(pathFromOffset)) {
                return pathFromOffset;
            }
            if ((pathFromOffset = pathFromOffset.removeLastSegment()).isEmpty()) {
                return pathFromOffset;
            }
            instance = memory.instanceFor(pathFromOffset);
            binding = instance.getBinding(stripToEntity);
        }
        return pathFromOffset;
    }

    public boolean appendInstanceScope(IRfNamedElement element, IRfScopeElement scopeElement) {
        if (element instanceof IRfInstanceElement) {
            return true;
        }
        boolean isHierarchical = false;
        if (element instanceof HierarchicalElement) {
            element = ((HierarchicalElement)element).getFirstSegment();
            isHierarchical = true;
        }
        if (scopeElement instanceof IRfDefElement) {
            scopeElement = ((IRfDefElement)((Object)scopeElement)).getNamedElement();
        }
        if (!(scopeElement instanceof IRfInstanceElement) || element == null) {
            return false;
        }
        IRfScopeElement enclosingScopeElement = scopeElement.getEnclosingScope();
        while (enclosingScopeElement != null) {
            if (enclosingScopeElement instanceof IRfDesignElement) {
                if ((isHierarchical && element instanceof IRfInstanceElement || element instanceof IRfFieldElement || RfSearchUtils.isPortOrParameterElement(element)) && enclosingScopeElement.equals(element.getEnclosingScope())) {
                    return false;
                }
                if (element instanceof IRfDesignElement && enclosingScopeElement.equals(element)) {
                    return false;
                }
            }
            enclosingScopeElement = enclosingScopeElement.getEnclosingScope();
        }
        return true;
    }

    public ElementPath getPathFor(DVTEditor editor, int offset, IRfNamedElement element, IRfScopeElement scope, boolean parentIfNotElab, boolean computeIfDirty) {
        if (editor == null || element == null) {
            return null;
        }
        if (this.isFrozen(editor.getProject())) {
            return FROZEN_MANAGER_EL_PATH;
        }
        RegionTreeCommon editorTree = this.getTree(editor);
        if (!(editorTree instanceof RegionTree)) {
            return null;
        }
        if (editorTree.isDirty() && !computeIfDirty) {
            return null;
        }
        ElementPath pathFromOffset = editorTree.getPathFromOffset(offset, parentIfNotElab, this.appendInstanceScope(element, scope));
        pathFromOffset = this.removeTrailingGenerateSegments(editor.getProject(), element, pathFromOffset);
        return pathFromOffset != null ? pathFromOffset : ((RegionTree)editorTree).getPathFromScope();
    }

    public ElementPath getPathFor(DVTEditor editor, IRfNamedElement designElement, boolean computeIfDirty) {
        if (editor == null) {
            return null;
        }
        if (this.isFrozen(editor.getProject())) {
            return FROZEN_MANAGER_EL_PATH;
        }
        RegionTreeCommon editorTree = this.getTree(editor);
        if (!(editorTree instanceof RegionTree)) {
            return null;
        }
        if (editorTree.isDirty() && !computeIfDirty) {
            return null;
        }
        return ((RegionTree)editorTree).getPathFromElement(designElement);
    }

    public List<IRfNamedElement> getDesignSegmentsFromElementPath(IProject project, ElementPath elementPath) {
        if (elementPath == null || elementPath.isEmpty()) {
            return Collections.emptyList();
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return Collections.emptyList();
        }
        elementPath = elementPath.toElaborationForm();
        IELMemory memory = elManager.getMemory();
        LinkedList<IRfNamedElement> designSegments = new LinkedList<IRfNamedElement>();
        while (elementPath != null && !elementPath.isEmpty()) {
            IRfInstanceElement description;
            ELInstance instanceFor = memory.instanceFor(elementPath);
            elementPath = elementPath.removeLastSegment();
            if (instanceFor == null || (description = instanceFor.getDescription()) == null) continue;
            IRfInstanceElement segment = description instanceof DummyInstance ? ((DummyInstance)description).design : description;
            designSegments.add(0, segment);
        }
        return designSegments;
    }

    public boolean isOffsetInsideRegion(IRegion region, int offset) {
        if (region == null) {
            return false;
        }
        return offset >= region.getOffset() && offset <= region.getOffset() + region.getLength() + 1;
    }

    public abstract void updateFor(IDVTBreadcrumbTextHost var1, ElementPath var2);
}

