/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;

public class DesignPathManagerUtils {
    public static Map<IRfNamedElement, ElementPath> getAllPathsWithPrefix(final Set<IRfNamedElement> bindings, ElementPath prefix, IProject project) {
        IRfInstanceElement instance;
        if (bindings == null || bindings.isEmpty()) {
            return null;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return null;
        }
        Map<ElementPath, ELInstance> subTree = memory.subtreeOf(prefix, false);
        final HashMap<IRfNamedElement, ElementPath> paths = new HashMap<IRfNamedElement, ElementPath>();
        ELInstance elInstance = memory.instanceFor(prefix);
        if (elInstance == null) {
            return null;
        }
        IRfNamedElement binding = elInstance.getBinding(false);
        if (binding != null) {
            paths.put(binding, prefix);
        }
        if ((instance = elInstance.getDescription()) != null) {
            paths.put(instance, prefix);
        }
        IELMemory.IELMemoryVisitor memoryVisitor = new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfInstanceElement description;
                IRfNamedElement archBinding = instance.getBinding(false);
                if (bindings.contains(archBinding)) {
                    paths.put(archBinding, path);
                    bindings.remove(archBinding);
                }
                if (bindings.contains(description = instance.getDescription())) {
                    paths.put(description, path);
                    bindings.remove(description);
                }
                return !bindings.isEmpty();
            }
        };
        for (Map.Entry<ElementPath, ELInstance> child : subTree.entrySet()) {
            if (!memoryVisitor.visitBindings(child.getKey(), child.getValue())) break;
        }
        return paths;
    }
}

