/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProviderCommon;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public interface IDesignPathProvider
extends IDesignPathProviderCommon {
    public static void updatePathManagerForActiveEditor(TreePath path) {
        if (path == null) {
            return;
        }
        Object element = path.getElement();
        if (!(element instanceof IRfNamedElement) || element instanceof RfDummyElement) {
            return;
        }
        IRfNamedElement namedElement = (IRfNamedElement)element;
        boolean includeSelf = DesignUtils.isBlock(namedElement) || path.getSegments() != null && path.getSegments().length == 1;
        List<ElementPath> paths = TreePathUtils.getELElementsFromPath(path, includeSelf);
        ElementPath elementPath = paths.get(paths.size() - 1);
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (activeEditor instanceof DVTEditor) {
            DesignPathManager.getInstance().updateFor((DVTEditor)activeEditor, elementPath);
        }
    }

    public static void updatePathManagerForActiveEditor(ElementPath elementPath) {
        if (elementPath == null) {
            return;
        }
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (activeEditor instanceof DVTEditor) {
            DesignPathManager.getInstance().updateFor((DVTEditor)activeEditor, elementPath);
        }
    }

    public static void setTypesDataForPathManager(IDVTElementWrapper wrapper) {
        try {
            if (wrapper == null) {
                return;
            }
            Object element = wrapper.getRfElement();
            if (!(element instanceof IRfNamedElement)) {
                return;
            }
            IRfDefElement declaration = ((IRfNamedElement)element).getDeclaration();
            if (declaration == null) {
                return;
            }
            IRfFileDef fileDef = declaration.getDefFile();
            if (fileDef == null) {
                return;
            }
            IResource file = (IResource)fileDef.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, (Object)wrapper);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    default public ElementPath getPathFromIncludeScope(IFile file, boolean reset) {
        Object pathFromScope;
        block6: {
            block5: {
                try {
                    if (file != null) break block5;
                    return null;
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            pathFromScope = file.getSessionProperty(IDVTConstants.PATH_FROM_INCLUDE_SCOPE_QN);
            if (pathFromScope instanceof ElementPath) break block6;
            return null;
        }
        if (reset) {
            file.setSessionProperty(IDVTConstants.PATH_FROM_INCLUDE_SCOPE_QN, null);
        }
        return (ElementPath)pathFromScope;
    }

    public static ELInstance getInstancePrefixedBy(IELMemory memory, ElementPath prefix, IRfNamedElement element) {
        Map<ElementPath, ELInstance> subTree = memory.subtreeOf(prefix, false);
        for (Map.Entry<ElementPath, ELInstance> child : subTree.entrySet()) {
            if (!IDesignPathProviderCommon.hasDescriptionOrBinding(element, child.getValue())) continue;
            return child.getValue();
        }
        return null;
    }

    public static Object getPathFromTCNode(TCNode node) {
        if (node == null || node.namedElement == null) {
            return null;
        }
        return node.getElementPath();
    }

    public String getLangNature();

    @Override
    public IDVTFileInstance getFileInstance(IFile var1, boolean var2);

    @Override
    public IRfFileDef getFileDef(IProject var1, IFile var2);

    public IRfNamedElement getBindingInScope(IRfDefElement var1, IDVTFileInstance var2);

    default public boolean isPort(IRfFieldElement field) {
        return false;
    }

    default public void checkPathFromInclude(IProject project, ElementPath elementPath, String filePath) {
    }
}

