/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public interface IDesignPathProviderCommon {
    public static ElementPath getPathPrefixedBy(IELMemory memory, ElementPath prefix, IRfNamedElement element, boolean childrenOnly) {
        Map<ElementPath, ELInstance> subTree = memory.subtreeOf(prefix, false);
        for (Map.Entry<ElementPath, ELInstance> child : subTree.entrySet()) {
            if (!IDesignPathProviderCommon.hasDescriptionOrBinding(element, child.getValue())) continue;
            return child.getKey();
        }
        if (!childrenOnly && IDesignPathProviderCommon.hasDescriptionOrBinding(element, memory.instanceFor(prefix))) {
            return prefix;
        }
        return null;
    }

    public static boolean hasDescriptionOrBinding(IRfNamedElement element, ELInstance instance) {
        IRfInstanceElement description = instance.getDescription();
        if (element instanceof IRfInstanceElement) {
            return description != null && description.equals(element);
        }
        IRfNamedElement entBinding = instance.getBinding(true);
        if (entBinding != null && entBinding.equals(element)) {
            return true;
        }
        IRfNamedElement archBinding = instance.getBinding(false);
        if (archBinding != null && archBinding.equals(element)) {
            return true;
        }
        if (description == null) {
            return false;
        }
        IRfDesignElement compBinding = description.getVHDLPreElaborationDesign();
        return compBinding != null && compBinding.equals(element);
    }

    default public ElementPath getFirstPathFor(IRfNamedElement scope, IProject project) {
        if (scope == null) {
            return null;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return null;
        }
        List<ElementPath> pathsFor = memory.getInstancePathsFor(scope, 1);
        if (pathsFor == null || pathsFor.isEmpty()) {
            return null;
        }
        return pathsFor.get(0);
    }

    default public Map<IRfNamedElement, ElementPath> getAllPathsWithPrefix(Set<IRfNamedElement> allNamedElements, ElementPath prefix, IProject project) {
        return null;
    }

    default public void setSessionProperty(IProject project, DVTEditor editor, IDVTFileInstance instance, String path) {
    }

    default public void populateInstanceMap(final Map<IRfDefElement, ElementPath> paths, Set<IRfNamedElement> topBindings, final ElementPath pathFromInclude, IProject project) {
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return;
        }
        if (paths == null || topBindings == null) {
            return;
        }
        if (topBindings.isEmpty()) {
            return;
        }
        final HashSet<IRfNamedElement> topBindingsCopy = new HashSet<IRfNamedElement>(topBindings);
        memory.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfConfiguration configBinding;
                IRfNamedElement entBinding;
                if (pathFromInclude != null && !path.startsWith(pathFromInclude)) {
                    return true;
                }
                IRfNamedElement archBinding = instance.getBinding(false);
                if (topBindingsCopy.contains(archBinding)) {
                    paths.put(archBinding.getDeclaration(), path);
                }
                if (topBindingsCopy.contains(entBinding = instance.getBinding(true))) {
                    paths.put(entBinding.getDeclaration(), path);
                }
                if (topBindingsCopy.contains(configBinding = instance.getElaborationConfig())) {
                    paths.put(configBinding.getDeclaration(), path);
                }
                topBindingsCopy.remove(archBinding);
                topBindingsCopy.remove(entBinding);
                topBindingsCopy.remove(configBinding);
                return !topBindingsCopy.isEmpty();
            }
        });
    }

    public IRfNamedElement getScopeFromFileInstance(IDVTFileInstance var1);

    default public boolean interestingDesignElement(Object child) {
        return true;
    }

    public IDVTFileInstance getFileInstance(IFile var1, boolean var2);

    public IRfFileDef getFileDef(IProject var1, IFile var2);

    public boolean validDesignScope(Object var1);

    public boolean isInstanceDef(IRfDefElement var1);

    public Set<IRfNamedElement> getNamedElementsSet(IRfDefElement var1);

    public IRfNamedElement computeHyperlinkNamedElement(IRfNamedElement var1, IRfDesignElement var2, boolean var3);
}

